/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.ResponseStateManagerImpl;
import com.sun.faces.renderkit.html_basic.HtmlResponseWriter;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;

public class RenderKitImpl
extends RenderKit {
    private static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final String SUPPORTED_CONTENT_TYPES = "text/html,application/xhtml+xml,application/xml,text/xml";
    private static final String SUPPORTED_PARTIAL_CONTENT_TYPES = "text/xml";
    private ConcurrentHashMap<String, HashMap<String, Renderer>> rendererFamilies = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClientBehaviorRenderer> behaviorRenderers = new ConcurrentHashMap();
    private ResponseStateManager responseStateManager = new ResponseStateManagerImpl();
    private WebConfiguration webConfig;

    public RenderKitImpl() {
        FacesContext context = FacesContext.getCurrentInstance();
        this.webConfig = WebConfiguration.getInstance(context.getExternalContext());
    }

    @Override
    public void addRenderer(String family, String rendererType, Renderer renderer) {
        Util.notNull("family", family);
        Util.notNull("rendererType", rendererType);
        Util.notNull("renderer", renderer);
        HashMap<String, Renderer> renderers = this.rendererFamilies.get(family);
        if (renderers == null) {
            renderers = new HashMap();
            this.rendererFamilies.put(family, renderers);
        }
        if (LOGGER.isLoggable(Level.FINE) && renderers.containsKey(rendererType)) {
            LOGGER.log(Level.FINE, "rendererType {0} has already been registered for family {1}.  Replacing existing renderer class type {2} with {3}.", new Object[]{rendererType, family, renderers.get(rendererType).getClass().getName(), renderer.getClass().getName()});
        }
        renderers.put(rendererType, renderer);
    }

    @Override
    public Renderer getRenderer(String family, String rendererType) {
        Util.notNull("family", family);
        Util.notNull("rendererType", rendererType);
        assert (this.rendererFamilies != null);
        HashMap<String, Renderer> renderers = this.rendererFamilies.get(family);
        return renderers != null ? renderers.get(rendererType) : null;
    }

    @Override
    public void addClientBehaviorRenderer(String behaviorRendererType, ClientBehaviorRenderer behaviorRenderer) {
        Util.notNull("behaviorRendererType", behaviorRendererType);
        Util.notNull("behaviorRenderer", behaviorRenderer);
        if (LOGGER.isLoggable(Level.FINE) && this.behaviorRenderers.containsKey(behaviorRendererType)) {
            LOGGER.log(Level.FINE, "behaviorRendererType {0} has already been registered.  Replacing existing behavior renderer class type {1} with {2}.", new Object[]{behaviorRendererType, this.behaviorRenderers.get(behaviorRendererType).getClass().getName(), behaviorRenderer.getClass().getName()});
        }
        this.behaviorRenderers.put(behaviorRendererType, behaviorRenderer);
    }

    @Override
    public ClientBehaviorRenderer getClientBehaviorRenderer(String behaviorRendererType) {
        Util.notNull("behaviorRendererType", behaviorRendererType);
        return this.behaviorRenderers != null ? this.behaviorRenderers.get(behaviorRendererType) : null;
    }

    @Override
    public Iterator<String> getClientBehaviorRendererTypes() {
        if (null == this.behaviorRenderers) {
            Set empty = Collections.emptySet();
            return empty.iterator();
        }
        return ((ConcurrentHashMap.KeySetView)this.behaviorRenderers.keySet()).iterator();
    }

    @Override
    public synchronized ResponseStateManager getResponseStateManager() {
        if (this.responseStateManager == null) {
            this.responseStateManager = new ResponseStateManagerImpl();
        }
        return this.responseStateManager;
    }

    @Override
    public ResponseWriter createResponseWriter(Writer writer, String desiredContentTypeList, String characterEncoding) {
        if (writer == null) {
            return null;
        }
        String contentType = null;
        boolean contentTypeNullFromResponse = false;
        FacesContext context = FacesContext.getCurrentInstance();
        boolean isPartial = context.getPartialViewContext().isPartialRequest();
        if (null != desiredContentTypeList) {
            contentType = this.getSupportedContentType(desiredContentTypeList, isPartial);
        }
        if (null == desiredContentTypeList && null != (desiredContentTypeList = context.getExternalContext().getResponseContentType()) && null == (contentType = this.getSupportedContentType(desiredContentTypeList, isPartial))) {
            contentTypeNullFromResponse = true;
        }
        if (null == desiredContentTypeList || contentTypeNullFromResponse) {
            String[] typeArray = context.getExternalContext().getRequestHeaderValuesMap().get("Accept");
            if (typeArray.length > 0) {
                StringBuffer buff = new StringBuffer();
                buff.append(typeArray[0]);
                int len = typeArray.length;
                for (int i = 1; i < len; ++i) {
                    buff.append(',');
                    buff.append(typeArray[i]);
                }
                desiredContentTypeList = buff.toString();
            }
            if (null != desiredContentTypeList && null != (desiredContentTypeList = RenderKitUtils.determineContentType(desiredContentTypeList, isPartial ? SUPPORTED_PARTIAL_CONTENT_TYPES : SUPPORTED_CONTENT_TYPES, this.getDefaultContentType(isPartial, null)))) {
                contentType = this.getSupportedContentType(desiredContentTypeList, isPartial);
            }
        }
        if (contentType == null) {
            if (null == desiredContentTypeList) {
                contentType = this.getDefaultContentType(isPartial, "text/html");
            } else {
                String[] desiredContentTypes = this.contentTypeSplit(desiredContentTypeList);
                for (String desiredContentType : desiredContentTypes) {
                    if (!"*/*".equals(desiredContentType.trim())) continue;
                    contentType = this.getDefaultContentType(isPartial, "text/html");
                }
            }
        }
        if (null == contentType) {
            throw new IllegalArgumentException(MessageUtils.getExceptionMessageString("com.sun.faces.CONTENT_TYPE_ERROR", new Object[0]));
        }
        if (characterEncoding == null) {
            characterEncoding = "UTF-8";
        }
        boolean scriptHiding = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableJSStyleHiding);
        boolean scriptInAttributes = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableScriptInAttributeValue);
        WebConfiguration.DisableUnicodeEscaping escaping = WebConfiguration.DisableUnicodeEscaping.getByValue(this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.DisableUnicodeEscaping));
        return new HtmlResponseWriter(writer, contentType, characterEncoding, scriptHiding, scriptInAttributes, escaping, isPartial);
    }

    private boolean preferXhtml() {
        return this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.PreferXHTMLContentType);
    }

    private String getDefaultContentType(boolean isPartial, String defaultContentType) {
        if (isPartial) {
            return SUPPORTED_PARTIAL_CONTENT_TYPES;
        }
        if (this.preferXhtml()) {
            return "application/xhtml+xml";
        }
        return defaultContentType;
    }

    private String[] contentTypeSplit(String contentTypeString) {
        Map<String, Object> appMap = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        String[] result = Util.split(appMap, contentTypeString, ",");
        for (int i = 0; i < result.length; ++i) {
            int semicolon = result[i].indexOf(";");
            if (-1 == semicolon) continue;
            result[i] = result[i].substring(0, semicolon);
        }
        return result;
    }

    private String getSupportedContentType(String desiredContentTypeList, boolean isPartial) {
        String contentType = null;
        for (String curDesiredType : this.contentTypeSplit(desiredContentTypeList)) {
            if (!isPartial && curDesiredType.contains("text/html")) {
                contentType = "text/html";
            } else if (!isPartial && (curDesiredType.contains("application/xhtml+xml") || curDesiredType.contains("application/xml") || curDesiredType.contains(SUPPORTED_PARTIAL_CONTENT_TYPES))) {
                contentType = "application/xhtml+xml";
            } else if (isPartial && curDesiredType.contains(SUPPORTED_PARTIAL_CONTENT_TYPES)) {
                contentType = SUPPORTED_PARTIAL_CONTENT_TYPES;
            }
            if (null != contentType) break;
        }
        return contentType;
    }

    @Override
    public ResponseStream createResponseStream(OutputStream out) {
        final OutputStream output = out;
        return new ResponseStream(){

            @Override
            public void write(int b) throws IOException {
                output.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                output.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                output.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                output.flush();
            }

            @Override
            public void close() throws IOException {
                output.close();
            }
        };
    }

    @Override
    public Iterator<String> getComponentFamilies() {
        return ((ConcurrentHashMap.KeySetView)this.rendererFamilies.keySet()).iterator();
    }

    @Override
    public Iterator<String> getRendererTypes(String componentFamily) {
        Map family = this.rendererFamilies.get(componentFamily);
        if (family != null) {
            return family.keySet().iterator();
        }
        Set empty = Collections.emptySet();
        return empty.iterator();
    }
}

