/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ext.component;

import com.sun.faces.ext.component.MessageFactory;
import com.sun.faces.ext.component.MultiFieldValidationUtils;
import com.sun.faces.ext.component.UIValidateWholeBean;
import com.sun.faces.ext.component.ValueExpressionAnalyzer;
import com.sun.faces.ext.component.ValueReference;
import com.sun.faces.util.BeanValidation;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.Util;
import com.sun.faces.util.copier.CopierUtils;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;

class WholeBeanValidator
implements javax.faces.validator.Validator<Object> {
    private static final Logger LOGGER = Logger.getLogger("javax.faces.validator", "javax.faces.LogStrings");
    private static final String ERROR_MISSING_FORM = "f:validateWholeBean must be nested directly in an UIForm.";

    WholeBeanValidator() {
    }

    @Override
    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        this.validate(context, (UIValidateWholeBean)component, value);
    }

    public void validate(FacesContext context, UIValidateWholeBean component, Object value) throws ValidatorException {
        UIForm form = this.getParentForm(component);
        ValueExpression wholeBeanVE = Util.getValueExpressionNullSafe(component, "value");
        Object wholeBean = wholeBeanVE.getValue(context.getELContext());
        String copierType = (String)component.getAttributes().get("copierType");
        if (this.hasAnyBeanPropertyFailedValidation(context, wholeBean)) {
            return;
        }
        AddRemainingCandidateFieldsCallback addRemainingCandidateFieldsCallback = new AddRemainingCandidateFieldsCallback(context, wholeBean);
        form.visitTree(VisitContext.createVisitContext(context), addRemainingCandidateFieldsCallback);
        Map<String, Map<String, Object>> validationCandidate = addRemainingCandidateFieldsCallback.getCandidate();
        if (validationCandidate.isEmpty()) {
            return;
        }
        Set<ConstraintViolation<?>> violations = this.doBeanValidation(BeanValidation.getBeanValidator(context), this.copyBeanAndPopulateWithCandidateValues(context, wholeBeanVE, wholeBean, copierType, validationCandidate), component.getValidationGroupsArray(), wholeBeanVE);
        if (violations != null && !violations.isEmpty()) {
            ValidatorException toThrow;
            if (violations.size() == 1) {
                ConstraintViolation<?> violation = violations.iterator().next();
                toThrow = new ValidatorException(MessageFactory.getMessage(context, "javax.faces.validator.BeanValidator.MESSAGE", violation.getMessage(), MessageFactory.getLabel(context, component)));
            } else {
                LinkedHashSet<FacesMessage> messages = new LinkedHashSet<FacesMessage>(violations.size());
                for (ConstraintViolation<?> violation : violations) {
                    messages.add(MessageFactory.getMessage(context, "javax.faces.validator.BeanValidator.MESSAGE", violation.getMessage(), MessageFactory.getLabel(context, component)));
                }
                toThrow = new ValidatorException(messages);
            }
            for (Map.Entry<String, Map<String, Object>> validationCandidateEntry : validationCandidate.entrySet()) {
                this.invalidateComponent(validationCandidateEntry);
            }
            throw toThrow;
        }
    }

    private UIForm getParentForm(UIComponent component) {
        UIComponent parent = component.getParent();
        if (!(parent instanceof UIForm)) {
            throw new IllegalArgumentException(ERROR_MISSING_FORM);
        }
        return (UIForm)parent;
    }

    private boolean isFailedFieldLevelValidation(Map.Entry<String, Map<String, Object>> wholeBeanPropertyEntry) {
        return "javax.faces.Bean.FAILED_FIELD_LEVEL_VALIDATION".equals(wholeBeanPropertyEntry.getValue().get("value"));
    }

    private void invalidateComponent(Map.Entry<String, Map<String, Object>> wholeBeanPropertyEntry) {
        ((EditableValueHolder)wholeBeanPropertyEntry.getValue().get("component")).setValid(false);
    }

    private boolean hasAnyBeanPropertyFailedValidation(FacesContext context, Object wholeBean) {
        Map<Object, Map<String, Map<String, Object>>> validationCandidates = MultiFieldValidationUtils.getMultiFieldValidationCandidates(context, false);
        if (context.isValidationFailed()) {
            return true;
        }
        if (!validationCandidates.isEmpty() && validationCandidates.containsKey(wholeBean)) {
            for (Map.Entry<String, Map<String, Object>> wholeBeanPropertyEntry : validationCandidates.get(wholeBean).entrySet()) {
                if (!this.isFailedFieldLevelValidation(wholeBeanPropertyEntry)) continue;
                return true;
            }
        }
        return false;
    }

    private Object copyBeanAndPopulateWithCandidateValues(FacesContext context, ValueExpression wholeBeanVE, Object wholeBean, String copierType, Map<String, Map<String, Object>> candidate) {
        HashMap<String, Object> propertiesToSet = new HashMap<String, Object>();
        for (Map.Entry<String, Map<String, Object>> propertyEntry : candidate.entrySet()) {
            propertiesToSet.put(propertyEntry.getKey(), propertyEntry.getValue().get("value"));
        }
        Object wholeBeanCopy = CopierUtils.getCopier(context, copierType).copy(wholeBean);
        if (wholeBeanCopy == null) {
            throw new FacesException("Unable to copy bean from " + wholeBeanVE.getExpressionString());
        }
        ReflectionUtils.setProperties(wholeBeanCopy, propertiesToSet);
        return wholeBeanCopy;
    }

    private Set<ConstraintViolation<?>> doBeanValidation(Validator beanValidator, Object wholeBeanCopy, Class<?>[] validationGroupArray, ValueExpression wholeBeanVE) {
        Set violationsRaw = null;
        try {
            violationsRaw = beanValidator.validate(wholeBeanCopy, (Class[])validationGroupArray);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.fine("Unable to validate expression " + wholeBeanVE.getExpressionString() + " using Bean Validation.  Unable to get value of expression.  Message from Bean Validation: " + iae.getMessage());
        }
        Set violations = violationsRaw;
        return violations;
    }

    private static class AddRemainingCandidateFieldsCallback
    implements VisitCallback {
        private final FacesContext context;
        private final Object base;
        private final Map<String, Map<String, Object>> candidate = new HashMap<String, Map<String, Object>>();

        public AddRemainingCandidateFieldsCallback(FacesContext context, Object base) {
            this.context = context;
            this.base = base;
        }

        final Map<String, Map<String, Object>> getCandidate() {
            return this.candidate;
        }

        @Override
        public VisitResult visit(VisitContext visitContext, UIComponent component) {
            ValueReference valueReference;
            ValueExpression valueExpression;
            if (component instanceof EditableValueHolder && component.isRendered() && !(component instanceof UIValidateWholeBean) && (valueExpression = component.getValueExpression("value")) != null && (valueReference = new ValueExpressionAnalyzer(valueExpression).getReference(this.context.getELContext())) != null && valueReference.getBase().equals(this.base)) {
                HashMap<String, Object> tuple = new HashMap<String, Object>();
                tuple.put("component", component);
                tuple.put("value", AddRemainingCandidateFieldsCallback.getComponentValue(component));
                this.candidate.put(valueReference.getProperty(), tuple);
            }
            return VisitResult.ACCEPT;
        }

        private static Object getComponentValue(UIComponent component) {
            UIInput inputComponent = (UIInput)component;
            return inputComponent.getSubmittedValue() != null ? inputComponent.getSubmittedValue() : inputComponent.getLocalValue();
        }
    }
}

