/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.persistence.jpa.schemageneration;

import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import org.glassfish.persistence.jpa.PersistenceUnitInfoImpl;
import org.glassfish.persistence.jpa.schemageneration.EclipseLinkSchemaGenerationProcessor;
import org.glassfish.persistence.jpa.schemageneration.JPAStandardSchemaGenerationProcessor;
import org.glassfish.persistence.jpa.schemageneration.SchemaGenerationProcessor;

public class SchemaGenerationProcessorFactory {
    private static final String STANDARD_SCHEMA_GENERATION_PREFIX = "javax.persistence.schema-generation";

    public static SchemaGenerationProcessor createSchemaGenerationProcessor(PersistenceUnitDescriptor pud) {
        String providerClassName = PersistenceUnitInfoImpl.getPersistenceProviderClassNameForPuDesc(pud);
        boolean useJPA21Processor = true;
        if (EclipseLinkSchemaGenerationProcessor.isSupportedPersistenceProvider(providerClassName) && !SchemaGenerationProcessorFactory.containsStandardSchemaGenerationProperty(pud)) {
            useJPA21Processor = false;
        }
        return useJPA21Processor ? new JPAStandardSchemaGenerationProcessor() : new EclipseLinkSchemaGenerationProcessor(providerClassName);
    }

    private static boolean containsStandardSchemaGenerationProperty(PersistenceUnitDescriptor pud) {
        boolean containsStandardSchemaGenerationProperty = false;
        for (Object puPropertyName : pud.getProperties().keySet()) {
            if (!(puPropertyName instanceof String) || !((String)String.class.cast(puPropertyName)).startsWith(STANDARD_SCHEMA_GENERATION_PREFIX)) continue;
            containsStandardSchemaGenerationProperty = true;
            break;
        }
        return containsStandardSchemaGenerationProperty;
    }
}

