/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.code;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jboss.classfilewriter.code.StackEntryType;
import org.jboss.classfilewriter.constpool.ConstPool;
import org.jboss.classfilewriter.util.DescriptorUtils;

public class StackEntry {
    private final StackEntryType type;
    private final String descriptor;
    private final int descriptorIndex;
    private final int newInstructionLocation;

    public StackEntry(StackEntryType type, String descriptor) {
        if (type == StackEntryType.OBJECT) {
            throw new RuntimeException("OBJECT stack entries must provide a const pool index for the class");
        }
        this.type = type;
        if (descriptor != null && descriptor.contains(".")) {
            throw new RuntimeException("invalid descriptor " + descriptor);
        }
        this.descriptor = descriptor;
        this.newInstructionLocation = -1;
        this.descriptorIndex = -1;
    }

    public StackEntry(StackEntryType type, String descriptor, ConstPool pool) {
        this.type = type;
        this.descriptor = descriptor;
        this.newInstructionLocation = -1;
        if (descriptor != null && descriptor.contains(".")) {
            throw new RuntimeException("invalid descriptor " + descriptor);
        }
        this.descriptorIndex = type == StackEntryType.OBJECT ? (descriptor.charAt(0) == 'L' ? pool.addClassEntry(descriptor.substring(1, descriptor.length() - 1)).intValue() : pool.addClassEntry(descriptor).intValue()) : -1;
    }

    public StackEntry(StackEntryType type, String descriptor, int newInstructionLocation) {
        this.type = type;
        this.descriptor = descriptor;
        this.newInstructionLocation = newInstructionLocation;
        this.descriptorIndex = -1;
        if (descriptor != null && descriptor.contains(".")) {
            throw new RuntimeException("invalid descriptor " + descriptor);
        }
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public int getNewInstructionLocation() {
        return this.newInstructionLocation;
    }

    public StackEntryType getType() {
        return this.type;
    }

    public String toString() {
        if (this.type == StackEntryType.OBJECT) {
            return "StackEntry [descriptor=" + this.descriptor + ", type=" + (Object)((Object)this.type) + "]";
        }
        return "StackEntry [type=" + (Object)((Object)this.type) + "]";
    }

    public static StackEntry of(String descriptor, ConstPool pool) {
        String desc = descriptor.replace(".", "/");
        if (!DescriptorUtils.isPrimitive(desc)) {
            return new StackEntry(StackEntryType.OBJECT, desc, pool);
        }
        char ret = desc.charAt(0);
        switch (ret) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return new StackEntry(StackEntryType.INT, desc);
            }
            case 'F': {
                return new StackEntry(StackEntryType.FLOAT, desc);
            }
            case 'D': {
                return new StackEntry(StackEntryType.DOUBLE, desc);
            }
            case 'J': {
                return new StackEntry(StackEntryType.LONG, desc);
            }
        }
        throw new RuntimeException("Unknown descriptor: " + desc);
    }

    public boolean isWide() {
        return this.type == StackEntryType.DOUBLE || this.type == StackEntryType.LONG;
    }

    public void write(DataOutputStream dstream) throws IOException {
        dstream.writeByte(this.type.ordinal());
        if (this.type == StackEntryType.OBJECT) {
            dstream.writeShort(this.descriptorIndex);
        } else if (this.type == StackEntryType.UNITITIALIZED_OBJECT) {
            dstream.writeShort(this.newInstructionLocation);
        }
    }
}

