/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.catalina.util.StringManager;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.NonceInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="CNonceCache")
@PerLookup
public final class CNonceCacheImpl
extends LinkedHashMap<String, NonceInfo>
implements CNonceCache {
    private static final long LOG_SUPPRESS_TIME = 300000L;
    private long lastLog = 0L;
    private static final Logger log = Logger.getLogger(CNonceCacheImpl.class.getName());
    private String eldestCNonce = null;
    private String storeName = null;
    static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.util");
    long cnonceCacheSize = 1000L;
    long nonceValidity = 300000L;

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, NonceInfo> eldest) {
        long currentTime = System.currentTimeMillis();
        this.eldestCNonce = eldest.getKey();
        if ((long)this.size() > this.getCnonceCacheSize()) {
            if (this.lastLog < currentTime && currentTime - eldest.getValue().getTimestamp() < this.getNonceValidity()) {
                log.warning(sm.getString("digestAuthenticator.cacheRemove"));
                this.lastLog = currentTime + 300000L;
            }
            return true;
        }
        return false;
    }

    public long getCnonceCacheSize() {
        return this.cnonceCacheSize;
    }

    public long getNonceValidity() {
        return this.nonceValidity;
    }

    public String getEldestCNonce() {
        return this.eldestCNonce;
    }

    public void init(long size, String name, long validity, Map<String, String> props) {
        this.storeName = name;
        this.cnonceCacheSize = size;
        this.nonceValidity = validity;
    }

    public void setCnonceCacheSize(long cnonceCacheSize) {
        this.cnonceCacheSize = cnonceCacheSize;
    }

    public void setNonceValidity(long nonceValidity) {
        this.nonceValidity = nonceValidity;
    }

    public void destroy() {
        this.clear();
    }
}

