/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.ConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.ResourcePropertyNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConnectionFactoryDefinitionNode
extends DeploymentDescriptorNode<ConnectionFactoryDefinitionDescriptor> {
    public static final XMLElement tag = new XMLElement("connection-factory");
    private ConnectionFactoryDefinitionDescriptor descriptor = null;
    @LogMessageInfo(message="For connection-factory resource: {0}, there is no application part in its resource adapter name: {1}.", level="WARNING", cause="For embedded resource adapter, its internal format of resource adapter name should contains application name.", comment="For the method writeDescriptor of com.sun.enterprise.deployment.node.ConnectionFactoryDefinitionNode.")
    private static final String RESOURCE_ADAPTER_NAME_INVALID = "AS-DEPLOYMENT-00023";

    public ConnectionFactoryDefinitionNode() {
        this.registerElementHandler(new XMLElement("property"), ResourcePropertyNode.class, "addConnectionFactoryPropertyDescriptor");
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("name", "setName");
        table.put("interface-name", "setInterfaceName");
        table.put("resource-adapter", "setResourceAdapter");
        table.put("transaction-support", "setTransactionSupport");
        table.put("max-pool-size", "setMaxPoolSize");
        table.put("min-pool-size", "setMinPoolSize");
        return table;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, ConnectionFactoryDefinitionDescriptor desc) {
        Element node = ConnectionFactoryDefinitionNode.appendChild(parent, nodeName);
        ConnectionFactoryDefinitionNode.appendTextChild((Node)node, "description", desc.getDescription());
        ConnectionFactoryDefinitionNode.appendTextChild((Node)node, "name", desc.getName());
        ConnectionFactoryDefinitionNode.appendTextChild((Node)node, "interface-name", desc.getInterfaceName());
        String resourceAdapterName = desc.getResourceAdapter();
        int poundIndex = resourceAdapterName.indexOf("#");
        if (poundIndex > 0) {
            resourceAdapterName = resourceAdapterName.substring(poundIndex);
        } else if (poundIndex == 0) {
            DOLUtils.getDefaultLogger().log(Level.WARNING, RESOURCE_ADAPTER_NAME_INVALID, new Object[]{desc.getName(), desc.getResourceAdapter()});
        }
        ConnectionFactoryDefinitionNode.appendTextChild((Node)node, "resource-adapter", resourceAdapterName);
        ConnectionFactoryDefinitionNode.appendTextChild((Node)node, "max-pool-size", desc.getMaxPoolSize());
        ConnectionFactoryDefinitionNode.appendTextChild((Node)node, "min-pool-size", desc.getMinPoolSize());
        ConnectionFactoryDefinitionNode.appendTextChild((Node)node, "transaction-support", desc.getTransactionSupport());
        ResourcePropertyNode propertyNode = new ResourcePropertyNode();
        propertyNode.writeDescriptor((Node)node, desc);
        return node;
    }

    @Override
    public ConnectionFactoryDefinitionDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ConnectionFactoryDefinitionDescriptor();
        }
        return this.descriptor;
    }
}

