/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.status;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.persistence.PersistentDataWrapper;
import com.ibm.jbatch.container.util.TCCLObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.batch.runtime.BatchStatus;

public class StepStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long stepExecutionId;
    private BatchStatus batchStatus;
    private String exitStatus;
    private int startCount = 1;
    private PersistentDataWrapper persistentUserData;
    private Integer numPartitions;
    private long lastRunStepExecutionId;

    public StepStatus(long stepExecutionId) {
        this.stepExecutionId = stepExecutionId;
        this.lastRunStepExecutionId = stepExecutionId;
        this.batchStatus = BatchStatus.STARTING;
    }

    public void setBatchStatus(BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("stepExecutionId: " + this.stepExecutionId);
        buf.append(",batchStatus: " + this.batchStatus);
        buf.append(",exitStatus: " + this.exitStatus);
        buf.append(",startCount: " + this.startCount);
        buf.append(",persistentUserData: " + this.persistentUserData);
        buf.append(",numPartitions: " + this.numPartitions);
        return buf.toString();
    }

    public long getStepExecutionId() {
        return this.stepExecutionId;
    }

    public int getStartCount() {
        return this.startCount;
    }

    public void incrementStartCount() {
        ++this.startCount;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setPersistentUserData(PersistentDataWrapper persistentUserData) {
        this.persistentUserData = persistentUserData;
    }

    public Serializable getPersistentUserData() {
        if (this.persistentUserData != null) {
            byte[] persistentToken = this.persistentUserData.getPersistentDataBytes();
            ByteArrayInputStream persistentByteArrayInputStream = new ByteArrayInputStream(persistentToken);
            TCCLObjectInputStream persistentOIS = null;
            Serializable persistentObject = null;
            try {
                persistentOIS = new TCCLObjectInputStream(persistentByteArrayInputStream);
                persistentObject = (Serializable)persistentOIS.readObject();
            }
            catch (Exception e) {
                throw new BatchContainerRuntimeException(e);
            }
            return persistentObject;
        }
        return null;
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(Integer numPartitions) {
        this.numPartitions = numPartitions;
    }

    public void setStepExecutionId(long stepExecutionId) {
        this.lastRunStepExecutionId = this.stepExecutionId = stepExecutionId;
    }

    public long getLastRunStepExecutionId() {
        return this.lastRunStepExecutionId;
    }

    public void setLastRunStepExecutionId(long lastRunStepExecutionId) {
        this.lastRunStepExecutionId = lastRunStepExecutionId;
    }
}

