/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint;

import com.sun.jdo.spi.persistence.support.sqlstore.ActionDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintFieldNameSubQuery;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintForeignFieldName;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintJoin;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintParamIndex;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import java.util.ArrayList;
import java.util.List;

public class Constraint {
    public List stack = new ArrayList();
    private List outerJoinStack = new ArrayList();

    public void addField(String name, ActionDesc desc) {
        this.stack.add(new ConstraintFieldName(name, desc));
    }

    public void addField(LocalFieldDesc desc) {
        this.stack.add(new ConstraintFieldDesc(desc));
    }

    public void addField(LocalFieldDesc desc, QueryPlan plan) {
        this.stack.add(new ConstraintFieldDesc(desc, plan));
    }

    public void addField(ConstraintFieldDesc constraintDesc) {
        this.stack.add(constraintDesc);
    }

    public void addForeignField(String name, ActionDesc desc) {
        this.stack.add(new ConstraintForeignFieldName(name, desc));
    }

    public void addOperation(int operation) {
        this.stack.add(new ConstraintOperation(operation));
    }

    public void addValue(Object value, LocalFieldDesc localField) {
        this.stack.add(new ConstraintValue(value, localField));
    }

    public void addConstraintFieldSubQuery(String field, ActionDesc rd) {
        this.stack.add(new ConstraintFieldNameSubQuery(field, rd));
    }

    public void addParamIndex(int index, int enumType, LocalFieldDesc localField) {
        this.stack.add(new ConstraintParamIndex(index, enumType, localField));
    }

    public void addJoinConstraint(ConstraintJoin join) {
        if (join.operation == 10) {
            this.stack.add(join);
        } else {
            assert (join.operation == 16);
            this.outerJoinStack.add(join);
        }
    }

    public boolean mergeConstraint(Constraint foreignConstraint, int joinOp) {
        this.stack.addAll(foreignConstraint.stack);
        this.outerJoinStack.addAll(foreignConstraint.outerJoinStack);
        return this.addAnd(foreignConstraint, joinOp);
    }

    private boolean addAnd(Constraint foreignConstraint, int joinOp) {
        return joinOp == 10 && !foreignConstraint.isEmptyOrOrderBy();
    }

    private boolean isEmptyOrOrderBy() {
        boolean rc = true;
        for (int i = this.stack.size() - 1; i >= 0 && rc; --i) {
            ConstraintNode node = (ConstraintNode)this.stack.get(i);
            if (node instanceof ConstraintOperation && (((ConstraintOperation)node).operation == 30 || ((ConstraintOperation)node).operation == 31)) {
                if (i > 0 && (this.stack.get(i - 1) instanceof ConstraintFieldName || this.stack.get(i - 1) instanceof ConstraintFieldDesc)) {
                    if (--i <= 0 || !(this.stack.get(i - 1) instanceof ConstraintValue)) continue;
                    --i;
                    continue;
                }
                rc = false;
                continue;
            }
            rc = false;
        }
        return rc;
    }

    public List getConstraints() {
        return this.stack;
    }

    public List getOuterJoinConstraints() {
        return this.outerJoinStack;
    }
}

