/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime;

import com.sun.enterprise.security.SecurityContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.security.auth.Subject;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;

public class InvocationContext
implements ContextHandle {
    private transient ComponentInvocation invocation;
    private transient ClassLoader contextClassLoader;
    private transient SecurityContext securityContext;
    private boolean useTransactionOfExecutionThread;
    static final long serialVersionUID = 5642415011655486579L;

    public InvocationContext(ComponentInvocation invocation, ClassLoader contextClassLoader, SecurityContext securityContext, boolean useTransactionOfExecutionThread) {
        this.invocation = invocation;
        this.contextClassLoader = contextClassLoader;
        this.securityContext = securityContext;
        this.useTransactionOfExecutionThread = useTransactionOfExecutionThread;
    }

    public ComponentInvocation getInvocation() {
        return this.invocation;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public boolean isUseTransactionOfExecutionThread() {
        return this.useTransactionOfExecutionThread;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.useTransactionOfExecutionThread);
        String componentId = null;
        String appName = null;
        String moduleName = null;
        if (this.invocation != null) {
            componentId = this.invocation.getComponentId();
            appName = this.invocation.getAppName();
            moduleName = this.invocation.getModuleName();
        }
        out.writeObject(componentId);
        out.writeObject(appName);
        out.writeObject(moduleName);
        String principalName = null;
        boolean defaultSecurityContext = false;
        Subject subject = null;
        if (this.securityContext != null) {
            if (this.securityContext.getCallerPrincipal() != null) {
                principalName = this.securityContext.getCallerPrincipal().getName();
                subject = this.securityContext.getSubject();
                subject.getPrincipals().clear();
            }
            if (this.securityContext == SecurityContext.getDefaultSecurityContext()) {
                defaultSecurityContext = true;
            }
        }
        out.writeObject(principalName);
        out.writeBoolean(defaultSecurityContext);
        out.writeObject(subject);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ApplicationInfo applicationInfo;
        this.useTransactionOfExecutionThread = in.readBoolean();
        String componentId = (String)in.readObject();
        String appName = (String)in.readObject();
        String moduleName = (String)in.readObject();
        this.invocation = this.createComponentInvocation(componentId, appName, moduleName);
        String principalName = (String)in.readObject();
        boolean defaultSecurityContext = in.readBoolean();
        Subject subject = (Subject)in.readObject();
        if (principalName != null) {
            this.securityContext = defaultSecurityContext ? SecurityContext.getDefaultSecurityContext() : new SecurityContext(principalName, subject, null);
        }
        ApplicationRegistry applicationRegistry = ConcurrentRuntime.getRuntime().getApplicationRegistry();
        if (appName != null && (applicationInfo = applicationRegistry.get(appName)) != null) {
            this.contextClassLoader = applicationInfo.getAppClassLoader();
        }
    }

    private ComponentInvocation createComponentInvocation(String componentId, String appName, String moduleName) {
        if (componentId == null && appName == null && moduleName == null) {
            return null;
        }
        ComponentInvocation newInv = new ComponentInvocation(componentId, ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION, null, appName, moduleName);
        return newInv;
    }
}

