/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.jdbc.admin.cli.JDBCConnectionPoolManager;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-jdbc-connection-pool")
@PerLookup
@I18n(value="delete.jdbc.connection.pool")
public class DeleteJdbcConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJdbcConnectionPool.class);
    @Param(optional=true, defaultValue="false")
    private Boolean cascade;
    @Param(name="jdbc_connection_pool_id", primary=true)
    private String poolName;
    @Param(optional=true, obsolete=true)
    private String target = "server";
    @Inject
    private Domain domain;
    @Inject
    private IterableProvider<Server> servers;
    @Inject
    private IterableProvider<Cluster> clusters;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            JDBCConnectionPoolManager jdbcConnMgr = new JDBCConnectionPoolManager();
            ResourceStatus rs = jdbcConnMgr.delete((Iterable<Server>)this.servers, (Iterable<Cluster>)this.clusters, this.domain.getResources(), this.cascade.toString(), this.poolName);
            if (rs.getMessage() != null) {
                report.setMessage(rs.getMessage());
            }
            if (rs.getStatus() == 0) {
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                if (rs.getException() != null) {
                    report.setFailureCause(rs.getException());
                    Logger.getLogger(DeleteJdbcConnectionPool.class.getName()).log(Level.SEVERE, "Something went wrong in delete-jdbc-connection-pool", rs.getException());
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(DeleteJdbcConnectionPool.class.getName()).log(Level.SEVERE, "Something went wrong in delete-jdbc-connection-pool", e);
            String msg = e.getMessage() != null ? e.getMessage() : localStrings.getLocalString("delete.jdbc.connection.pool.fail", "{0} delete failed ", new Object[]{this.poolName});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

