/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import java.util.Map;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.logging.LogCategory;
import org.eclipse.persistence.logging.LogLevel;

class LoggerContext {
    private final boolean isGlobal;
    private final LogLevel global;
    private final boolean isProcessor;
    private final LogLevel processor;

    static LoggerContext buildContext(Map<String, String> options) {
        String glob = options.get("eclipselink.logging.level");
        String proc = options.get("eclipselink.logging.level.processor");
        return new LoggerContext(glob != null, LogLevel.toValue((String)glob, (LogLevel)LogLevel.INFO), proc != null, LogLevel.toValue((String)proc, (LogLevel)LogLevel.INFO));
    }

    static void updateMetadataLogger(MetadataLogger logger, PersistenceUnit persistenceUnit) {
        LogLevel level;
        String levelStr = persistenceUnit.getPersistenceUnitProperty(LogCategory.PROCESSOR.getLogLevelProperty());
        if (levelStr == null) {
            levelStr = persistenceUnit.getPersistenceUnitProperty("eclipselink.logging.level");
        }
        if (levelStr != null && (level = LogLevel.toValue((String)levelStr)) != null) {
            logger.getSession().getSessionLog().setLevel((int)level.getId(), LogCategory.PROCESSOR.getName());
        }
    }

    private LoggerContext(boolean isGlobal, LogLevel global, boolean isProcessor, LogLevel processor) {
        this.isGlobal = isGlobal;
        this.global = global;
        this.isProcessor = isProcessor;
        this.processor = processor;
    }

    boolean isGlobal() {
        return this.isGlobal;
    }

    LogLevel getGlobal() {
        return this.global;
    }

    boolean isProcessor() {
        return this.isProcessor;
    }

    LogLevel getProcessor() {
        return this.processor;
    }

    boolean isAny() {
        return this.isGlobal || this.isProcessor;
    }

    void updateMetadataLogger(MetadataLogger logger) {
        if (this.isProcessor || !this.isGlobal) {
            logger.getSession().getSessionLog().setLevel((int)this.processor.getId(), LogCategory.PROCESSOR.getName());
        } else {
            logger.getSession().getSessionLog().setLevel((int)this.global.getId(), LogCategory.PROCESSOR.getName());
        }
        logger.getSession().getSessionLog().setLevel((int)this.global.getId());
    }
}

