/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel.internal;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.ChangeableRunLevelFuture;
import org.glassfish.hk2.runlevel.ErrorInformation;
import org.glassfish.hk2.runlevel.ProgressStartedListener;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelListener;
import org.glassfish.hk2.runlevel.Sorter;
import org.glassfish.hk2.runlevel.internal.AsyncRunLevelContext;
import org.glassfish.hk2.runlevel.internal.CurrentTaskFutureWrapper;
import org.glassfish.hk2.runlevel.internal.ErrorInformationImpl;
import org.glassfish.hk2.runlevel.internal.WasCancelledException;
import org.glassfish.hk2.runlevel.internal.WouldBlockException;
import org.glassfish.hk2.runlevel.utilities.Utilities;

public class CurrentTaskFuture
implements ChangeableRunLevelFuture {
    private final AsyncRunLevelContext asyncContext;
    private final Executor executor;
    private final ServiceLocator locator;
    private int proposedLevel;
    private final boolean useThreads;
    private final List<ServiceHandle<RunLevelListener>> allListenerHandles;
    private final List<ServiceHandle<ProgressStartedListener>> allProgressStartedHandles;
    private final List<ServiceHandle<Sorter>> allSorterHandles;
    private final int maxThreads;
    private final Timer timer;
    private final long cancelTimeout;
    private UpAllTheWay upAllTheWay;
    private DownAllTheWay downAllTheWay;
    private boolean done = false;
    private boolean cancelled = false;
    private boolean inCallback = false;

    CurrentTaskFuture(AsyncRunLevelContext asyncContext, Executor executor, ServiceLocator locator, int proposedLevel, int maxThreads, boolean useThreads, long cancelTimeout, Timer timer) {
        this.asyncContext = asyncContext;
        this.executor = executor;
        this.locator = locator;
        this.proposedLevel = proposedLevel;
        this.useThreads = useThreads;
        this.maxThreads = maxThreads;
        this.cancelTimeout = cancelTimeout;
        this.timer = timer;
        int currentLevel = asyncContext.getCurrentLevel();
        this.allListenerHandles = locator.getAllServiceHandles(RunLevelListener.class, new Annotation[0]);
        this.allProgressStartedHandles = locator.getAllServiceHandles(ProgressStartedListener.class, new Annotation[0]);
        this.allSorterHandles = locator.getAllServiceHandles(Sorter.class, new Annotation[0]);
        if (currentLevel == proposedLevel) {
            this.done = true;
        } else if (currentLevel < proposedLevel) {
            this.upAllTheWay = new UpAllTheWay(proposedLevel, this, this.allListenerHandles, this.allSorterHandles, maxThreads, useThreads, cancelTimeout);
        } else {
            this.downAllTheWay = new DownAllTheWay(proposedLevel, this, this.allListenerHandles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void go() {
        DownAllTheWay localDownAllTheWay;
        UpAllTheWay localUpAllTheWay;
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            localUpAllTheWay = this.upAllTheWay;
            localDownAllTheWay = this.downAllTheWay;
        }
        if (localUpAllTheWay != null || localDownAllTheWay != null) {
            int currentLevel = this.asyncContext.getCurrentLevel();
            this.invokeOnProgressStarted(this, currentLevel, this.allProgressStartedHandles);
        }
        this.go(localUpAllTheWay, localDownAllTheWay);
    }

    private void go(UpAllTheWay localUpAllTheWay, DownAllTheWay localDownAllTheWay) {
        if (localUpAllTheWay != null) {
            localUpAllTheWay.go();
        } else if (localDownAllTheWay != null) {
            if (this.useThreads) {
                this.executor.execute(localDownAllTheWay);
            } else {
                localDownAllTheWay.run();
            }
        } else {
            this.asyncContext.jobDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUp() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.upAllTheWay != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDown() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.downAllTheWay != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        AsyncRunLevelContext asyncRunLevelContext = this.asyncContext;
        synchronized (asyncRunLevelContext) {
            CurrentTaskFuture currentTaskFuture = this;
            synchronized (currentTaskFuture) {
                if (this.done) {
                    return false;
                }
                if (this.cancelled) {
                    return false;
                }
                this.cancelled = true;
                if (this.upAllTheWay != null) {
                    this.upAllTheWay.cancel();
                } else if (this.downAllTheWay != null) {
                    this.downAllTheWay.cancel();
                }
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProposedLevel() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.proposedLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int changeProposedLevel(int proposedLevel) {
        int oldProposedVal;
        boolean needGo = false;
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            if (this.done) {
                throw new IllegalStateException("Cannot change the proposed level of a future that is already complete");
            }
            if (!this.inCallback) {
                throw new IllegalStateException("changeProposedLevel must only be called from inside a RunLevelListener callback method");
            }
            oldProposedVal = this.proposedLevel;
            int currentLevel = this.asyncContext.getCurrentLevel();
            this.proposedLevel = proposedLevel;
            if (this.upAllTheWay != null) {
                if (currentLevel <= proposedLevel) {
                    this.upAllTheWay.setGoingTo(proposedLevel, false);
                } else {
                    this.upAllTheWay.setGoingTo(currentLevel, true);
                    this.upAllTheWay = null;
                    this.downAllTheWay = new DownAllTheWay(proposedLevel, this, this.allListenerHandles);
                    needGo = true;
                }
            } else if (this.downAllTheWay != null) {
                if (currentLevel >= proposedLevel) {
                    this.downAllTheWay.setGoingTo(proposedLevel, false);
                } else {
                    this.downAllTheWay.setGoingTo(currentLevel, true);
                    this.downAllTheWay = null;
                    this.upAllTheWay = new UpAllTheWay(proposedLevel, this, this.allListenerHandles, this.allSorterHandles, this.maxThreads, this.useThreads, this.cancelTimeout);
                    needGo = true;
                }
            } else {
                throw new AssertionError((Object)"Can not determine previous job");
            }
        }
        if (needGo) {
            this.go(this.upAllTheWay, this.downAllTheWay);
        }
        return oldProposedVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInCallback(boolean inCallback) {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            this.inCallback = inCallback;
        }
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new AssertionError((Object)te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        AllTheWay allTheWay = null;
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            if (this.upAllTheWay != null) {
                allTheWay = this.upAllTheWay;
            } else if (this.downAllTheWay != null) {
                allTheWay = this.downAllTheWay;
            }
        }
        if (allTheWay == null) {
            return null;
        }
        Boolean result = null;
        try {
            CurrentTaskFuture currentTaskFuture2;
            while ((result = allTheWay.waitForResult(timeout, unit)) == null) {
                currentTaskFuture2 = this;
                synchronized (currentTaskFuture2) {
                    if (this.upAllTheWay != null) {
                        allTheWay = this.upAllTheWay;
                    } else if (this.downAllTheWay != null) {
                        allTheWay = this.downAllTheWay;
                    }
                }
            }
            if (!result.booleanValue()) {
                throw new TimeoutException();
            }
            currentTaskFuture2 = this;
            synchronized (currentTaskFuture2) {
                this.done = true;
            }
            return null;
        }
        catch (MultiException me) {
            CurrentTaskFuture currentTaskFuture3 = this;
            synchronized (currentTaskFuture3) {
                this.done = true;
            }
            throw new ExecutionException(me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnProgress(ChangeableRunLevelFuture job, int level, List<ServiceHandle<RunLevelListener>> listeners) {
        this.setInCallback(true);
        try {
            for (ServiceHandle<RunLevelListener> listener : listeners) {
                try {
                    RunLevelListener rll = (RunLevelListener)listener.getService();
                    if (rll == null) continue;
                    rll.onProgress(job, level);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.setInCallback(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnProgressStarted(ChangeableRunLevelFuture job, int level, List<ServiceHandle<ProgressStartedListener>> listeners) {
        this.setInCallback(true);
        try {
            for (ServiceHandle<ProgressStartedListener> listener : listeners) {
                try {
                    ProgressStartedListener psl = (ProgressStartedListener)listener.getService();
                    if (psl == null) continue;
                    psl.onProgressStarting(job, level);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.setInCallback(false);
        }
    }

    private static void invokeOnCancelled(CurrentTaskFuture job, int levelAchieved, List<ServiceHandle<RunLevelListener>> listeners) {
        for (ServiceHandle<RunLevelListener> listener : listeners) {
            try {
                RunLevelListener rll = (RunLevelListener)listener.getService();
                if (rll == null) continue;
                rll.onCancelled(new CurrentTaskFutureWrapper(job), levelAchieved);
            }
            catch (Throwable throwable) {}
        }
    }

    private static ErrorInformation invokeOnError(CurrentTaskFuture job, Throwable th, ErrorInformation.ErrorAction action, List<ServiceHandle<RunLevelListener>> listeners, Descriptor descriptor) {
        ErrorInformationImpl errorInfo = new ErrorInformationImpl(th, action, descriptor);
        for (ServiceHandle<RunLevelListener> listener : listeners) {
            try {
                RunLevelListener rll = (RunLevelListener)listener.getService();
                if (rll == null) continue;
                rll.onError(new CurrentTaskFutureWrapper(job), errorInfo);
            }
            catch (Throwable throwable) {}
        }
        return errorInfo;
    }

    static final boolean isWouldBlock(Throwable th) {
        return CurrentTaskFuture.isACertainException(th, WouldBlockException.class);
    }

    private static final boolean isWasCancelled(Throwable th) {
        return CurrentTaskFuture.isACertainException(th, WasCancelledException.class);
    }

    private static final boolean isACertainException(Throwable th, Class<? extends Throwable> type) {
        for (Throwable cause = th; cause != null; cause = cause.getCause()) {
            if (cause instanceof MultiException) {
                MultiException me = (MultiException)cause;
                for (Throwable innerMulti : me.getErrors()) {
                    if (!CurrentTaskFuture.isACertainException(innerMulti, type)) continue;
                    return true;
                }
                continue;
            }
            if (!type.isAssignableFrom(cause.getClass())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "CurrentTaskFuture(proposedLevel=" + this.proposedLevel + "," + System.identityHashCode(this) + ")";
    }

    private static class DownQueueRunner
    implements Runnable {
        private final Object queueLock;
        private final List<ActiveDescriptor<?>> queue;
        private final DownAllTheWay parent;
        private final ServiceLocator locator;
        private boolean caput;

        private DownQueueRunner(Object queueLock, List<ActiveDescriptor<?>> queue, DownAllTheWay parent, ServiceLocator locator) {
            this.queueLock = queue;
            this.queue = queue;
            this.parent = parent;
            this.locator = locator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ActiveDescriptor<?> job = null;
                Object object = this.queueLock;
                synchronized (object) {
                    if (this.caput) {
                        return;
                    }
                    if (this.queue.isEmpty()) {
                        this.queueLock.notify();
                        return;
                    }
                    job = this.queue.remove(0);
                }
                try {
                    this.locator.getServiceHandle(job).destroy();
                }
                catch (Throwable th) {
                    Object object2 = this.queueLock;
                    synchronized (object2) {
                        this.parent.lastError = th;
                        this.parent.lastErrorDescriptor = job;
                        this.queueLock.notify();
                    }
                }
            }
        }
    }

    private static class QueueRunner
    implements Runnable {
        private final ServiceLocator locator;
        private final AsyncRunLevelContext asyncContext;
        private final Object queueLock;
        private final List<ServiceHandle<?>> queue;
        private final UpOneLevel parent;
        private final Object parentLock;
        private final int maxThreads;
        private ServiceHandle<?> wouldHaveBlocked;
        private final HashSet<ActiveDescriptor<?>> alreadyTried = new HashSet();

        private QueueRunner(ServiceLocator locator, AsyncRunLevelContext asyncContext, Object queueLock, List<ServiceHandle<?>> queue, UpOneLevel parent, Object parentLock, int maxThreads) {
            this.locator = locator;
            this.asyncContext = asyncContext;
            this.queueLock = queueLock;
            this.queue = queue;
            this.parent = parent;
            this.parentLock = parentLock;
            this.maxThreads = maxThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServiceHandle<?> runningHandle = null;
            while (true) {
                ServiceHandle<?> job;
                boolean block;
                Object object = this.queueLock;
                synchronized (object) {
                    if (runningHandle != null) {
                        this.parent.jobFinished(runningHandle);
                    }
                    if (this.wouldHaveBlocked != null) {
                        this.alreadyTried.add(this.wouldHaveBlocked.getActiveDescriptor());
                        this.queue.add(this.queue.size(), this.wouldHaveBlocked);
                        this.wouldHaveBlocked = null;
                    }
                    if (this.queue.isEmpty()) {
                        return;
                    }
                    if (this.maxThreads <= 0) {
                        block = true;
                    } else {
                        int currentlyEmptyThreads = this.maxThreads - this.parent.getJobsRunning();
                        boolean bl = block = this.queue.size() <= currentlyEmptyThreads;
                    }
                    if (block) {
                        job = this.queue.remove(0);
                    } else {
                        job = null;
                        for (int lcv = 0; lcv < this.queue.size(); ++lcv) {
                            ActiveDescriptor candidate = this.queue.get(lcv).getActiveDescriptor();
                            if (this.alreadyTried.contains(candidate)) continue;
                            job = this.queue.remove(lcv);
                            break;
                        }
                        if (job == null) {
                            job = this.queue.remove(0);
                            block = true;
                        }
                    }
                    this.parent.jobRunning(job);
                    runningHandle = job;
                }
                this.oneJob(job, block);
            }
        }

        private boolean isWouldBlockRightNow(HashSet<ActiveDescriptor<?>> cycleChecker, ActiveDescriptor<?> checkMe) {
            if (checkMe == null) {
                return false;
            }
            if (cycleChecker.contains(checkMe)) {
                return false;
            }
            cycleChecker.add(checkMe);
            if (this.asyncContext.wouldBlockRightNow(checkMe)) {
                return true;
            }
            if (!checkMe.isReified()) {
                checkMe = this.locator.reifyDescriptor(checkMe);
            }
            for (Injectee ip : checkMe.getInjectees()) {
                ActiveDescriptor childService;
                try {
                    childService = this.locator.getInjecteeDescriptor(ip);
                }
                catch (MultiException me) {
                    continue;
                }
                if (childService == null || !childService.getScope().equals(RunLevel.class.getName()) || !this.isWouldBlockRightNow(cycleChecker, childService)) continue;
                if (this.asyncContext.wouldBlockRightNow(checkMe)) {
                    return true;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void oneJob(ServiceHandle<?> fService, boolean block) {
            fService.setServiceData((Object)(!block ? 1 : 0));
            boolean completed = true;
            try {
                boolean ok;
                Object object = this.parentLock;
                synchronized (object) {
                    ok = !this.parent.cancelled && this.parent.accumulatedExceptions == null;
                }
                if (!block && this.isWouldBlockRightNow(new HashSet(), fService.getActiveDescriptor())) {
                    this.wouldHaveBlocked = fService;
                    completed = false;
                    ok = false;
                }
                if (ok) {
                    fService.getService();
                }
            }
            catch (MultiException me) {
                if (!block && CurrentTaskFuture.isWouldBlock(me)) {
                    this.wouldHaveBlocked = fService;
                    completed = false;
                } else if (!CurrentTaskFuture.isWasCancelled(me)) {
                    this.parent.fail(me, (Descriptor)fService.getActiveDescriptor());
                }
            }
            catch (Throwable th) {
                this.parent.fail(th, (Descriptor)fService.getActiveDescriptor());
            }
            finally {
                fService.setServiceData(null);
                if (completed) {
                    this.parent.jobComplete();
                }
            }
        }
    }

    private static class HardCancelDownTimer
    extends TimerTask {
        private final DownAllTheWay parent;
        private final List<ActiveDescriptor<?>> queue;
        private int lastQueueSize;

        private HardCancelDownTimer(DownAllTheWay parent, List<ActiveDescriptor<?>> queue) {
            this.parent = parent;
            this.queue = queue;
            this.lastQueueSize = queue.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<ActiveDescriptor<?>> list = this.queue;
            synchronized (list) {
                int currentSize = this.queue.size();
                if (currentSize == 0) {
                    return;
                }
                if (currentSize == this.lastQueueSize) {
                    this.parent.downHardCancelled = true;
                    this.queue.notify();
                } else {
                    this.lastQueueSize = currentSize;
                }
            }
        }
    }

    private class DownAllTheWay
    implements Runnable,
    AllTheWay {
        private int goingTo;
        private CurrentTaskFuture future;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private int workingOn;
        private boolean cancelled = false;
        private boolean done = false;
        private boolean repurposed = false;
        private Throwable lastError = null;
        private ActiveDescriptor<?> lastErrorDescriptor = null;
        private List<ActiveDescriptor<?>> queue = Collections.emptyList();
        private boolean downHardCancelled = false;
        private HardCancelDownTimer hardCancelDownTimer = null;

        public DownAllTheWay(int goingTo, CurrentTaskFuture future, List<ServiceHandle<RunLevelListener>> listeners) {
            this.goingTo = goingTo;
            this.future = future;
            this.listeners = listeners;
            this.workingOn = future == null ? CurrentTaskFuture.this.asyncContext.getCurrentLevel() + 1 : CurrentTaskFuture.this.asyncContext.getCurrentLevel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            List<ActiveDescriptor<?>> localQueue;
            Object object = this;
            synchronized (object) {
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
                if (this.done) {
                    return;
                }
                localQueue = this.queue;
            }
            object = localQueue;
            synchronized (object) {
                if (localQueue.isEmpty()) {
                    return;
                }
                this.hardCancelDownTimer = new HardCancelDownTimer(this, localQueue);
                CurrentTaskFuture.this.timer.schedule((TimerTask)this.hardCancelDownTimer, CurrentTaskFuture.this.cancelTimeout, CurrentTaskFuture.this.cancelTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setGoingTo(int goingTo, boolean repurposed) {
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                this.goingTo = goingTo;
                if (repurposed) {
                    this.repurposed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getGoingTo() {
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                return this.goingTo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.workingOn > this.getGoingTo()) {
                boolean runOnCancelled;
                boolean localCancelled;
                DownAllTheWay downAllTheWay = this;
                synchronized (downAllTheWay) {
                    localCancelled = this.cancelled;
                    runOnCancelled = this.cancelled && this.future != null;
                }
                if (runOnCancelled) {
                    CurrentTaskFuture.invokeOnCancelled(this.future, this.workingOn, this.listeners);
                }
                downAllTheWay = this;
                synchronized (downAllTheWay) {
                    if (localCancelled) {
                        CurrentTaskFuture.this.asyncContext.jobDone();
                        this.done = true;
                        this.notifyAll();
                        return;
                    }
                }
                int proceedingTo = this.workingOn - 1;
                CurrentTaskFuture.this.asyncContext.setCurrentLevel(proceedingTo);
                List<ActiveDescriptor<?>> localQueue = CurrentTaskFuture.this.asyncContext.getOrderedListOfServicesAtLevel(this.workingOn);
                DownAllTheWay downAllTheWay2 = this;
                synchronized (downAllTheWay2) {
                    this.queue = localQueue;
                }
                ErrorInformation errorInfo = null;
                Object object = this.queue;
                synchronized (object) {
                    do {
                        DownQueueRunner currentRunner = new DownQueueRunner(this.queue, this.queue, this, CurrentTaskFuture.this.locator);
                        CurrentTaskFuture.this.executor.execute(currentRunner);
                        this.lastError = null;
                        while (true) {
                            if (!this.queue.isEmpty() && this.lastError == null && !this.downHardCancelled) {
                                try {
                                    this.queue.wait();
                                }
                                catch (InterruptedException ie) {
                                    throw new RuntimeException(ie);
                                }
                            }
                            if (this.downHardCancelled) {
                                currentRunner.caput = true;
                            }
                            if (this.lastError != null && this.future != null) {
                                errorInfo = CurrentTaskFuture.invokeOnError(this.future, this.lastError, ErrorInformation.ErrorAction.IGNORE, this.listeners, this.lastErrorDescriptor);
                            }
                            this.lastError = null;
                            this.lastErrorDescriptor = null;
                            if (this.queue.isEmpty() || this.downHardCancelled) break;
                        }
                        this.downHardCancelled = false;
                    } while (!this.queue.isEmpty());
                    if (this.hardCancelDownTimer != null) {
                        this.hardCancelDownTimer.cancel();
                    }
                }
                object = this;
                synchronized (object) {
                    this.queue = Collections.emptyList();
                }
                if (errorInfo != null && ErrorInformation.ErrorAction.GO_TO_NEXT_LOWER_LEVEL_AND_STOP.equals((Object)errorInfo.getAction())) {
                    object = this;
                    synchronized (object) {
                        this.goingTo = this.workingOn;
                    }
                }
                --this.workingOn;
                if (this.future == null) continue;
                CurrentTaskFuture.this.invokeOnProgress(this.future, proceedingTo, this.listeners);
            }
            if (this.future == null) {
                return;
            }
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                if (!this.repurposed) {
                    CurrentTaskFuture.this.asyncContext.jobDone();
                    this.done = true;
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean waitForResult(long timeout, TimeUnit unit) throws InterruptedException, MultiException {
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                long elapsedTime;
                for (long totalWaitTimeMillis = TimeUnit.MILLISECONDS.convert(timeout, unit); totalWaitTimeMillis > 0L && !this.done && !this.repurposed; totalWaitTimeMillis -= elapsedTime) {
                    long startTime = System.currentTimeMillis();
                    this.wait(totalWaitTimeMillis);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                if (this.repurposed) {
                    return null;
                }
                return this.done;
            }
        }
    }

    private static class CancelTimer
    extends TimerTask {
        private final UpOneLevel parent;

        private CancelTimer(UpOneLevel parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.hardCancel();
        }
    }

    private class UpOneLevel
    implements Runnable {
        private final Object lock = new Object();
        private final Object queueLock = new Object();
        private final int upToThisLevel;
        private final CurrentTaskFuture currentTaskFuture;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private final List<ServiceHandle<Sorter>> sorters;
        private final UpAllTheWay master;
        private final int maxThreads;
        private final long cancelTimeout;
        private int numJobs;
        private int completedJobs;
        private MultiException accumulatedExceptions;
        private boolean cancelled = false;
        private CancelTimer hardCanceller;
        private int numJobsRunning = 0;
        private boolean hardCancelled = false;
        private final HashSet<ServiceHandle<?>> outstandingHandles = new HashSet();

        private UpOneLevel(int paramUpToThisLevel, UpAllTheWay master, CurrentTaskFuture currentTaskFuture2, List<ServiceHandle<RunLevelListener>> listeners, List<ServiceHandle<Sorter>> sorters, int maxThreads, long cancelTimeout) {
            this.upToThisLevel = paramUpToThisLevel;
            this.master = master;
            this.maxThreads = maxThreads;
            this.currentTaskFuture = currentTaskFuture2;
            this.listeners = listeners;
            this.sorters = sorters;
            this.cancelTimeout = cancelTimeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
                this.hardCanceller = new CancelTimer(this);
                CurrentTaskFuture.this.timer.schedule((TimerTask)this.hardCanceller, this.cancelTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hardCancel() {
            AsyncRunLevelContext asyncRunLevelContext = CurrentTaskFuture.this.asyncContext;
            synchronized (asyncRunLevelContext) {
                HashSet poisonMe;
                Object object = this.lock;
                synchronized (object) {
                    this.hardCancelled = true;
                }
                Iterator<ServiceHandle<?>> iterator = this.queueLock;
                synchronized (iterator) {
                    poisonMe = new HashSet(this.outstandingHandles);
                    this.outstandingHandles.clear();
                }
                for (ServiceHandle<?> handle : poisonMe) {
                    CurrentTaskFuture.this.asyncContext.hardCancelOne(handle.getActiveDescriptor());
                }
            }
            this.master.currentJobComplete(null);
        }

        private void jobRunning(ServiceHandle<?> handle) {
            ++this.numJobsRunning;
            this.outstandingHandles.add(handle);
        }

        private void jobFinished(ServiceHandle<?> handle) {
            this.outstandingHandles.remove(handle);
            --this.numJobsRunning;
        }

        private int getJobsRunning() {
            return this.numJobsRunning;
        }

        private List<ServiceHandle<?>> applySorters(List<ServiceHandle<?>> jobs) {
            List<ServiceHandle<?>> retVal = jobs;
            for (ServiceHandle<Sorter> sorterHandle : this.sorters) {
                List<ServiceHandle<?>> sortedList;
                Sorter sorter = (Sorter)sorterHandle.getService();
                if (sorter == null || (sortedList = sorter.sort(retVal)) == null) continue;
                retVal = sortedList;
            }
            return retVal;
        }

        @Override
        public void run() {
            Object jobsLock = new Object();
            List<ServiceHandle<?>> jobs = CurrentTaskFuture.this.locator.getAllServiceHandles((Filter)new IndexedFilter(){

                public boolean matches(Descriptor d) {
                    return UpOneLevel.this.upToThisLevel == Utilities.getRunLevelValue(CurrentTaskFuture.this.locator, d);
                }

                public String getAdvertisedContract() {
                    return RunLevel.class.getName();
                }

                public String getName() {
                    return null;
                }
            });
            jobs = this.applySorters(jobs);
            this.numJobs = jobs.size();
            if (this.numJobs <= 0) {
                this.jobComplete();
                return;
            }
            int runnersToCreate = (this.numJobs < this.maxThreads ? this.numJobs : this.maxThreads) - 1;
            if (!CurrentTaskFuture.this.useThreads) {
                runnersToCreate = 0;
            }
            for (int lcv = 0; lcv < runnersToCreate; ++lcv) {
                QueueRunner runner = new QueueRunner(CurrentTaskFuture.this.locator, CurrentTaskFuture.this.asyncContext, jobsLock, jobs, this, this.lock, this.maxThreads);
                CurrentTaskFuture.this.executor.execute(runner);
            }
            QueueRunner myRunner = new QueueRunner(CurrentTaskFuture.this.locator, CurrentTaskFuture.this.asyncContext, jobsLock, jobs, this, this.lock, this.maxThreads);
            myRunner.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable th, Descriptor descriptor) {
            Object object = this.lock;
            synchronized (object) {
                if (this.hardCancelled) {
                    return;
                }
                ErrorInformation info = CurrentTaskFuture.invokeOnError(this.currentTaskFuture, th, ErrorInformation.ErrorAction.GO_TO_NEXT_LOWER_LEVEL_AND_STOP, this.listeners, descriptor);
                if (ErrorInformation.ErrorAction.IGNORE.equals((Object)info.getAction())) {
                    return;
                }
                if (this.accumulatedExceptions == null) {
                    this.accumulatedExceptions = new MultiException();
                }
                this.accumulatedExceptions.addError(th);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void jobComplete() {
            boolean complete = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.hardCancelled) {
                    return;
                }
                ++this.completedJobs;
                if (this.completedJobs >= this.numJobs) {
                    complete = true;
                    if (this.hardCanceller != null) {
                        this.hardCanceller.cancel();
                        this.hardCanceller = null;
                    }
                }
            }
            if (complete) {
                this.master.currentJobComplete(this.accumulatedExceptions);
            }
        }
    }

    private class UpAllTheWay
    implements AllTheWay {
        private final Object lock = new Object();
        private int goingTo;
        private final int maxThreads;
        private final boolean useThreads;
        private final CurrentTaskFuture future;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private final List<ServiceHandle<Sorter>> sorters;
        private final long cancelTimeout;
        private int workingOn;
        private UpOneLevel currentJob;
        private boolean cancelled = false;
        private boolean done = false;
        private boolean repurposed = false;
        private MultiException exception = null;

        private UpAllTheWay(int goingTo, CurrentTaskFuture future, List<ServiceHandle<RunLevelListener>> listeners, List<ServiceHandle<Sorter>> sorters, int maxThreads, boolean useThreads, long cancelTimeout) {
            this.goingTo = goingTo;
            this.future = future;
            this.listeners = listeners;
            this.maxThreads = maxThreads;
            this.useThreads = useThreads;
            this.sorters = sorters;
            this.cancelTimeout = cancelTimeout;
            this.workingOn = CurrentTaskFuture.this.asyncContext.getCurrentLevel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
                CurrentTaskFuture.this.asyncContext.levelCancelled();
                this.currentJob.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean waitForResult(long timeout, TimeUnit unit) throws InterruptedException, MultiException {
            Object object = this.lock;
            synchronized (object) {
                long elapsedTime;
                for (long totalWaitTimeMillis = TimeUnit.MILLISECONDS.convert(timeout, unit); totalWaitTimeMillis > 0L && !this.done && !this.repurposed; totalWaitTimeMillis -= elapsedTime) {
                    long startTime = System.currentTimeMillis();
                    this.lock.wait(totalWaitTimeMillis);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                if (this.repurposed) {
                    return null;
                }
                if (this.done && this.exception != null) {
                    throw this.exception;
                }
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setGoingTo(int goingTo, boolean repurposed) {
            Object object = this.lock;
            synchronized (object) {
                this.goingTo = goingTo;
                if (repurposed) {
                    this.repurposed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void go() {
            Object object;
            if (this.useThreads) {
                Object object2 = this.lock;
                synchronized (object2) {
                    ++this.workingOn;
                    if (this.workingOn > this.goingTo) {
                        if (!this.repurposed) {
                            CurrentTaskFuture.this.asyncContext.jobDone();
                            this.done = true;
                        }
                        this.lock.notifyAll();
                        return;
                    }
                    this.currentJob = new UpOneLevel(this.workingOn, this, this.future, this.listeners, this.sorters, this.maxThreads, this.cancelTimeout);
                    CurrentTaskFuture.this.executor.execute(this.currentJob);
                    return;
                }
            }
            ++this.workingOn;
            while (this.workingOn <= this.goingTo) {
                object = this.lock;
                synchronized (object) {
                    if (this.done) {
                        break;
                    }
                    this.currentJob = new UpOneLevel(this.workingOn, this, this.future, this.listeners, this.sorters, 0, this.cancelTimeout);
                }
                this.currentJob.run();
                ++this.workingOn;
            }
            object = this.lock;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                if (!this.repurposed) {
                    CurrentTaskFuture.this.asyncContext.jobDone();
                    this.done = true;
                }
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void currentJobComplete(MultiException accumulatedExceptions) {
            CurrentTaskFuture.this.asyncContext.clearErrors();
            if (accumulatedExceptions != null) {
                DownAllTheWay downer = new DownAllTheWay(this.workingOn - 1, null, null);
                downer.run();
                Object object = this.lock;
                synchronized (object) {
                    this.done = true;
                    this.exception = accumulatedExceptions;
                    this.lock.notifyAll();
                    CurrentTaskFuture.this.asyncContext.jobDone();
                }
                return;
            }
            DownAllTheWay downer = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.cancelled) {
                    downer = new DownAllTheWay(this.workingOn - 1, null, null);
                }
            }
            if (downer != null) {
                downer.run();
                CurrentTaskFuture.invokeOnCancelled(this.future, this.workingOn - 1, this.listeners);
                object = this.lock;
                synchronized (object) {
                    this.done = true;
                    this.lock.notifyAll();
                    CurrentTaskFuture.this.asyncContext.jobDone();
                    return;
                }
            }
            CurrentTaskFuture.this.asyncContext.setCurrentLevel(this.workingOn);
            CurrentTaskFuture.this.invokeOnProgress(this.future, this.workingOn, this.listeners);
            if (this.useThreads) {
                this.go();
            }
        }
    }

    private static interface AllTheWay {
        public Boolean waitForResult(long var1, TimeUnit var3) throws InterruptedException, MultiException;
    }
}

