/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.config.beans.AttributeBean;
import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.DescriptionBean;
import com.sun.faces.config.beans.PropertyBean;
import com.sun.faces.config.beans.RendererBean;
import com.sun.faces.generate.GeneratorUtil;
import com.sun.faces.generate.JspTLDGenerator;
import com.sun.faces.generate.PropertyManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JspTLD12Generator
extends JspTLDGenerator {
    private static final String JSF_TLIB_VERSION = "1.0";
    private static final String JSP_VERSION = "1.2";

    public JspTLD12Generator(PropertyManager propManager) {
        super(propManager);
    }

    @Override
    protected void writeProlog() throws IOException {
        super.writeProlog();
        this.writeDocType();
    }

    @Override
    protected void writeTldDescription() throws IOException {
        this.writer.startElement("taglib");
        this.writer.writeComment("============== Tag Library Description Elements =============");
        this.writer.startElement("tlib-version");
        this.writer.writeText(JSF_TLIB_VERSION);
        this.writer.closeElement();
        this.writer.startElement("jsp-version");
        this.writer.writeText(JSP_VERSION);
        this.writer.closeElement();
        this.writer.startElement("short-name");
        this.writer.writeText(this.propManager.getProperty("taglib.shortname"));
        this.writer.closeElement();
        this.writer.startElement("uri");
        this.writer.writeText(this.propManager.getProperty("taglib.uri"));
        this.writer.closeElement();
        String description = this.propManager.getProperty("taglib.description");
        if (description != null && description.length() > 0) {
            this.writer.startElement("description");
            this.writer.writeText(description);
            this.writer.closeElement();
        }
    }

    @Override
    protected void writeTags() throws IOException {
        this.writer.writeComment("===================== HTML 4.0 basic tags ======================");
        Map<String, ComponentBean> componentsByComponentFamily = GeneratorUtil.getComponentFamilyComponentMap(this.configBean);
        Map<String, ArrayList<RendererBean>> renderersByComponentFamily = GeneratorUtil.getComponentFamilyRendererMap(this.configBean, this.propManager.getProperty("renderkit.id"));
        String targetPackage = this.propManager.getProperty("target.package");
        for (Map.Entry<String, ArrayList<RendererBean>> entry : renderersByComponentFamily.entrySet()) {
            String componentFamily = entry.getKey();
            List renderers = entry.getValue();
            for (RendererBean renderer : renderers) {
                String descriptionText;
                String rendererType = renderer.getRendererType();
                this.writer.startElement("tag");
                String tagName = this.makeTldTagName(GeneratorUtil.stripJavaxFacesPrefix(componentFamily), GeneratorUtil.stripJavaxFacesPrefix(rendererType));
                if (tagName == null) {
                    throw new IllegalStateException("Could not determine tag name");
                }
                this.writer.startElement("name");
                this.writer.writeText(tagName);
                this.writer.closeElement();
                if (GeneratorUtil.makeTagClassName(GeneratorUtil.stripJavaxFacesPrefix(componentFamily), GeneratorUtil.stripJavaxFacesPrefix(rendererType)) == null) {
                    throw new IllegalStateException("Could not determine tag class name");
                }
                this.writer.startElement("tag-class");
                this.writer.writeText(targetPackage + '.' + GeneratorUtil.makeTagClassName(GeneratorUtil.stripJavaxFacesPrefix(componentFamily), GeneratorUtil.stripJavaxFacesPrefix(rendererType)));
                this.writer.closeElement();
                this.writer.startElement("body-content");
                this.writer.writeText(this.getBodyContent(tagName));
                this.writer.closeElement();
                DescriptionBean description = renderer.getDescription("");
                if (description != null && (descriptionText = description.getDescription().trim()) != null) {
                    this.writer.startElement("description");
                    StringBuffer sb = new StringBuffer();
                    sb.append("<![CDATA[");
                    sb.append(descriptionText);
                    sb.append("]]>\n");
                    this.writer.writeText(sb.toString());
                    this.writer.closeElement();
                }
                ComponentBean component = componentsByComponentFamily.get(componentFamily);
                for (PropertyBean property : component.getProperties()) {
                    String descriptionText2;
                    if (null == property || !property.isTagAttribute()) continue;
                    this.writer.startElement("attribute");
                    this.writer.startElement("name");
                    this.writer.writeText(property.getPropertyName());
                    this.writer.closeElement();
                    this.writer.startElement("required");
                    this.writer.writeText(property.isRequired() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    this.writer.closeElement();
                    this.writer.startElement("rtexprvalue");
                    this.writer.writeText(this.getRtexprvalue(tagName, property.getPropertyName()));
                    this.writer.closeElement();
                    description = property.getDescription("");
                    if (description != null && (descriptionText2 = description.getDescription().trim()) != null) {
                        this.writer.startElement("description");
                        StringBuffer sb = new StringBuffer();
                        sb.append("<![CDATA[");
                        sb.append(descriptionText2);
                        sb.append("]]>\n");
                        this.writer.writeText(sb.toString());
                        this.writer.closeElement();
                    }
                    this.writer.closeElement();
                }
                for (AttributeBean attribute : renderer.getAttributes()) {
                    String descriptionText3;
                    if (null == attribute || !attribute.isTagAttribute() || this.attributeShouldBeExcluded(renderer, attribute.getAttributeName())) continue;
                    this.writer.startElement("attribute");
                    this.writer.startElement("name");
                    this.writer.writeText(attribute.getAttributeName());
                    this.writer.closeElement();
                    this.writer.startElement("required");
                    this.writer.writeText(attribute.isRequired() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    this.writer.closeElement();
                    this.writer.startElement("rtexprvalue");
                    this.writer.writeText(this.getRtexprvalue(tagName, attribute.getAttributeName()));
                    this.writer.closeElement();
                    description = attribute.getDescription("");
                    if (description != null && (descriptionText3 = description.getDescription().trim()) != null) {
                        this.writer.startElement("description");
                        StringBuffer sb = new StringBuffer();
                        sb.append("<![CDATA[");
                        sb.append(descriptionText3);
                        sb.append("]]>\n");
                        this.writer.writeText(sb.toString());
                        this.writer.closeElement();
                    }
                    this.writer.closeElement();
                }
                this.writer.startElement("attribute");
                this.writer.startElement("name");
                this.writer.writeText("binding");
                this.writer.closeElement();
                this.writer.startElement("required");
                this.writer.writeText("false");
                this.writer.closeElement();
                this.writer.startElement("rtexprvalue");
                this.writer.writeText("false");
                this.writer.closeElement();
                this.writer.startElement("description");
                this.writer.writeText("The value binding expression linking this component to a property in a backing bean");
                this.writer.closeElement(3);
            }
        }
        String tagDef = this.loadOptionalTags();
        if (tagDef != null) {
            this.writer.write(tagDef);
        }
    }

    private void writeDocType() throws IOException {
        this.writer.write("\n<!DOCTYPE taglib\n");
        this.writer.write("PUBLIC \"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN\"\n");
        this.writer.write("\"http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd\">\n\n");
    }
}

