/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.MultiException;
import org.jvnet.hk2.config.InjectionResolver;
import org.jvnet.hk2.config.UnsatisfiedDependencyException;
import org.jvnet.hk2.config.WorkManager;

public class InjectionManager {
    public void inject(Object component, InjectionResolver ... targets) {
        this.syncDoInject(component, component.getClass(), targets);
    }

    public void inject(Object component, ExecutorService es, InjectionResolver ... targets) {
        try {
            this.syncDoInject(component, component.getClass(), targets);
        }
        catch (Exception e) {
            if (e instanceof MultiException) {
                throw (MultiException)((Object)e);
            }
            throw new MultiException((Throwable)e);
        }
    }

    public void inject(Object component, Class type, InjectionResolver ... targets) {
        this.syncDoInject(component, type, targets);
    }

    protected void syncDoInject(Object component, Class type, InjectionResolver ... targets) {
        assert (component != null);
        try {
            for (Class currentClass = type; currentClass != null && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
                for (final Field field : currentClass.getDeclaredFields()) {
                    Annotation nonOptionalAnnotation = null;
                    boolean injected = false;
                    for (InjectionResolver target : targets) {
                        Object inject = field.getAnnotation(target.type);
                        if (inject == null) continue;
                        Type genericType = field.getGenericType();
                        Class<?> fieldType = field.getType();
                        try {
                            Object value = target.getValue(component, field, genericType, fieldType);
                            if (value != null) {
                                AccessController.doPrivileged(new PrivilegedAction<Field>(){

                                    @Override
                                    public Field run() {
                                        field.setAccessible(true);
                                        return field;
                                    }
                                });
                                field.set(component, value);
                                injected = true;
                                break;
                            }
                            if (target.isOptional(field, inject)) continue;
                            nonOptionalAnnotation = (Annotation)inject;
                        }
                        catch (MultiException e) {
                            this.error_injectionException(target, (Annotation)inject, field, e);
                        }
                        catch (IllegalAccessException e) {
                            this.error_injectionException(target, (Annotation)inject, field, e);
                        }
                        catch (RuntimeException e) {
                            this.error_injectionException(target, (Annotation)inject, field, e);
                        }
                        catch (Exception ex) {
                            this.error_injectionException(target, (Annotation)inject, field, ex);
                        }
                    }
                    if (injected || nonOptionalAnnotation == null) continue;
                    throw new UnsatisfiedDependencyException(field, nonOptionalAnnotation);
                }
                for (AccessibleObject accessibleObject : currentClass.getDeclaredMethods()) {
                    for (InjectionResolver target : targets) {
                        Object inject = ((Method)accessibleObject).getAnnotation(target.type);
                        if (inject == null) continue;
                        final Method setter = target.getSetterMethod((Method)accessibleObject, inject);
                        if (setter.getReturnType() != Void.TYPE) {
                            if (Collection.class.isAssignableFrom(setter.getReturnType())) {
                                this.injectCollection(component, setter, target.getValue(component, accessibleObject, null, setter.getReturnType()));
                                continue;
                            }
                            this.error_InjectMethodIsNotVoid((Method)accessibleObject);
                        }
                        Class<?>[] paramTypes = setter.getParameterTypes();
                        Type[] genericParamTypes = setter.getGenericParameterTypes();
                        if (!this.allowInjection((Method)accessibleObject, paramTypes)) continue;
                        try {
                            if (1 == paramTypes.length) {
                                Object value = target.getValue(component, accessibleObject, genericParamTypes[0], paramTypes[0]);
                                if (value != null) {
                                    AccessController.doPrivileged(new PrivilegedAction<Method>(){

                                        @Override
                                        public Method run() {
                                            setter.setAccessible(true);
                                            return setter;
                                        }
                                    });
                                    setter.invoke(component, value);
                                    continue;
                                }
                                if (target.isOptional(accessibleObject, inject)) continue;
                                throw new UnsatisfiedDependencyException(accessibleObject, (Annotation)inject);
                            }
                            AccessController.doPrivileged(new PrivilegedAction<Method>(){

                                @Override
                                public Method run() {
                                    setter.setAccessible(true);
                                    return setter;
                                }
                            });
                            Type[] gparamType = setter.getGenericParameterTypes();
                            Object[] params = new Object[paramTypes.length];
                            for (int i = 0; i < paramTypes.length; ++i) {
                                Object value = target.getValue(component, accessibleObject, gparamType[i], paramTypes[i]);
                                if (value != null) {
                                    params[i] = value;
                                    continue;
                                }
                                if (target.isOptional(accessibleObject, inject)) continue;
                                throw new UnsatisfiedDependencyException(accessibleObject, (Annotation)inject);
                            }
                            setter.invoke(component, params);
                        }
                        catch (MultiException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                        catch (IllegalAccessException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                        catch (InvocationTargetException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                        catch (RuntimeException e) {
                            this.error_injectionException(target, (Annotation)inject, setter, e);
                        }
                    }
                }
            }
        }
        catch (LinkageError e) {
            final Class cls = type;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    LinkageError x = new LinkageError("injection failed on " + cls + " from " + cls.getClassLoader());
                    x.initCause(e);
                    throw x;
                }
            });
        }
    }

    protected void error_injectionException(InjectionResolver target, Annotation inject, AnnotatedElement injectionPoint, Throwable e) {
        Logger.getAnonymousLogger().log(Level.FINE, "** Injection failure **", e);
        if (UnsatisfiedDependencyException.class.isInstance(e)) {
            if (injectionPoint == ((UnsatisfiedDependencyException)((Object)e)).getUnsatisfiedElement()) {
                throw (UnsatisfiedDependencyException)((Object)e);
            }
            if (target.isOptional(injectionPoint, inject)) {
                return;
            }
            throw new UnsatisfiedDependencyException(injectionPoint, inject, e);
        }
        if (null != e.getCause() && InvocationTargetException.class.isInstance(e)) {
            e = e.getCause();
        }
        throw new MultiException(e);
    }

    protected boolean allowInjection(Method method, Class<?>[] paramTypes) {
        return true;
    }

    protected void error_InjectMethodIsNotVoid(Method method) {
        throw new MultiException((Throwable)new IllegalStateException("Injection failed on " + method.getName() + " : setter method is not declared with a void return type"));
    }

    private void injectCollection(Object component, Method method, Object value) {
        if (value == null) {
            return;
        }
        Collection c = (Collection)Collection.class.cast(value);
        Collection target = null;
        try {
            target = (Collection)Collection.class.cast(method.invoke(component, new Object[0]));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        target.addAll(c);
    }

    protected class InjectMethod
    implements Runnable {
        private final InjectContext ic;
        private final Method method;
        private final Annotation inject;
        private final InjectionResolver target;

        public InjectMethod(InjectClass iClass, Method method, Annotation inject, InjectionResolver target) {
            this.ic = iClass.ic;
            this.method = method;
            this.inject = inject;
            this.target = target;
        }

        @Override
        public void run() {
            Class<?>[] paramTypes;
            final Method setter = this.target.getSetterMethod(this.method, this.inject);
            if (Void.TYPE != setter.getReturnType()) {
                if (Collection.class.isAssignableFrom(setter.getReturnType())) {
                    InjectionManager.this.injectCollection(this.ic.component, setter, this.target.getValue(this.ic.component, this.method, null, setter.getReturnType()));
                } else {
                    InjectionManager.this.error_InjectMethodIsNotVoid(this.method);
                }
            }
            if (InjectionManager.this.allowInjection(this.method, paramTypes = setter.getParameterTypes())) {
                try {
                    if (1 == paramTypes.length) {
                        Object value = this.target.getValue(this.ic.component, this.method, null, paramTypes[0]);
                        if (value != null) {
                            AccessController.doPrivileged(new PrivilegedAction<Method>(){

                                @Override
                                public Method run() {
                                    setter.setAccessible(true);
                                    return setter;
                                }
                            });
                            setter.invoke(this.ic.component, value);
                        } else if (!this.target.isOptional(this.method, this.inject)) {
                            throw new UnsatisfiedDependencyException(this.method, this.inject);
                        }
                    } else {
                        AccessController.doPrivileged(new PrivilegedAction<Method>(){

                            @Override
                            public Method run() {
                                setter.setAccessible(true);
                                return setter;
                            }
                        });
                        Type[] gparamType = setter.getGenericParameterTypes();
                        Object[] params = new Object[paramTypes.length];
                        for (int i = 0; i < paramTypes.length; ++i) {
                            Object value = this.target.getValue(this.ic.component, this.method, gparamType[i], paramTypes[i]);
                            if (value != null) {
                                params[i] = value;
                                continue;
                            }
                            if (this.target.isOptional(this.method, this.inject)) continue;
                            throw new UnsatisfiedDependencyException(this.method, this.inject);
                        }
                        setter.invoke(this.ic.component, params);
                    }
                }
                catch (MultiException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter, e);
                }
                catch (IllegalAccessException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter, e);
                }
                catch (InvocationTargetException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter, e);
                }
                catch (RuntimeException e) {
                    InjectionManager.this.error_injectionException(this.target, this.inject, setter, e);
                }
            }
        }
    }

    protected class InjectField
    implements Runnable {
        private final InjectContext ic;
        private final Field field;
        private final Annotation inject;
        private final InjectionResolver target;

        public InjectField(InjectClass iClass, Field field, Annotation inject, InjectionResolver target) {
            this.ic = iClass.ic;
            this.field = field;
            this.inject = inject;
            this.target = target;
        }

        @Override
        public void run() {
            Type genericType = this.field.getGenericType();
            Class<?> fieldType = this.field.getType();
            try {
                Object value = this.target.getValue(this.ic.component, this.field, genericType, fieldType);
                if (value != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Field>(){

                        @Override
                        public Field run() {
                            InjectField.this.field.setAccessible(true);
                            return InjectField.this.field;
                        }
                    });
                    this.field.set(this.ic.component, value);
                } else if (!this.target.isOptional(this.field, this.inject)) {
                    throw new UnsatisfiedDependencyException(this.field, this.inject);
                }
            }
            catch (MultiException e) {
                InjectionManager.this.error_injectionException(this.target, this.inject, this.field, e);
            }
            catch (IllegalAccessException e) {
                InjectionManager.this.error_injectionException(this.target, this.inject, this.field, e);
            }
            catch (RuntimeException e) {
                InjectionManager.this.error_injectionException(this.target, this.inject, this.field, e);
            }
        }
    }

    protected class InjectMethods
    implements Runnable {
        private final InjectClass iClass;

        public InjectMethods(InjectClass iClass) {
            this.iClass = iClass;
        }

        @Override
        public void run() {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            for (Method method : this.iClass.classType.getDeclaredMethods()) {
                for (InjectionResolver target : ((InjectClass)this.iClass).ic.targets) {
                    Object inject = method.getAnnotation(target.type);
                    if (inject == null) continue;
                    tasks.add(new InjectMethod(this.iClass, method, (Annotation)inject, target));
                }
            }
            WorkManager wm = new WorkManager(((InjectClass)this.iClass).ic.es, tasks.size());
            wm.executeAll(tasks);
            wm.awaitCompletion();
        }
    }

    protected class InjectFields
    implements Runnable {
        private final InjectClass iClass;

        public InjectFields(InjectClass iClass) {
            this.iClass = iClass;
        }

        @Override
        public void run() {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            for (Field field : this.iClass.classType.getDeclaredFields()) {
                for (InjectionResolver target : ((InjectClass)this.iClass).ic.targets) {
                    Object inject = field.getAnnotation(target.type);
                    if (inject == null) continue;
                    tasks.add(new InjectField(this.iClass, field, (Annotation)inject, target));
                }
            }
            WorkManager wm = new WorkManager(((InjectClass)this.iClass).ic.es, tasks.size());
            wm.executeAll(tasks);
            wm.awaitCompletion();
        }
    }

    protected class InjectClass
    implements Runnable {
        private final Class<?> classType;
        private final InjectContext ic;

        public InjectClass(Class type, InjectContext ic) {
            this.classType = type;
            this.ic = ic;
        }

        @Override
        public void run() {
            WorkManager wm = new WorkManager(this.ic.es, 2);
            wm.execute(new InjectMethods(this));
            wm.execute(new InjectFields(this));
            wm.awaitCompletion();
            new InjectMethods(this).run();
            new InjectFields(this).run();
        }
    }

    protected static class InjectContext {
        public final Object component;
        public final ExecutorService es;
        public final InjectionResolver[] targets;

        public InjectContext(Object component, ExecutorService es, InjectionResolver[] targets) {
            assert (null != component);
            this.component = component;
            this.es = es;
            this.targets = targets;
        }
    }
}

