/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.util;

import com.sun.xml.ws.transport.tcp.util.WSTCPException;
import java.util.HashMap;
import java.util.Map;

public final class ContentType {
    private String mimeType;
    private final Map<String, String> parameters = new HashMap<String, String>(4);

    public String getMimeType() {
        return this.mimeType;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void parse(String contentType) throws WSTCPException {
        this.parameters.clear();
        int mimeDelim = contentType.indexOf(59);
        if (mimeDelim == -1) {
            this.mimeType = contentType.trim().toLowerCase();
            return;
        }
        this.mimeType = contentType.substring(0, mimeDelim).trim().toLowerCase();
        int delim = mimeDelim + 1;
        while (delim < contentType.length()) {
            int eqDelim;
            int nextDelim = contentType.indexOf(59, delim);
            if (nextDelim == -1) {
                nextDelim = contentType.length();
            }
            if ((eqDelim = contentType.indexOf(61, delim)) == -1) {
                eqDelim = nextDelim;
            }
            String key = contentType.substring(delim, eqDelim).trim();
            String value = contentType.substring(eqDelim + 1, nextDelim).trim();
            this.parameters.put(key, value);
            delim = nextDelim + 1;
        }
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ContentType) {
            ContentType ctToCompare = (ContentType)o;
            return this.mimeType.equals(ctToCompare.mimeType) && ctToCompare.parameters.equals(this.parameters);
        }
        return false;
    }

    public int hashCode() {
        return this.mimeType.hashCode() ^ this.parameters.hashCode();
    }
}

