/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.StringUtils;

public final class Paths {
    public static final String DAS_PROPS_FILENAME = "das.properties";
    public static final String DAS_PROPS_SUBPATH = "agent/config/das.properties";

    public static final String getNodesDir(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        String nodesDir = node.getNodeDirAbsoluteUnixStyle();
        if (nodesDir == null) {
            nodesDir = node.getInstallDirUnixStyle() + "/glassfish/nodes";
        }
        return nodesDir;
    }

    public static final String getNodeDir(Node node) {
        return Paths.getNodesDir(node) + "/" + node.getName();
    }

    public static final String getDasPropsPath(Node node) {
        return Paths.getNodeDir(node) + "/" + DAS_PROPS_SUBPATH;
    }

    public static String getInstanceDirPath(Node node, String instanceName) {
        if (!StringUtils.ok((String)instanceName)) {
            throw new IllegalArgumentException();
        }
        return Paths.getNodeDir(node) + "/" + instanceName;
    }

    private Paths() {
    }
}

