/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.v3.admin.adapter.AdapterState;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.enterprise.v3.server.ApplicationLoaderService;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

final class InstallerThread
extends Thread {
    private final Domain domain;
    private final ServerEnvironmentImpl env;
    private final String contextRoot;
    private final AdminConsoleAdapter adapter;
    private final ServiceLocator habitat;
    private final Logger log = KernelLoggerInfo.getLogger();
    private final List<String> vss;

    InstallerThread(AdminConsoleAdapter adapter, ServiceLocator habitat, Domain domain, ServerEnvironmentImpl env, String contextRoot, List<String> vss) {
        this.adapter = adapter;
        this.habitat = habitat;
        this.domain = domain;
        this.env = env;
        this.contextRoot = contextRoot;
        this.vss = vss;
    }

    @Override
    public void run() {
        try {
            this.install();
            this.load();
            this.adapter.setInstalling(false);
        }
        catch (Exception ex) {
            this.adapter.setInstalling(false);
            this.adapter.setStateMsg(AdapterState.APPLICATION_NOT_INSTALLED);
            this.log.log(Level.INFO, "NCLS-CORE-00093", ex);
        }
    }

    private void install() throws Exception {
        if (this.domain.getSystemApplicationReferencedFrom(this.env.getInstanceName(), "__admingui") != null) {
            this.adapter.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
            return;
        }
        this.adapter.setStateMsg(AdapterState.INSTALLING);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Installing the Admin Console Application...");
        }
        ConfigCode code = new ConfigCode(){

            public Object run(ConfigBeanProxy ... proxies) throws PropertyVetoException, TransactionFailure {
                SystemApplications sa = (SystemApplications)proxies[0];
                Application app = (Application)sa.createChild(Application.class);
                sa.getModules().add(app);
                app.setName("__admingui");
                app.setEnabled(Boolean.TRUE.toString());
                app.setObjectType("system-admin");
                app.setDirectoryDeployed("true");
                app.setContextRoot(InstallerThread.this.contextRoot);
                try {
                    app.setLocation("${com.sun.aas.installRootURI}/lib/install/applications/__admingui");
                }
                catch (Exception me) {
                    throw new RuntimeException(me);
                }
                Module singleModule = (Module)app.createChild(Module.class);
                app.getModule().add(singleModule);
                singleModule.setName(app.getName());
                Engine webe = (Engine)singleModule.createChild(Engine.class);
                webe.setSniffer("web");
                Engine sece = (Engine)singleModule.createChild(Engine.class);
                sece.setSniffer("security");
                singleModule.getEngines().add(webe);
                singleModule.getEngines().add(sece);
                Server s = (Server)proxies[1];
                List arefs = s.getApplicationRef();
                ApplicationRef aref = (ApplicationRef)s.createChild(ApplicationRef.class);
                aref.setRef(app.getName());
                aref.setEnabled(Boolean.TRUE.toString());
                aref.setVirtualServers(InstallerThread.this.getVirtualServerList());
                arefs.add(aref);
                return true;
            }
        };
        Server server = this.domain.getServerNamed(this.env.getInstanceName());
        ConfigSupport.apply((ConfigCode)code, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.domain.getSystemApplications(), server});
        this.adapter.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Admin Console Application Installed.");
        }
    }

    private String getVirtualServerList() {
        if (this.vss == null) {
            return "";
        }
        String s = Arrays.toString(this.vss.toArray(new String[this.vss.size()]));
        s = s.substring(1, s.length() - 1);
        return s;
    }

    private void load() {
        ApplicationRegistry appRegistry = (ApplicationRegistry)this.habitat.getService(ApplicationRegistry.class, new Annotation[0]);
        ApplicationInfo appInfo = appRegistry.get("__admingui");
        if (appInfo != null && appInfo.isLoaded()) {
            this.adapter.setStateMsg(AdapterState.APPLICATION_LOADED);
            return;
        }
        Application config = this.adapter.getConfig();
        if (config == null) {
            throw new IllegalStateException("Admin Console application has no system app entry!");
        }
        this.adapter.setStateMsg(AdapterState.APPLICATION_LOADING);
        String sn = this.env.getInstanceName();
        ApplicationRef ref = this.domain.getApplicationRefInServer(sn, "__admingui");
        ((ApplicationLoaderService)this.habitat.getService(ApplicationLoaderService.class, new Annotation[0])).processApplication(config, ref);
        this.adapter.setStateMsg(AdapterState.APPLICATION_LOADED);
    }
}

