/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.manager.tasks;

import com.sun.faces.config.manager.FacesConfigInfo;
import com.sun.faces.config.manager.documents.DocumentInfo;
import com.sun.faces.spi.AnnotationScanner;
import com.sun.faces.spi.InjectionProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ProvideMetadataToAnnotationScanTask {
    private static final Pattern JAR_PATTERN = Pattern.compile("(.*/(\\S*\\.jar)).*(/faces-config.xml|/*.\\.faces-config.xml)");
    private final DocumentInfo[] documentInfos;
    private final InjectionProvider containerConnector;
    private Set<URI> uris;
    private Set<String> jarNames;

    public ProvideMetadataToAnnotationScanTask(DocumentInfo[] documentInfos, InjectionProvider containerConnector) {
        this.documentInfos = documentInfos;
        this.containerConnector = containerConnector;
    }

    private void initializeIvars(Set<Class<?>> annotatedSet) {
        if (this.uris != null || this.jarNames != null) {
            return;
        }
        this.uris = new HashSet<URI>(this.documentInfos.length);
        this.jarNames = new HashSet<String>(this.documentInfos.length);
        for (DocumentInfo docInfo : this.documentInfos) {
            String jarName;
            URI sourceURI = docInfo.getSourceURI();
            Matcher jarMatcher = JAR_PATTERN.matcher(sourceURI == null ? "" : sourceURI.toString());
            if (!jarMatcher.matches() || this.jarNames.contains(jarName = jarMatcher.group(2))) continue;
            FacesConfigInfo configInfo = new FacesConfigInfo(docInfo);
            if (!configInfo.isMetadataComplete()) {
                this.uris.add(sourceURI);
                this.jarNames.add(jarName);
                continue;
            }
            ArrayList toRemove = new ArrayList(1);
            String sourceURIString = sourceURI.toString();
            if (annotatedSet == null) continue;
            for (Class clazz : annotatedSet) {
                if (!sourceURIString.contains(clazz.getProtectionDomain().getCodeSource().getLocation().toString())) continue;
                toRemove.add(clazz);
            }
            annotatedSet.removeAll(toRemove);
        }
    }

    public Set<URI> getAnnotationScanURIs(Set<Class<?>> annotatedSet) {
        this.initializeIvars(annotatedSet);
        return this.uris;
    }

    public Set<String> getJarNames(Set<Class<?>> annotatedSet) {
        this.initializeIvars(annotatedSet);
        return this.jarNames;
    }

    public AnnotationScanner getAnnotationScanner() {
        if (this.containerConnector instanceof AnnotationScanner) {
            return (AnnotationScanner)((Object)this.containerConnector);
        }
        return null;
    }
}

