/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.proxy.ProxyInstantiator;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.ConstructorInterceptionInstantiator;
import org.jboss.weld.injection.producer.DefaultInstantiator;
import org.jboss.weld.injection.producer.DefaultLifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.Injector;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.injection.producer.InterceptorApplyingInstantiator;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.NoopLifecycleCallbackInvoker;
import org.jboss.weld.injection.producer.ResourceInjector;
import org.jboss.weld.injection.producer.SubclassDecoratorApplyingInstantiator;
import org.jboss.weld.injection.producer.SubclassedComponentInstantiator;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.reflection.Formats;

public class BeanInjectionTarget<T>
extends BasicInjectionTarget<T> {
    private final Bean<T> bean;

    public static <T> BeanInjectionTarget<T> createDefault(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        return new BeanInjectionTarget<T>(type, bean, beanManager);
    }

    public static <T> BeanInjectionTarget<T> forCdiInterceptor(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl manager) {
        return new BeanInjectionTarget<T>(type, bean, manager, ResourceInjector.of(type, bean, manager), NoopLifecycleCallbackInvoker.getInstance());
    }

    public BeanInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager, Injector<T> injector, LifecycleCallbackInvoker<T> invoker) {
        super(type, bean, beanManager, injector, invoker);
        this.bean = bean;
    }

    public BeanInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, BeanManagerImpl beanManager) {
        this(type, bean, beanManager, ResourceInjector.of(type, bean, beanManager), DefaultLifecycleCallbackInvoker.of(type));
    }

    @Override
    public void dispose(T instance) {
    }

    protected boolean isInterceptor() {
        return this.getBean() instanceof Interceptor || this.getType().isAnnotationPresent(javax.interceptor.Interceptor.class);
    }

    protected boolean isDecorator() {
        return this.getBean() instanceof Decorator || this.getType().isAnnotationPresent(javax.decorator.Decorator.class);
    }

    protected boolean isInterceptionCandidate() {
        return !this.isInterceptor() && !this.isDecorator() && !Modifier.isAbstract(this.getType().getJavaClass().getModifiers());
    }

    protected void initializeInterceptionModel(EnhancedAnnotatedType<T> annotatedType) {
        AbstractInstantiator instantiator = (AbstractInstantiator)this.getInstantiator();
        if (instantiator.getConstructorInjectionPoint() == null) {
            return;
        }
        if (this.isInterceptionCandidate() && !this.beanManager.getInterceptorModelRegistry().containsKey(this.getType())) {
            this.buildInterceptionModel(annotatedType, instantiator);
        }
    }

    protected void buildInterceptionModel(EnhancedAnnotatedType<T> annotatedType, AbstractInstantiator<T> instantiator) {
        new InterceptionModelInitializer<T>(this.beanManager, annotatedType, annotatedType.getDeclaredEnhancedConstructor(instantiator.getConstructorInjectionPoint().getSignature()), this.getBean()).init();
    }

    @Override
    public void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> annotatedType) {
        boolean hasDecorators;
        this.initializeInterceptionModel(annotatedType);
        InterceptionModel interceptionModel = null;
        if (this.isInterceptionCandidate()) {
            interceptionModel = (InterceptionModel)this.beanManager.getInterceptorModelRegistry().get(this.getType());
        }
        boolean hasNonConstructorInterceptors = interceptionModel != null && (interceptionModel.hasExternalNonConstructorInterceptors() || interceptionModel.hasTargetClassInterceptors());
        List<Decorator<?>> decorators = null;
        if (this.getBean() != null && this.isInterceptionCandidate()) {
            decorators = this.beanManager.resolveDecorators((Set<Type>)this.getBean().getTypes(), this.getBean().getQualifiers());
        }
        boolean bl = hasDecorators = decorators != null && !decorators.isEmpty();
        if (hasDecorators) {
            this.checkDecoratedMethods(annotatedType, decorators);
        }
        if (hasNonConstructorInterceptors || hasDecorators) {
            if (!(this.getInstantiator() instanceof DefaultInstantiator)) {
                throw new IllegalStateException("Unexpected instantiator " + this.getInstantiator());
            }
            DefaultInstantiator delegate = (DefaultInstantiator)this.getInstantiator();
            this.setInstantiator(SubclassedComponentInstantiator.forInterceptedDecoratedBean(annotatedType, this.getBean(), delegate, this.beanManager));
            if (hasDecorators) {
                this.setInstantiator(new SubclassDecoratorApplyingInstantiator(this.getBeanManager().getContextId(), this.getInstantiator(), this.getBean(), decorators));
            }
            if (hasNonConstructorInterceptors) {
                this.setInstantiator(new InterceptorApplyingInstantiator(this.getInstantiator(), interceptionModel, this.getType()));
            }
        }
        if (this.isInterceptionCandidate()) {
            this.setupConstructorInterceptionInstantiator(interceptionModel);
        }
    }

    protected void setupConstructorInterceptionInstantiator(InterceptionModel interceptionModel) {
        if (interceptionModel != null && interceptionModel.hasExternalConstructorInterceptors()) {
            this.setInstantiator(new ConstructorInterceptionInstantiator(this.getInstantiator(), interceptionModel, this.getType()));
        }
    }

    protected void checkNoArgsConstructor(EnhancedAnnotatedType<T> type) {
        if (!this.beanManager.getServices().get(ProxyInstantiator.class).isUsingConstructor()) {
            return;
        }
        EnhancedAnnotatedConstructor<T> constructor = type.getNoArgsEnhancedConstructor();
        if (constructor == null) {
            throw BeanLogger.LOG.decoratedHasNoNoargsConstructor(this);
        }
        if (constructor.isPrivate()) {
            throw BeanLogger.LOG.decoratedNoargsConstructorIsPrivate(this, Formats.formatAsStackTraceElement(constructor.getJavaMember()));
        }
    }

    protected void checkDecoratedMethods(EnhancedAnnotatedType<T> type, List<Decorator<?>> decorators) {
        if (type.isFinal()) {
            throw BeanLogger.LOG.finalBeanClassWithDecoratorsNotAllowed(this);
        }
        this.checkNoArgsConstructor(type);
        for (Decorator<?> decorator : decorators) {
            EnhancedAnnotatedType<Object> decoratorClass;
            if (decorator instanceof DecoratorImpl) {
                DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                decoratorClass = decoratorBean.getBeanManager().getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(decoratorBean.getAnnotated());
            } else if (decorator instanceof CustomDecoratorWrapper) {
                decoratorClass = ((CustomDecoratorWrapper)decorator).getEnhancedAnnotated();
            } else {
                throw BeanLogger.LOG.nonContainerDecorator(decorator);
            }
            for (EnhancedAnnotatedMethod<?, ?> decoratorMethod : decoratorClass.getEnhancedMethods()) {
                EnhancedAnnotatedMethod method = type.getEnhancedMethod(decoratorMethod.getSignature());
                if (method == null || method.isStatic() || method.isPrivate() || !method.isFinal()) continue;
                throw BeanLogger.LOG.finalBeanClassWithInterceptorsNotAllowed(this);
            }
        }
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        T instance = super.produce(ctx);
        if (this.bean != null && !this.bean.getScope().equals(Dependent.class) && !this.getInstantiator().hasDecoratorSupport()) {
            ctx.push(instance);
        }
        return instance;
    }

    @Override
    public Bean<T> getBean() {
        return this.bean;
    }
}

