/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.concurrent.ManagedThreadFactory;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.concurrent.LogFacade;
import org.glassfish.concurrent.runtime.ConcurrentRuntime;
import org.glassfish.concurrent.runtime.deployer.ManagedThreadFactoryConfig;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.naming.SerializableObjectRefAddr;
import org.jvnet.hk2.annotations.Service;

@Service
@ResourceDeployerInfo(value=org.glassfish.concurrent.config.ManagedThreadFactory.class)
@Singleton
public class ManagedThreadFactoryDeployer
implements ResourceDeployer {
    @Inject
    private ResourceNamingService namingService;
    @Inject
    ConcurrentRuntime concurrentRuntime;
    private static Logger _logger = LogFacade.getLogger();

    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        org.glassfish.concurrent.config.ManagedThreadFactory ManagedThreadFactoryRes = (org.glassfish.concurrent.config.ManagedThreadFactory)resource;
        if (ManagedThreadFactoryRes == null) {
            _logger.log(Level.WARNING, "AS-CONCURRENT-00004", "ManagedThreadFactory");
            return;
        }
        String jndiName = ManagedThreadFactoryRes.getJndiName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ManagedThreadFactoryDeployer.deployResource() : jndi-name [" + jndiName + "]");
        }
        ResourceInfo resourceInfo = new ResourceInfo(ManagedThreadFactoryRes.getJndiName(), applicationName, moduleName);
        ManagedThreadFactoryConfig config = new ManagedThreadFactoryConfig(ManagedThreadFactoryRes);
        Reference ref = new Reference(ManagedThreadFactory.class.getName(), "org.glassfish.concurrent.runtime.deployer.ConcurrentObjectFactory", null);
        SerializableObjectRefAddr addr = new SerializableObjectRefAddr(ManagedThreadFactoryConfig.class.getName(), (Object)config);
        ref.add((RefAddr)addr);
        SerializableObjectRefAddr resAddr = new SerializableObjectRefAddr(ResourceInfo.class.getName(), (Object)resourceInfo);
        ref.add((RefAddr)resAddr);
        try {
            this.namingService.publishObject(resourceInfo, (Object)ref, true);
        }
        catch (NamingException ex) {
            LogHelper.log((Logger)_logger, (Level)Level.SEVERE, (String)"AS-CONCURRENT-00003", (Throwable)ex, (Object[])new Object[]{"ManagedThreadFactory", jndiName});
        }
    }

    public void deployResource(Object resource) throws Exception {
        org.glassfish.concurrent.config.ManagedThreadFactory ManagedThreadFactoryResource = (org.glassfish.concurrent.config.ManagedThreadFactory)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)ManagedThreadFactoryResource);
        this.deployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    public void undeployResource(Object resource) throws Exception {
        org.glassfish.concurrent.config.ManagedThreadFactory ManagedThreadFactoryResource = (org.glassfish.concurrent.config.ManagedThreadFactory)resource;
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo((BindableResource)ManagedThreadFactoryResource);
        this.undeployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        org.glassfish.concurrent.config.ManagedThreadFactory managedThreadFactoryRes = (org.glassfish.concurrent.config.ManagedThreadFactory)resource;
        ResourceInfo resourceInfo = new ResourceInfo(managedThreadFactoryRes.getJndiName(), applicationName, moduleName);
        this.namingService.unpublishObject((GenericResourceInfo)resourceInfo, managedThreadFactoryRes.getJndiName());
        this.concurrentRuntime.shutdownManagedThreadFactory(managedThreadFactoryRes.getJndiName());
    }

    public void redeployResource(Object resource) throws Exception {
        this.undeployResource(resource);
        this.deployResource(resource);
    }

    public void enableResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    public void disableResource(Object resource) throws Exception {
        this.undeployResource(resource);
    }

    public boolean handles(Object resource) {
        return resource instanceof org.glassfish.concurrent.config.ManagedThreadFactory;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }
}

