/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.linkedlist.LinkedNode;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.ObjectDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class MergeManager {
    protected AbstractSession session;
    protected Map<Object, ObjectDescriptor> objectDescriptors;
    protected Map<AbstractSession, Map<Object, Object>> objectsAlreadyMerged;
    protected IdentityHashMap<Object, Object> mergedNewObjects;
    protected ArrayList<CacheKey> acquiredLocks;
    protected Object writeLockQueued;
    protected LinkedNode<MergeManager> queueNode;
    protected int mergePolicy;
    protected static final int WORKING_COPY_INTO_ORIGINAL = 1;
    protected static final int ORIGINAL_INTO_WORKING_COPY = 2;
    protected static final int CLONE_INTO_WORKING_COPY = 3;
    protected static final int WORKING_COPY_INTO_REMOTE = 4;
    protected static final int REFRESH_REMOTE_OBJECT = 5;
    protected static final int CHANGES_INTO_DISTRIBUTED_CACHE = 6;
    protected static final int CLONE_WITH_REFS_INTO_WORKING_COPY = 7;
    protected int cascadePolicy;
    public static final int NO_CASCADE = 1;
    public static final int CASCADE_PRIVATE_PARTS = 2;
    public static final int CASCADE_ALL_PARTS = 3;
    public static final int CASCADE_BY_MAPPING = 4;
    public static boolean LOCK_ON_MERGE = true;
    protected long systemTime = 0L;
    protected boolean forceCascade;
    protected boolean isTransitionedToDeferredLocks = false;
    protected Thread lockThread;
    protected boolean isForRefresh;

    public MergeManager(AbstractSession session) {
        this.session = session;
        this.mergedNewObjects = new IdentityHashMap();
        this.objectsAlreadyMerged = new IdentityHashMap<AbstractSession, Map<Object, Object>>();
        this.cascadePolicy = 3;
        this.mergePolicy = 1;
        this.acquiredLocks = new ArrayList();
    }

    public void cascadeAllParts() {
        this.setCascadePolicy(3);
    }

    public void cascadePrivateParts() {
        this.setCascadePolicy(2);
    }

    public void dontCascadeParts() {
        this.setCascadePolicy(1);
    }

    public ArrayList<CacheKey> getAcquiredLocks() {
        return this.acquiredLocks;
    }

    public int getCascadePolicy() {
        return this.cascadePolicy;
    }

    protected int getMergePolicy() {
        return this.mergePolicy;
    }

    public Map<Object, ObjectDescriptor> getObjectDescriptors() {
        if (this.objectDescriptors == null) {
            this.objectDescriptors = new IdentityHashMap<Object, ObjectDescriptor>();
        }
        return this.objectDescriptors;
    }

    public Map<AbstractSession, Map<Object, Object>> getObjectsAlreadyMerged() {
        return this.objectsAlreadyMerged;
    }

    public Object getObjectToMerge(Object sourceValue, ClassDescriptor descriptor, AbstractSession targetSession) {
        if (this.shouldMergeOriginalIntoWorkingCopy()) {
            return this.getTargetVersionOfSourceObject(sourceValue, descriptor, targetSession);
        }
        return sourceValue;
    }

    public LinkedNode<MergeManager> getQueueNode() {
        return this.queueNode;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public long getSystemTime() {
        if (this.systemTime == 0L) {
            this.systemTime = System.currentTimeMillis();
        }
        return this.systemTime;
    }

    public Object getTargetVersionOfSourceObject(Object source, ClassDescriptor descriptor, AbstractSession targetSession) {
        if (this.shouldMergeWorkingCopyIntoOriginal()) {
            Object registeredObject;
            Object original = null;
            CacheKey cacheKey = targetSession.getCacheKeyFromTargetSessionForMerge(source, descriptor.getObjectBuilder(), descriptor, this);
            if (cacheKey != null) {
                original = cacheKey.getObject();
            }
            if (original == null && (original = ((UnitOfWorkImpl)this.session).getOriginalVersionOfObjectOrNull(source, null, descriptor, targetSession)) == source && (registeredObject = this.registerExistingObjectOfReadOnlyClassInNestedTransaction(source, descriptor, targetSession)) != null) {
                original = registeredObject;
            }
            if (original == null) {
                original = ((UnitOfWorkImpl)this.session).buildOriginal(source);
                if (descriptor.getCopyPolicy().buildsNewInstance()) {
                    List<DatabaseMapping> pkMappings = descriptor.getObjectBuilder().getPrimaryKeyMappings();
                    for (DatabaseMapping mapping : pkMappings) {
                        mapping.buildClone(source, null, original, null, targetSession);
                    }
                }
            }
            return original;
        }
        if (this.shouldMergeWorkingCopyIntoRemote()) {
            return ((UnitOfWorkImpl)this.session).getOriginalVersionOfObject(source);
        }
        if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeOriginalIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            return this.registerObjectForMergeCloneIntoWorkingCopy(source, false);
        }
        if (this.shouldRefreshRemoteObject()) {
            Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(source, this.session);
            return this.session.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, source.getClass(), descriptor);
        }
        throw ValidationException.invalidMergePolicy();
    }

    public Object registerExistingObjectOfReadOnlyClassInNestedTransaction(Object source, ClassDescriptor descriptor, AbstractSession targetSession) {
        if (this.session.isUnitOfWork() && targetSession.isUnitOfWork()) {
            UnitOfWorkImpl uow = (UnitOfWorkImpl)this.session;
            if (uow.isNestedUnitOfWork && uow.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
                return ((UnitOfWorkImpl)targetSession).registerExistingObject(source);
            }
        }
        return null;
    }

    public Object getWriteLockQueued() {
        return this.writeLockQueued;
    }

    public boolean isForRefresh() {
        return this.isForRefresh;
    }

    public void setForRefresh(boolean isforRefresh) {
        this.isForRefresh = isforRefresh;
    }

    public boolean isTransitionedToDeferredLocks() {
        return this.isTransitionedToDeferredLocks;
    }

    public Object mergeChanges(Object object, ObjectChangeSet objectChangeSet, AbstractSession targetSession) throws ValidationException {
        Object mergedObject;
        if (object == null) {
            return object;
        }
        if (this.session.isClassReadOnly(object.getClass())) {
            return object;
        }
        if (this.isAlreadyMerged(object, targetSession)) {
            return object;
        }
        this.recordMerge(object, object, targetSession);
        if (this.shouldMergeWorkingCopyIntoOriginal()) {
            mergedObject = this.mergeChangesOfWorkingCopyIntoOriginal(object, objectChangeSet);
        } else if (this.shouldMergeChangesIntoDistributedCache()) {
            mergedObject = this.mergeChangesIntoDistributedCache(object, objectChangeSet);
        } else if (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
            mergedObject = this.mergeChangesOfCloneIntoWorkingCopy(object);
        } else if (this.shouldMergeOriginalIntoWorkingCopy()) {
            mergedObject = this.mergeChangesOfOriginalIntoWorkingCopy(object);
        } else if (this.shouldMergeWorkingCopyIntoRemote()) {
            mergedObject = this.mergeChangesOfWorkingCopyIntoRemote(object);
        } else if (this.shouldRefreshRemoteObject()) {
            mergedObject = this.mergeChangesForRefreshingRemoteObject(object);
        } else {
            throw ValidationException.invalidMergePolicy();
        }
        return mergedObject;
    }

    public void recordMerge(Object key, Object value, AbstractSession targetSession) {
        Map<Object, Object> sessionMap = this.objectsAlreadyMerged.get(targetSession);
        if (sessionMap == null) {
            sessionMap = new IdentityHashMap<Object, Object>();
            this.objectsAlreadyMerged.put(targetSession, sessionMap);
        }
        sessionMap.put(key, value);
    }

    public boolean isAlreadyMerged(Object object, AbstractSession targetSession) {
        Map<Object, Object> sessionMap = this.objectsAlreadyMerged.get(targetSession);
        if (sessionMap == null) {
            return false;
        }
        return sessionMap.containsKey(object);
    }

    public Object getMergedObject(Object key, AbstractSession targetSession) {
        Map<Object, Object> sessionMap = this.objectsAlreadyMerged.get(targetSession);
        if (sessionMap == null) {
            return null;
        }
        return sessionMap.get(key);
    }

    protected Object mergeChangesForRefreshingRemoteObject(Object serverSideDomainObject) {
        ClassDescriptor descriptor = this.session.getDescriptor(serverSideDomainObject);
        Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(serverSideDomainObject, this.session);
        Object clientSideDomainObject = this.session.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, serverSideDomainObject.getClass(), descriptor);
        if (clientSideDomainObject == null) {
            ObjectDescriptor objectDescriptor = this.getObjectDescriptors().get(serverSideDomainObject);
            if (objectDescriptor == null) {
                objectDescriptor = new ObjectDescriptor();
                objectDescriptor.setKey(primaryKey);
                objectDescriptor.setObject(serverSideDomainObject);
                OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
                if (policy == null) {
                    objectDescriptor.setWriteLockValue(null);
                } else {
                    objectDescriptor.setWriteLockValue(policy.getBaseValue());
                }
            }
            ReadObjectQuery query = new ReadObjectQuery();
            query.setCascadePolicy(this.getCascadePolicy());
            this.session.getIdentityMapAccessorInstance().putInIdentityMap(serverSideDomainObject, primaryKey, objectDescriptor.getWriteLockValue(), objectDescriptor.getReadTime(), descriptor);
            descriptor.getObjectBuilder().fixObjectReferences(serverSideDomainObject, this.getObjectDescriptors(), this.objectsAlreadyMerged.get(this.session), query, (DistributedSession)this.session);
            clientSideDomainObject = serverSideDomainObject;
        } else {
            CacheKey key;
            descriptor.getObjectBuilder().mergeIntoObject(clientSideDomainObject, false, serverSideDomainObject, this, this.getSession());
            ObjectDescriptor objectDescriptor = this.getObjectDescriptors().get(serverSideDomainObject);
            if (objectDescriptor == null) {
                objectDescriptor = new ObjectDescriptor();
                objectDescriptor.setKey(primaryKey);
                objectDescriptor.setObject(serverSideDomainObject);
                OptimisticLockingPolicy policy = descriptor.getOptimisticLockingPolicy();
                if (policy == null) {
                    objectDescriptor.setWriteLockValue(null);
                } else {
                    objectDescriptor.setWriteLockValue(policy.getBaseValue());
                }
            }
            if ((key = this.session.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKey, clientSideDomainObject.getClass(), descriptor)) != null) {
                key.setReadTime(objectDescriptor.getReadTime());
            }
            if (descriptor.usesOptimisticLocking()) {
                this.session.getIdentityMapAccessor().updateWriteLockValue(primaryKey, clientSideDomainObject.getClass(), objectDescriptor.getWriteLockValue());
            }
        }
        return clientSideDomainObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesFromChangeSet(UnitOfWorkChangeSet uowChangeSet) {
        this.session.startOperationProfile("Timer:DistributedMerge");
        try {
            this.session.getIdentityMapAccessorInstance().acquireWriteLock();
            this.session.log(2, "propagation", "received_updates_from_remote_server");
            if (this.session.hasEventManager()) {
                this.session.getEventManager().preDistributedMergeUnitOfWorkChangeSet(uowChangeSet);
            }
            this.session.getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this, uowChangeSet);
            Iterator<ObjectChangeSet> objectChangeEnum = uowChangeSet.getAllChangeSets().keySet().iterator();
            HashSet classesChanged = new HashSet();
            while (objectChangeEnum.hasNext()) {
                ObjectChangeSet objectChangeSet = objectChangeEnum.next();
                Object object = objectChangeSet.getTargetVersionOfSourceObject(this, this.session, false);
                if (object != null) {
                    this.mergeChanges(object, objectChangeSet, this.session);
                    this.session.incrementProfile("Counter:ChangesProcessed");
                } else if (objectChangeSet.isNew()) {
                    this.mergeNewObjectIntoCache(objectChangeSet);
                    this.session.incrementProfile("Counter:ChangesProcessed");
                } else {
                    this.session.incrementProfile("Counter:ChangesNotProcessed");
                }
                classesChanged.add(objectChangeSet.getClassType(this.session));
            }
            if (uowChangeSet.hasDeletedObjects()) {
                for (ObjectChangeSet objectChangeSet : uowChangeSet.getDeletedObjects().values()) {
                    objectChangeSet.removeFromIdentityMap(this.session);
                    classesChanged.add(objectChangeSet.getClassType(this.session));
                }
            }
            for (Class clazz : classesChanged) {
                this.session.getIdentityMapAccessorInstance().invalidateQueryCache(clazz);
            }
        }
        catch (RuntimeException exception) {
            this.session.handleException(exception);
        }
        finally {
            this.session.getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this);
            this.session.getIdentityMapAccessorInstance().releaseWriteLock();
            this.session.endOperationProfile("Timer:DistributedMerge");
            if (this.session.hasEventManager()) {
                this.session.getEventManager().postDistributedMergeUnitOfWorkChangeSet(uowChangeSet);
            }
        }
    }

    protected Object mergeChangesIntoDistributedCache(Object original, ObjectChangeSet changeSet) {
        AbstractSession session = this.session;
        Class<?> localClassType = changeSet.getClassType(session);
        CoreDescriptor descriptor = session.getDescriptor((Class)localClassType);
        if (changeSet.getSynchronizationType() == 2) {
            session.getIdentityMapAccessorInstance().invalidateObject(changeSet.getId(), localClassType);
            return original;
        }
        if (!changeSet.isNew() && ((ClassDescriptor)descriptor).usesVersionLocking()) {
            int difference;
            if (session.getCommandManager() != null && session.getCommandManager().getCommandConverter() != null) {
                changeSet.rebuildWriteLockValueFromUserFormat((ClassDescriptor)descriptor, session);
            }
            if ((difference = ((ClassDescriptor)descriptor).getOptimisticLockingPolicy().getVersionDifference(changeSet.getInitialWriteLockValue(), original, changeSet.getId(), session)) < 0) {
                session.log(1, "propagation", "change_from_remote_server_older_than_current_version", changeSet.getClassName(), changeSet.getId());
                return original;
            }
            if (difference > 0) {
                session.log(1, "propagation", "current_version_much_older_than_change_from_remote_server", changeSet.getClassName(), changeSet.getId());
                session.getIdentityMapAccessorInstance().invalidateObject(changeSet.getId(), localClassType);
                return original;
            }
        }
        session.log(1, "propagation", "Merging_from_remote_server", changeSet.getClassName(), changeSet.getId());
        if (changeSet.isNew() || changeSet.getSynchronizationType() != 4) {
            Object primaryKey = changeSet.getId();
            CacheKey cacheKey = changeSet.getActiveCacheKey();
            if (cacheKey == null || !cacheKey.isAcquired()) {
                cacheKey = session.getIdentityMapAccessorInstance().getWriteLockManager().appendLock(primaryKey, original, (ClassDescriptor)descriptor, this, session);
            }
            ((ClassDescriptor)descriptor).getObjectBuilder().mergeChangesIntoObject(original, changeSet, null, this, session, false, false);
            if (((ClassDescriptor)descriptor).usesOptimisticLocking() && ((ClassDescriptor)descriptor).getOptimisticLockingPolicy().isStoredInCache()) {
                cacheKey.setWriteLockValue(changeSet.getWriteLockValue());
            }
            if (((ClassDescriptor)descriptor).isProtectedIsolation() && changeSet.hasProtectedForeignKeys()) {
                ((ClassDescriptor)descriptor).getObjectBuilder().cacheForeignKeyValues(changeSet.getProtectedForeignKeys(), cacheKey, session);
            }
            cacheKey.setObject(original);
            if (((ClassDescriptor)descriptor).getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate() || changeSet.isNew()) {
                cacheKey.setReadTime(this.getSystemTime());
            }
            cacheKey.updateAccess();
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfCloneIntoWorkingCopy(Object rmiClone) {
        Object registeredObject = null;
        if (this.isForRefresh) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.session;
            CoreDescriptor descriptor = unitOfWork.getDescriptor((Class)rmiClone.getClass());
            Object primaryKey = ((ClassDescriptor)descriptor).getObjectBuilder().extractPrimaryKeyFromObject(rmiClone, unitOfWork, true);
            if (primaryKey != null) {
                registeredObject = unitOfWork.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, null, ((ClassDescriptor)descriptor).getJavaClass(), false, (ClassDescriptor)descriptor);
            }
            if (registeredObject == null) {
                return unitOfWork.internalRegisterObject(rmiClone, (ClassDescriptor)descriptor, false);
            }
        } else {
            registeredObject = this.registerObjectForMergeCloneIntoWorkingCopy(rmiClone, this.shouldForceCascade());
        }
        if ((registeredObject == rmiClone || this.isAlreadyMerged(registeredObject, this.session)) && !this.shouldForceCascade()) {
            return registeredObject;
        }
        this.recordMerge(registeredObject, registeredObject, this.session);
        ClassDescriptor descriptor = this.session.getDescriptor(rmiClone);
        try {
            Object currentValue;
            VersionLockingPolicy policy;
            ObjectBuilder builder = descriptor.getObjectBuilder();
            if (!this.isForRefresh && registeredObject != rmiClone && descriptor.usesVersionLocking() && !this.mergedNewObjects.containsKey(registeredObject) && (policy = (VersionLockingPolicy)descriptor.getOptimisticLockingPolicy()).isStoredInObject() && policy.isNewerVersion(currentValue = builder.extractValueFromObjectForField(registeredObject, policy.getWriteLockField(), this.session), rmiClone, this.session.keyFromObject(rmiClone, descriptor), this.session)) {
                throw OptimisticLockException.objectChangedSinceLastMerge(rmiClone);
            }
            descriptor.getObjectChangePolicy().dissableEventProcessing(registeredObject);
            boolean cascadeOnly = false;
            if (registeredObject == rmiClone || this.mergedNewObjects.containsKey(registeredObject)) {
                cascadeOnly = true;
            }
            builder.mergeIntoObject(registeredObject, null, false, rmiClone, this, this.session, cascadeOnly, false, false);
            if (this.isForRefresh) {
                Object primaryKey = builder.extractPrimaryKeyFromObject(registeredObject, this.session);
                descriptor.getObjectChangePolicy().revertChanges(registeredObject, descriptor, (UnitOfWorkImpl)this.session, ((UnitOfWorkImpl)this.session).getCloneMapping(), true);
                CacheKey uowCacheKey = this.session.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKey, registeredObject.getClass(), descriptor);
                CacheKey parentCacheKey = this.session.getParentIdentityMapSession(descriptor, false, false).getIdentityMapAccessorInstance().getCacheKeyForObject(primaryKey, registeredObject.getClass(), descriptor, false);
                if (descriptor.usesOptimisticLocking()) {
                    descriptor.getOptimisticLockingPolicy().mergeIntoParentCache(uowCacheKey, parentCacheKey);
                }
                if (parentCacheKey != null && uowCacheKey != null) {
                    uowCacheKey.setReadTime(parentCacheKey.getReadTime());
                }
            }
        }
        finally {
            descriptor.getObjectChangePolicy().enableEventProcessing(registeredObject);
        }
        return registeredObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object mergeChangesOfOriginalIntoWorkingCopy(Object clone) {
        ClassDescriptor descriptor = this.session.getDescriptor(clone);
        Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone, this.session, true);
        CacheKey parentCacheKey = null;
        if (primaryKey != null) {
            parentCacheKey = this.session.getParentIdentityMapSession(descriptor, false, false).getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKey, clone.getClass(), descriptor);
        }
        Object original = null;
        if (parentCacheKey != null) {
            original = parentCacheKey.getObject();
        } else {
            if (descriptor.getCachePolicy().isProtectedIsolation() && descriptor.hasNoncacheableMappings()) {
                this.session.refreshObject(clone);
                return clone;
            }
            original = ((UnitOfWorkImpl)this.session).getOriginalVersionOfObjectOrNull(clone, descriptor);
        }
        if (original == null) {
            return clone;
        }
        descriptor.getObjectChangePolicy().dissableEventProcessing(clone);
        try {
            descriptor.getObjectBuilder().mergeIntoObject(clone, false, original, this, this.session);
        }
        finally {
            descriptor.getObjectChangePolicy().enableEventProcessing(clone);
        }
        descriptor.getObjectChangePolicy().revertChanges(clone, descriptor, (UnitOfWorkImpl)this.session, ((UnitOfWorkImpl)this.session).getCloneMapping(), true);
        if (primaryKey == null) {
            return clone;
        }
        if (descriptor.usesOptimisticLocking()) {
            descriptor.getOptimisticLockingPolicy().mergeIntoParentCache((UnitOfWorkImpl)this.session, primaryKey, clone);
        }
        CacheKey uowCacheKey = this.session.getIdentityMapAccessorInstance().getCacheKeyForObjectForLock(primaryKey, clone.getClass(), descriptor);
        if (parentCacheKey != null && uowCacheKey != null) {
            uowCacheKey.setReadTime(parentCacheKey.getReadTime());
        }
        return clone;
    }

    protected Object mergeChangesOfWorkingCopyIntoOriginal(Object clone, ObjectChangeSet objectChangeSet) {
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.session;
        AbstractSession parent = unitOfWork.getParent();
        if (!unitOfWork.isNestedUnitOfWork() && unitOfWork.isObjectDeleted(clone)) {
            return clone;
        }
        CoreDescriptor descriptor = unitOfWork.getDescriptor((Class)clone.getClass());
        boolean requiresToRegisterInParent = false;
        Object originalNewObject = null;
        if (unitOfWork.isNestedUnitOfWork() && (originalNewObject = unitOfWork.getOriginalVersionOfNewObject(clone)) != null && !((UnitOfWorkImpl)parent).isCloneNewObject(originalNewObject) && !unitOfWork.isUnregisteredNewObjectInParent(originalNewObject)) {
            requiresToRegisterInParent = true;
        }
        AbstractSession parentSession = unitOfWork.getParentIdentityMapSession((ClassDescriptor)descriptor, false, false);
        CacheKey cacheKey = this.mergeChangesOfWorkingCopyIntoOriginal(clone, objectChangeSet, (ClassDescriptor)descriptor, parentSession, unitOfWork);
        AbstractSession sharedSession = parentSession;
        if (((ClassDescriptor)descriptor).getCachePolicy().isProtectedIsolation()) {
            if (parentSession.isIsolatedClientSession()) {
                sharedSession = parentSession.getParent();
                cacheKey = this.mergeChangesOfWorkingCopyIntoOriginal(clone, objectChangeSet, (ClassDescriptor)descriptor, sharedSession, unitOfWork);
            }
            if (!sharedSession.isProtectedSession()) {
                ((ClassDescriptor)descriptor).getObjectBuilder().cacheForeignKeyValues(clone, cacheKey, (ClassDescriptor)descriptor, sharedSession);
            }
        }
        if (requiresToRegisterInParent) {
            Object backupClone = ((ClassDescriptor)descriptor).getObjectBuilder().buildNewInstance();
            Object newInstance = ((ClassDescriptor)descriptor).getObjectBuilder().buildNewInstance();
            ((UnitOfWorkImpl)parent).registerOriginalNewObjectFromNestedUnitOfWork(originalNewObject, backupClone, newInstance, (ClassDescriptor)descriptor);
        }
        return clone;
    }

    protected CacheKey mergeChangesOfWorkingCopyIntoOriginal(Object clone, ObjectChangeSet objectChangeSet, ClassDescriptor descriptor, AbstractSession targetSession, UnitOfWorkImpl unitOfWork) {
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object original = null;
        CacheKey cacheKey = null;
        if (!(targetSession.isClientSession() && descriptor.getCachePolicy().isProtectedIsolation() || objectChangeSet == null || (cacheKey = objectChangeSet.getActiveCacheKey()) == null)) {
            original = cacheKey.getObject();
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(clone, unitOfWork);
        if (cacheKey == null && (cacheKey = targetSession.getCacheKeyFromTargetSessionForMerge(implementation, builder, descriptor, this)) != null) {
            original = cacheKey.getObject();
        }
        if (original == null && (original = unitOfWork.getOriginalVersionOfObjectOrNull(clone, objectChangeSet, descriptor, targetSession)) != null) {
            if (cacheKey == null) {
                cacheKey = targetSession.getIdentityMapAccessorInstance().getWriteLockManager().appendLock(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone, targetSession), original, descriptor, this, targetSession);
            } else if (cacheKey.getObject() != null) {
                original = cacheKey.getObject();
            } else {
                cacheKey.setObject(original);
            }
        }
        try {
            if (original == null) {
                original = unitOfWork.buildOriginal(clone);
                if (objectChangeSet == null) {
                    cacheKey = targetSession.getIdentityMapAccessorInstance().getWriteLockManager().appendLock(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone, targetSession), original, descriptor, this, targetSession);
                    if (cacheKey.getObject() != null) {
                        original = cacheKey.getObject();
                    } else {
                        cacheKey.setObject(original);
                    }
                    objectBuilder.mergeIntoObject(original, null, true, clone, this, targetSession, false, !descriptor.getCopyPolicy().buildsNewInstance(), true);
                    if (!unitOfWork.isObjectRegistered(clone)) {
                        cacheKey.setInvalidationState(-1);
                    }
                } else {
                    if (cacheKey == null) {
                        cacheKey = targetSession.getIdentityMapAccessorInstance().getWriteLockManager().appendLock(objectChangeSet.getId(), original, descriptor, this, targetSession);
                    }
                    if (cacheKey.getObject() != null) {
                        original = cacheKey.getObject();
                    } else {
                        cacheKey.setObject(original);
                    }
                    if (!objectChangeSet.isNew()) {
                        objectBuilder.mergeIntoObject(original, objectChangeSet, true, clone, this, targetSession, false, !descriptor.getCopyPolicy().buildsNewInstance(), true);
                        if (!unitOfWork.isObjectRegistered(clone)) {
                            cacheKey.setInvalidationState(-1);
                        }
                    } else {
                        objectBuilder.mergeChangesIntoObject(original, objectChangeSet, clone, this, targetSession, !descriptor.getCopyPolicy().buildsNewInstance(), true);
                    }
                }
                if (original instanceof PersistenceEntity) {
                    Object pk = cacheKey.getKey();
                    objectBuilder.updateCachedAttributes((PersistenceEntity)original, cacheKey, pk);
                }
                this.updateCacheKeyProperties(unitOfWork, cacheKey, original, clone, objectChangeSet, descriptor);
            } else if (objectChangeSet != null) {
                if (descriptor.getFullyMergeEntity() && objectChangeSet.hasChanges()) {
                    objectBuilder.mergeIntoObject(original, objectChangeSet, false, clone, this, targetSession, false, false, true);
                } else if (objectChangeSet.hasChanges()) {
                    if (!objectChangeSet.isNew()) {
                        if (objectChangeSet.shouldInvalidateObject(original, targetSession) && !unitOfWork.isNestedUnitOfWork()) {
                            targetSession.getIdentityMapAccessor().invalidateObject(original);
                        }
                    } else if (original instanceof PersistenceEntity) {
                        Object pk = null;
                        pk = cacheKey == null ? descriptor.getObjectBuilder().extractPrimaryKeyFromObject(original, unitOfWork) : cacheKey.getKey();
                        objectBuilder.updateCachedAttributes((PersistenceEntity)original, cacheKey, pk);
                    }
                    objectBuilder.mergeChangesIntoObject(original, objectChangeSet, clone, this, targetSession, false, objectChangeSet.isNew());
                    this.updateCacheKeyProperties(unitOfWork, cacheKey, original, clone, objectChangeSet, descriptor);
                }
            }
        }
        catch (QueryException exception) {
            if (unitOfWork.shouldPerformNoValidation() || descriptor.hasWrapperPolicy()) {
                if (exception.getErrorCode() != 6066 && exception.getErrorCode() != 6004 && exception.getErrorCode() != 6005) {
                    throw exception;
                }
                return cacheKey;
            }
            throw exception;
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object mergeChangesOfWorkingCopyIntoRemote(Object clone) throws ValidationException {
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.session;
        Object original = unitOfWork.getOriginalVersionOfObject(clone);
        ClassDescriptor descriptor = unitOfWork.getDescriptor(clone);
        descriptor.getObjectChangePolicy().dissableEventProcessing(original);
        try {
            descriptor.getObjectBuilder().mergeIntoObject(original, false, clone, this, this.session);
        }
        finally {
            descriptor.getObjectChangePolicy().enableEventProcessing(original);
        }
        if (((RemoteUnitOfWork)unitOfWork.getParent()).getUnregisteredNewObjectsCache().contains(original)) {
            Object backupClone = descriptor.getObjectBuilder().buildNewInstance();
            Object newInstance = descriptor.getObjectBuilder().buildNewInstance();
            ((UnitOfWorkImpl)unitOfWork.getParent()).registerOriginalNewObjectFromNestedUnitOfWork(original, backupClone, newInstance, descriptor);
        }
        Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(clone, unitOfWork);
        CacheKey cacheKey = unitOfWork.getParent().getIdentityMapAccessorInstance().acquireLock(primaryKey, original.getClass(), descriptor, false);
        try {
            if (descriptor.usesOptimisticLocking()) {
                cacheKey.setObject(original);
                cacheKey.setWriteLockValue(unitOfWork.getIdentityMapAccessor().getWriteLockValue(original));
            } else {
                cacheKey.setObject(original);
            }
        }
        finally {
            cacheKey.updateAccess();
            cacheKey.release();
        }
        return clone;
    }

    public void mergeCloneIntoWorkingCopy() {
        this.setMergePolicy(3);
    }

    public void mergeCloneWithReferencesIntoWorkingCopy() {
        this.setMergePolicy(7);
    }

    public void mergeIntoDistributedCache() {
        this.setMergePolicy(6);
    }

    public Object mergeNewObjectIntoCache(ObjectChangeSet changeSet) {
        Class<?> localClassType = changeSet.getClassType(this.session);
        CoreDescriptor descriptor = this.session.getDescriptor((Class)localClassType);
        Object newObject = null;
        if (!this.isAlreadyMerged(changeSet, this.session)) {
            newObject = ((ClassDescriptor)descriptor).getObjectBuilder().buildNewInstance();
            this.recordMerge(changeSet, newObject, this.session);
        } else {
            newObject = this.objectsAlreadyMerged.get(this.session).get(changeSet);
        }
        this.mergeChanges(newObject, changeSet, this.session);
        return newObject;
    }

    public void mergeOriginalIntoWorkingCopy() {
        this.setMergePolicy(2);
    }

    public void mergeWorkingCopyIntoOriginal() {
        this.setMergePolicy(1);
    }

    public void mergeWorkingCopyIntoRemote() {
        this.setMergePolicy(4);
    }

    public void refreshRemoteObject() {
        this.setMergePolicy(5);
    }

    protected Object registerObjectForMergeCloneIntoWorkingCopy(Object clone, boolean shouldForceCascade) {
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.session;
        CoreDescriptor descriptor = unitOfWork.getDescriptor((Class)clone.getClass());
        Object primaryKey = ((ClassDescriptor)descriptor).getObjectBuilder().extractPrimaryKeyFromObject(clone, unitOfWork, true);
        Object objectFromCache = null;
        if (primaryKey != null) {
            objectFromCache = unitOfWork.getIdentityMapAccessorInstance().getFromIdentityMap(primaryKey, null, ((ClassDescriptor)descriptor).getJavaClass(), false, (ClassDescriptor)descriptor);
        }
        if (objectFromCache == null) {
            objectFromCache = unitOfWork.checkIfAlreadyRegistered(clone, (ClassDescriptor)descriptor);
        }
        if (objectFromCache != null) {
            if (!this.isForRefresh && unitOfWork.isObjectDeleted(objectFromCache) && (this.shouldMergeCloneIntoWorkingCopy() || this.shouldMergeCloneWithReferencesIntoWorkingCopy())) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_merge_removed_entity", new Object[]{clone}));
            }
            return objectFromCache;
        }
        DoesExistQuery existQuery = ((ClassDescriptor)descriptor).getQueryManager().getDoesExistQuery();
        if (existQuery.shouldCheckCacheForDoesExist()) {
            this.checkNewObjectLockVersion(clone, primaryKey, (ClassDescriptor)descriptor, unitOfWork);
            Object registeredObject = unitOfWork.internalRegisterObject(clone, (ClassDescriptor)descriptor, false);
            if (unitOfWork.hasNewObjects() && unitOfWork.getNewObjectsOriginalToClone().containsKey(clone)) {
                this.mergedNewObjects.put(registeredObject, registeredObject);
            }
            return registeredObject;
        }
        Boolean doesExist = Boolean.FALSE;
        if (primaryKey != null) {
            doesExist = (Boolean)existQuery.checkEarlyReturn(clone, primaryKey, unitOfWork, null);
        }
        if (doesExist == Boolean.FALSE) {
            this.checkNewObjectLockVersion(clone, primaryKey, (ClassDescriptor)descriptor, unitOfWork);
            Object registeredObject = unitOfWork.internalRegisterObject(clone, (ClassDescriptor)descriptor, shouldForceCascade);
            this.mergedNewObjects.put(registeredObject, registeredObject);
            return registeredObject;
        }
        Object object = unitOfWork.readObject(clone);
        if (object == null) {
            this.checkNewObjectLockVersion(clone, primaryKey, (ClassDescriptor)descriptor, unitOfWork);
            object = unitOfWork.cloneAndRegisterNewObject(clone, shouldForceCascade);
            this.mergedNewObjects.put(object, object);
        }
        return object;
    }

    public void checkNewObjectLockVersion(Object clone, Object primaryKey, ClassDescriptor descriptor, UnitOfWorkImpl unitOfWork) {
        if (descriptor.usesVersionLocking()) {
            VersionLockingPolicy policy = (VersionLockingPolicy)descriptor.getOptimisticLockingPolicy();
            Object baseValue = policy.getBaseValue();
            Object objectLockValue = policy.getWriteLockValue(clone, primaryKey, unitOfWork);
            if (policy.isNewerVersion(objectLockValue, baseValue)) {
                throw OptimisticLockException.objectChangedSinceLastMerge(clone);
            }
        }
    }

    public void registerRemovedNewObjectIfRequired(Object removedObject) {
        if (this.session.isUnitOfWork()) {
            UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.session;
            if (this.shouldMergeWorkingCopyIntoOriginal() && unitOfWork.getParent().isUnitOfWork() && unitOfWork.isCloneNewObject(removedObject)) {
                Object originalVersionOfRemovedObject = unitOfWork.getOriginalVersionOfObject(removedObject);
                unitOfWork.addRemovedObject(originalVersionOfRemovedObject);
            }
        }
    }

    public void setCascadePolicy(int cascadePolicy) {
        this.cascadePolicy = cascadePolicy;
    }

    protected void setMergePolicy(int mergePolicy) {
        this.mergePolicy = mergePolicy;
    }

    public void setForceCascade(boolean forceCascade) {
        this.forceCascade = forceCascade;
    }

    public void setObjectDescriptors(Map<Object, ObjectDescriptor> objectDescriptors) {
        this.objectDescriptors = objectDescriptors;
    }

    protected void setObjectsAlreadyMerged(Map<AbstractSession, Map<Object, Object>> objectsAlreadyMerged) {
        this.objectsAlreadyMerged = objectsAlreadyMerged;
    }

    public void setQueueNode(LinkedNode<MergeManager> node) {
        this.queueNode = node;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    public void setWriteLockQueued(Object primaryKey) {
        this.writeLockQueued = primaryKey;
    }

    public boolean shouldCascadeByMapping() {
        return this.getCascadePolicy() == 4;
    }

    public boolean shouldCascadeAllParts() {
        return this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeParts() {
        return this.getCascadePolicy() != 1;
    }

    public boolean shouldCascadePrivateParts() {
        return this.getCascadePolicy() == 2 || this.getCascadePolicy() == 3;
    }

    public boolean shouldCascadeReferences() {
        return !this.shouldMergeCloneIntoWorkingCopy() || this.isForRefresh;
    }

    public boolean shouldMergeChangesIntoDistributedCache() {
        return this.getMergePolicy() == 6;
    }

    public boolean shouldMergeCloneIntoWorkingCopy() {
        return this.getMergePolicy() == 3;
    }

    public boolean shouldMergeCloneWithReferencesIntoWorkingCopy() {
        return this.getMergePolicy() == 7;
    }

    public boolean shouldMergeOriginalIntoWorkingCopy() {
        return this.getMergePolicy() == 2;
    }

    public boolean shouldMergeWorkingCopyIntoOriginal() {
        return this.getMergePolicy() == 1;
    }

    public boolean shouldMergeWorkingCopyIntoRemote() {
        return this.getMergePolicy() == 4;
    }

    public boolean shouldRefreshRemoteObject() {
        return this.getMergePolicy() == 5;
    }

    public boolean shouldForceCascade() {
        return this.forceCascade;
    }

    public IdentityHashMap<Object, Object> getMergedNewObjects() {
        return this.mergedNewObjects;
    }

    public void transitionToDeferredLocks() {
        this.isTransitionedToDeferredLocks = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheKeyProperties(UnitOfWorkImpl unitOfWork, CacheKey cacheKey, Object original, Object clone, ObjectChangeSet objectChangeSet, ClassDescriptor descriptor) {
        if (!unitOfWork.isNestedUnitOfWork()) {
            boolean locked = false;
            if (cacheKey == null || !cacheKey.isAcquired()) {
                Object primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(original, unitOfWork);
                cacheKey = unitOfWork.getParent().getIdentityMapAccessorInstance().acquireLockNoWait(primaryKey, original.getClass(), false, descriptor);
                boolean bl = locked = cacheKey != null;
            }
            if (cacheKey != null) {
                try {
                    if (descriptor.usesOptimisticLocking() && descriptor.getOptimisticLockingPolicy().isStoredInCache()) {
                        cacheKey.setWriteLockValue(unitOfWork.getIdentityMapAccessor().getWriteLockValue(clone));
                    }
                    cacheKey.setObject(original);
                    if (descriptor.getCacheInvalidationPolicy().shouldUpdateReadTimeOnUpdate() || objectChangeSet != null && objectChangeSet.isNew()) {
                        cacheKey.setReadTime(this.getSystemTime());
                    }
                    cacheKey.updateAccess();
                }
                finally {
                    if (locked) {
                        cacheKey.release();
                    }
                }
            }
        }
    }

    public Thread getLockThread() {
        return this.lockThread;
    }

    public void setLockThread(Thread lockThread) {
        this.lockThread = lockThread;
    }
}

