/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.ConvertExpression;
import org.glassfish.rmic.tools.tree.Expression;

public class Node
implements Constants,
Cloneable {
    int op;
    long where;

    Node(int op, long where) {
        this.op = op;
        this.where = where;
    }

    public int getOp() {
        return this.op;
    }

    public long getWhere() {
        return this.where;
    }

    public Expression convert(Environment env, Context ctx, Type t, Expression e) {
        if (e.type.isType(13) || t.isType(13)) {
            return e;
        }
        if (e.type.equals(t)) {
            return e;
        }
        try {
            if (e.fitsType(env, ctx, t)) {
                return new ConvertExpression(this.where, t, e);
            }
            if (env.explicitCast(e.type, t)) {
                env.error(this.where, "explicit.cast.needed", opNames[this.op], e.type, t);
                return new ConvertExpression(this.where, t, e);
            }
        }
        catch (ClassNotFound ee) {
            env.error(this.where, "class.not.found", ee.name, opNames[this.op]);
        }
        env.error(this.where, "incompatible.type", opNames[this.op], e.type, t);
        return new ConvertExpression(this.where, Type.tError, e);
    }

    public void print(PrintStream out) {
        throw new CompilerError("print");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (InternalError)new InternalError().initCause(e);
        }
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.print(new PrintStream(bos));
        return bos.toString();
    }
}

