/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class TransactionException
extends EclipseLinkException {
    public static final int ERROR_DOING_JNDI_LOOKUP = 23001;
    public static final int ERROR_GETTING_TRANSACTION_STATUS = 23002;
    public static final int ERROR_GETTING_TRANSACTION = 23003;
    public static final int ERROR_OBTAINING_TRANSACTION_MANAGER = 23004;
    public static final int ERROR_BINDING_TO_TRANSACTION = 23005;
    public static final int ERROR_BEGINNING_TRANSACTION = 23006;
    public static final int ERROR_COMMITTING_TRANSACTION = 23007;
    public static final int ERROR_ROLLING_BACK_TRANSACTION = 23008;
    public static final int ERROR_MARKING_TRANSACTION_FOR_ROLLBACK = 23009;
    public static final int ERROR_NO_EXTERNAL_TRANSACTION_ACTIVE = 23010;
    public static final int ERROR_INACTIVE_UOW = 23011;
    public static final int ERROR_NO_TRANSACTION_ACTIVE = 23012;
    public static final int ERROR_TRANSACTION_IS_ACTIVE = 23013;
    public static final int ENTITY_TRANSACTION_WITH_JTA_NOT_ALLOWED = 23014;
    public static final int CANNOT_ENLIST_MULTIPLE_DATASOURCES = 23015;
    public static final int EXCEPTION_IN_PROXY_EXECUTION = 23016;
    public static final int ERROR_NO_ENTITY_TRANSACTION_ACTIVE = 23017;
    public static final int ERROR_OBTAINING_TSR = 23018;

    public TransactionException(String message) {
        super(message);
    }

    public TransactionException(String message, Exception internalException) {
        super(message, internalException);
    }

    public static TransactionException jndiLookupException(String jndiName, Exception internalException) {
        Object[] args = new Object[]{jndiName};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23001, args));
        ex.setErrorCode(23001);
        ex.setInternalException(internalException);
        return ex;
    }

    public static TransactionException errorGettingExternalTransactionStatus(Exception internalException) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23002, args));
        ex.setErrorCode(23002);
        ex.setInternalException(internalException);
        return ex;
    }

    public static TransactionException errorGettingExternalTransaction(Exception internalException) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23003, args));
        ex.setErrorCode(23003);
        ex.setInternalException(internalException);
        return ex;
    }

    public static TransactionException errorBindingToExternalTransaction(Exception internalException) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23005, args));
        ex.setErrorCode(23005);
        ex.setInternalException(internalException);
        return ex;
    }

    public static TransactionException errorBeginningExternalTransaction(Exception internalException) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23006, args));
        ex.setErrorCode(23006);
        ex.setInternalException(internalException);
        return ex;
    }

    public static TransactionException errorCommittingExternalTransaction(Exception internalException) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23007, args));
        ex.setErrorCode(23007);
        ex.setInternalException(internalException);
        return ex;
    }

    public static TransactionException errorRollingBackExternalTransaction(Exception internalException) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23008, args));
        ex.setErrorCode(23008);
        ex.setInternalException(internalException);
        return ex;
    }

    public static TransactionException errorMarkingTransactionForRollback(Exception internalException) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23009, args));
        ex.setErrorCode(23009);
        ex.setInternalException(internalException);
        return ex;
    }

    public static TransactionException externalTransactionNotActive() {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23010, args));
        ex.setErrorCode(23010);
        return ex;
    }

    public static TransactionException inactiveUnitOfWork(String unitOfWork) {
        Object[] args = new Object[]{unitOfWork};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23011, args));
        ex.setErrorCode(23011);
        return ex;
    }

    public static TransactionException errorObtainingTransactionManager(Exception internalException) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23004, args));
        ex.setErrorCode(23004);
        ex.setInternalException(internalException);
        return ex;
    }

    public static TransactionException transactionNotActive() {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23012, args));
        ex.setErrorCode(23012);
        return ex;
    }

    public static TransactionException transactionIsActive() {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23013, args));
        ex.setErrorCode(23013);
        return ex;
    }

    public static TransactionException entityTransactionWithJTANotAllowed() {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23014, args));
        ex.setErrorCode(23014);
        return ex;
    }

    public static TransactionException multipleResourceException() {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23015, args));
        ex.setErrorCode(23015);
        return ex;
    }

    public static TransactionException internalProxyException(Exception ex1) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23016, args), ex1);
        ex.setErrorCode(23016);
        return ex;
    }

    public static TransactionException entityTransactionNotActive() {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23017, args));
        ex.setErrorCode(23017);
        return ex;
    }

    public static TransactionException errorObtainingTsr(Exception internalException) {
        Object[] args = new Object[]{};
        TransactionException ex = new TransactionException(ExceptionMessageGenerator.buildMessage(TransactionException.class, 23018, args));
        ex.setErrorCode(23018);
        ex.setInternalException(internalException);
        return ex;
    }
}

