/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.constraints.transformer;

import jakarta.servlet.annotation.ServletSecurity;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.glassfish.exousia.constraints.transformer.ConstraintValue;
import org.glassfish.exousia.constraints.transformer.ConstraintsToPermissionsTransformer;
import org.glassfish.exousia.constraints.transformer.MethodValue;

public class PatternBuilder {
    private static final System.Logger LOG = System.getLogger(PatternBuilder.class.getName());
    private final int patternLength;
    private final Map<String, MethodValue> methodValues = new HashMap<String, MethodValue>();
    boolean committed;
    private final ConstraintValue otherConstraint;
    private boolean irrelevantByQualifier;
    private final StringBuilder urlPatternSpec;

    PatternBuilder(String urlPattern) {
        this.patternLength = urlPattern.length();
        this.urlPatternSpec = new StringBuilder(urlPattern);
        this.otherConstraint = new ConstraintValue();
    }

    void addQualifier(String urlPattern) {
        if (ConstraintsToPermissionsTransformer.implies(urlPattern, this.urlPatternSpec.substring(0, this.patternLength))) {
            this.irrelevantByQualifier = true;
        }
        this.urlPatternSpec.append(":" + urlPattern);
    }

    ConstraintValue getOtherConstraint() {
        return this.otherConstraint;
    }

    boolean isIrrelevantByQualifier() {
        return this.irrelevantByQualifier;
    }

    String getUrlPatternSpec() {
        return this.urlPatternSpec.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodValue getMethodValue(int methodIndex) {
        String methodName = MethodValue.getMethodName(methodIndex);
        Map<String, MethodValue> map = this.methodValues;
        synchronized (map) {
            MethodValue methodValue = this.methodValues.get(methodName);
            if (methodValue == null) {
                methodValue = new MethodValue(methodName, this.otherConstraint);
                this.methodValues.put(methodName, methodValue);
                LOG.log(System.Logger.Level.TRACE, "created MethodValue: {0}", methodValue);
            }
            return methodValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getExcludedMethods() {
        BitSet methodSet = new BitSet();
        Map<String, MethodValue> map = this.methodValues;
        synchronized (map) {
            for (MethodValue methodValue : this.methodValues.values()) {
                if (!methodValue.isExcluded()) continue;
                methodSet.set(methodValue.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getNoAuthMethods() {
        BitSet methodSet = new BitSet();
        Map<String, MethodValue> map = this.methodValues;
        synchronized (map) {
            for (MethodValue methodValue : this.methodValues.values()) {
                if (methodValue.isAuthConstrained()) continue;
                methodSet.set(methodValue.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap<String, BitSet> getRoleMap() {
        HashMap<String, BitSet> roleMap = new HashMap<String, BitSet>();
        Map<String, MethodValue> map = this.methodValues;
        synchronized (map) {
            for (MethodValue methodValue : this.methodValues.values()) {
                if (methodValue.isExcluded() || !methodValue.isAuthConstrained()) continue;
                for (String role : methodValue.getRoles()) {
                    roleMap.computeIfAbsent(role, e -> new BitSet()).set(methodValue.index);
                }
            }
        }
        return roleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getConnectMap(int cType) {
        BitSet methodSet = new BitSet();
        Map<String, MethodValue> map = this.methodValues;
        synchronized (map) {
            for (MethodValue methodValue : this.methodValues.values()) {
                if (!methodValue.isConnectAllowed(cType)) continue;
                methodSet.set(methodValue.index);
            }
        }
        return methodSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getMethodSet() {
        BitSet methodSet = new BitSet();
        Map<String, MethodValue> map = this.methodValues;
        synchronized (map) {
            for (MethodValue methodValue : this.methodValues.values()) {
                methodSet.set(methodValue.index);
            }
        }
        return methodSet;
    }

    void setMethodOutcomes(Set<String> roleSet, Set<String> constraintRolesAllowed, ServletSecurity.TransportGuarantee transportGuarantee, BitSet methods, BitSet omittedMethods) {
        this.committed = true;
        if (omittedMethods != null) {
            BitSet methodsInMap = this.getMethodSet();
            BitSet saved = (BitSet)omittedMethods.clone();
            omittedMethods.andNot(methodsInMap);
            int i = omittedMethods.nextSetBit(0);
            while (i >= 0) {
                this.getMethodValue(i);
                i = omittedMethods.nextSetBit(i + 1);
            }
            this.otherConstraint.setOutcome(roleSet, constraintRolesAllowed, transportGuarantee);
            methodsInMap.andNot(saved);
            this.setMethodOutcomes(roleSet, constraintRolesAllowed, transportGuarantee, methodsInMap, null);
        } else {
            int i = methods.nextSetBit(0);
            while (i >= 0) {
                this.getMethodValue(i).setOutcome(roleSet, constraintRolesAllowed, transportGuarantee);
                i = methods.nextSetBit(i + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUncovered(boolean deny) {
        if (!this.committed) {
            return;
        }
        boolean otherIsUncovered = false;
        Map<String, MethodValue> map = this.methodValues;
        synchronized (map) {
            BitSet uncoveredMethodSet = new BitSet();
            for (MethodValue methodValue : this.methodValues.values()) {
                if (!methodValue.isUncovered()) continue;
                if (deny) {
                    methodValue.setPredefinedOutcome(false);
                }
                uncoveredMethodSet.set(methodValue.index);
            }
            if (this.otherConstraint.isUncovered()) {
                otherIsUncovered = true;
                if (deny) {
                    this.otherConstraint.setPredefinedOutcome(false);
                }
                BitSet otherMethodSet = this.getMethodSet();
                if (!uncoveredMethodSet.isEmpty()) {
                    otherMethodSet.andNot(uncoveredMethodSet);
                }
                uncoveredMethodSet = otherMethodSet;
            }
            if (otherIsUncovered || !uncoveredMethodSet.isEmpty()) {
                String uncoveredMethods = MethodValue.getActions(uncoveredMethodSet);
                Object[] args = new Object[]{this.urlPatternSpec, uncoveredMethods};
                if (deny) {
                    if (otherIsUncovered) {
                        LOG.log(System.Logger.Level.INFO, "For the URL pattern {0}, all but the following methods have been excluded: {1}", args);
                    } else {
                        LOG.log(System.Logger.Level.INFO, "For the URL pattern {0}, the following methods have been excluded: {1}", args);
                    }
                } else if (otherIsUncovered) {
                    LOG.log(System.Logger.Level.WARNING, "For the URL pattern {0}, all but the following methods were uncovered: {1}", args);
                } else {
                    LOG.log(System.Logger.Level.WARNING, "For the URL pattern {0}, the following methods were uncovered: {1}", args);
                }
            }
        }
    }
}

