/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.validationcontext;

import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import jakarta.validation.ValidationException;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorInitializationContext;
import org.hibernate.validator.internal.engine.MessageInterpolatorContext;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintViolationCreationContext;
import org.hibernate.validator.internal.engine.path.MutablePath;
import org.hibernate.validator.internal.engine.validationcontext.BaseBeanValidationContext;
import org.hibernate.validator.internal.engine.validationcontext.ValidatorScopedContext;
import org.hibernate.validator.internal.engine.valuecontext.ValueContext;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.messageinterpolation.ExpressionLanguageFeatureLevel;

abstract class AbstractValidationContext<T>
implements BaseBeanValidationContext<T> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final ConstraintValidatorManager constraintValidatorManager;
    private final T rootBean;
    private final Class<T> rootBeanClass;
    private final BeanMetaData<T> rootBeanMetaData;
    private final ConstraintValidatorFactory constraintValidatorFactory;
    protected final ValidatorScopedContext validatorScopedContext;
    private final TraversableResolver traversableResolver;
    private final HibernateConstraintValidatorInitializationContext constraintValidatorInitializationContext;
    private final boolean processedBeanTrackingEnabled;
    private Set<ConstraintViolation<T>> failingConstraintViolations;

    protected AbstractValidationContext(ConstraintValidatorManager constraintValidatorManager, ConstraintValidatorFactory constraintValidatorFactory, ValidatorScopedContext validatorScopedContext, TraversableResolver traversableResolver, HibernateConstraintValidatorInitializationContext constraintValidatorInitializationContext, T rootBean, Class<T> rootBeanClass, BeanMetaData<T> rootBeanMetaData, boolean processedBeanTrackingEnabled) {
        this.constraintValidatorManager = constraintValidatorManager;
        this.validatorScopedContext = validatorScopedContext;
        this.constraintValidatorFactory = constraintValidatorFactory;
        this.traversableResolver = traversableResolver;
        this.constraintValidatorInitializationContext = constraintValidatorInitializationContext;
        this.rootBean = rootBean;
        this.rootBeanClass = rootBeanClass;
        this.rootBeanMetaData = rootBeanMetaData;
        this.processedBeanTrackingEnabled = processedBeanTrackingEnabled;
    }

    @Override
    public T getRootBean() {
        return this.rootBean;
    }

    @Override
    public Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    @Override
    public BeanMetaData<T> getRootBeanMetaData() {
        return this.rootBeanMetaData;
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    @Override
    public boolean isFailFastOnPropertyViolationModeEnabled() {
        return this.validatorScopedContext.isFailFastOnPropertyViolation();
    }

    @Override
    public boolean isFailFastModeEnabled() {
        return this.validatorScopedContext.isFailFast();
    }

    @Override
    public boolean isShowValidatedValuesInTraceLogs() {
        return this.validatorScopedContext.isShowValidatedValuesInTraceLogs();
    }

    @Override
    public ConstraintValidatorManager getConstraintValidatorManager() {
        return this.constraintValidatorManager;
    }

    @Override
    public HibernateConstraintValidatorInitializationContext getConstraintValidatorInitializationContext() {
        return this.constraintValidatorInitializationContext;
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    @Override
    public boolean isBeanAlreadyValidated(Object value, Class<?> group, ValueContext<?, ?> valueContext) {
        if (!this.processedBeanTrackingEnabled) {
            return false;
        }
        return valueContext.isBeanAlreadyValidated(value, group);
    }

    @Override
    public void markCurrentBeanAsProcessed(ValueContext<?, ?> valueContext) {
        if (!this.processedBeanTrackingEnabled) {
            return;
        }
        valueContext.markCurrentGroupAsProcessed();
    }

    @Override
    public Set<ConstraintViolation<T>> getFailingConstraints() {
        if (this.failingConstraintViolations == null) {
            return Collections.emptySet();
        }
        return this.failingConstraintViolations;
    }

    @Override
    public void addConstraintFailure(ValueContext<?, ?> valueContext, ConstraintViolationCreationContext constraintViolationCreationContext, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = constraintViolationCreationContext.getMessage();
        String interpolatedMessage = this.interpolate(messageTemplate, constraintViolationCreationContext.getExpressionLanguageFeatureLevel(), constraintViolationCreationContext.isCustomViolation(), valueContext.getCurrentValidatedValue(), descriptor, constraintViolationCreationContext.getPath(), constraintViolationCreationContext.getMessageParameters(), constraintViolationCreationContext.getExpressionVariables());
        Path path = constraintViolationCreationContext.getPath();
        this.getInitializedFailingConstraintViolations().add(this.createConstraintViolation(messageTemplate, interpolatedMessage, path, descriptor, valueContext, constraintViolationCreationContext));
    }

    protected abstract ConstraintViolation<T> createConstraintViolation(String var1, String var2, Path var3, ConstraintDescriptor<?> var4, ValueContext<?, ?> var5, ConstraintViolationCreationContext var6);

    @Override
    public boolean hasMetaConstraintBeenProcessed(ValueContext<?, ?> valueContext, MetaConstraint<?> metaConstraint) {
        if (metaConstraint.isDefinedForOneGroupOnly()) {
            return false;
        }
        return valueContext.hasMetaConstraintBeenProcessed(metaConstraint);
    }

    @Override
    public void markConstraintProcessed(ValueContext<?, ?> valueContext, MetaConstraint<?> metaConstraint) {
        if (metaConstraint.isDefinedForOneGroupOnly()) {
            return;
        }
        valueContext.markConstraintProcessed(metaConstraint);
    }

    @Override
    public ConstraintValidatorContextImpl createConstraintValidatorContextFor(ConstraintDescriptorImpl<?> constraintDescriptor, MutablePath path) {
        return new ConstraintValidatorContextImpl(this.validatorScopedContext.getClockProvider(), path, constraintDescriptor, this.validatorScopedContext.getConstraintValidatorPayload(), this.validatorScopedContext.getConstraintExpressionLanguageFeatureLevel(), this.validatorScopedContext.getCustomViolationExpressionLanguageFeatureLevel());
    }

    public abstract String toString();

    private String interpolate(String messageTemplate, ExpressionLanguageFeatureLevel expressionLanguageFeatureLevel, boolean customViolation, Object validatedValue, ConstraintDescriptor<?> descriptor, Path path, Map<String, Object> messageParameters, Map<String, Object> expressionVariables) {
        MessageInterpolatorContext context = new MessageInterpolatorContext(descriptor, validatedValue, this.getRootBeanClass(), path, messageParameters, expressionVariables, expressionLanguageFeatureLevel, customViolation);
        try {
            return this.validatorScopedContext.getMessageInterpolator().interpolate(messageTemplate, (MessageInterpolator.Context)context);
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (Exception e) {
            throw LOG.getExceptionOccurredDuringMessageInterpolationException(e);
        }
    }

    private Set<ConstraintViolation<T>> getInitializedFailingConstraintViolations() {
        if (this.failingConstraintViolations == null) {
            this.failingConstraintViolations = new HashSet<ConstraintViolation<T>>();
        }
        return this.failingConstraintViolations;
    }
}

