/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.proxy;

import com.sun.enterprise.admin.util.proxy.Call;
import com.sun.enterprise.admin.util.proxy.CallStack;
import com.sun.enterprise.admin.util.proxy.CallState;
import com.sun.enterprise.admin.util.proxy.Interceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProxyClass
implements InvocationHandler {
    private static InheritableThreadLocal callStackHolder = new InheritableThreadLocal(){

        @Override
        protected synchronized Object initialValue() {
            return new CallStack();
        }
    };
    private static Logger _logger = ProxyClass.getLogger();
    private Object delegate;
    private Interceptor interceptor;

    public ProxyClass(Object handler, Interceptor interceptor) {
        this.delegate = handler;
        this.interceptor = interceptor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Call call = new Call(method, args);
        CallStack callStack = (CallStack)callStackHolder.get();
        callStack.beginCall(call);
        try {
            this.interceptor.preInvoke(callStack);
        }
        catch (Throwable t) {
            _logger.log(Level.FINE, "Preinvoke failed for MBeanServer interceptor [{0}].", t.getMessage());
            _logger.log(Level.FINEST, "Preinvoke exception for MBeanServer interceptor.", t);
        }
        Object result = null;
        boolean success = true;
        Throwable failReason = null;
        try {
            result = method.invoke(this.delegate, args);
        }
        catch (InvocationTargetException ite) {
            success = false;
            failReason = ite.getTargetException();
            throw failReason;
        }
        catch (Throwable t) {
            success = false;
            failReason = t;
            throw failReason;
        }
        finally {
            if (!success) {
                call.setState(CallState.FAILED);
                call.setFailureReason(failReason);
            }
            call.setResult(result);
            if (!call.getState().isFailed()) {
                call.setState(CallState.SUCCESS);
            }
            try {
                this.interceptor.postInvoke(callStack);
            }
            catch (Throwable t) {
                _logger.log(Level.FINE, "Postinvoke failed for MBeanServer interceptor [{0}].", t.getMessage());
                _logger.log(Level.FINEST, "Postinvoke exception for MBeanServer interceptor.", t);
            }
            callStack.endCall();
        }
        return result;
    }

    private static Logger getLogger() {
        String loggerName = System.getProperty("com.sun.aas.admin.logger.name");
        if (loggerName == null) {
            loggerName = "global";
        }
        return Logger.getLogger(loggerName);
    }
}

