/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.MessageCloner;
import org.glassfish.grizzly.asyncqueue.TaskQueue;
import org.glassfish.grizzly.http2.AggrCompletionHandler;
import org.glassfish.grizzly.http2.Http2FrameCodec;
import org.glassfish.grizzly.http2.Http2OutputQueueRecord;
import org.glassfish.grizzly.http2.Http2Session;
import org.glassfish.grizzly.http2.Http2SessionException;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.frames.DataFrame;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.Http2Frame;

public class Http2SessionOutputSink {
    protected final Http2Session http2Session;
    private static final Logger LOGGER = Grizzly.logger(Http2SessionOutputSink.class);
    private static final int MAX_FRAME_PAYLOAD_SIZE = 16383;
    private static final int MAX_OUTPUT_QUEUE_SIZE = 65536;
    private final TaskQueue<Http2OutputQueueRecord> outputQueue = TaskQueue.createTaskQueue(new TaskQueue.MutableMaxQueueSize(this){

        @Override
        public int getMaxQueueSize() {
            return 65536;
        }
    });
    private final AtomicInteger availConnectionWindowSize;
    private final List<Http2Frame> tmpFramesList = new LinkedList<Http2Frame>();
    private final AtomicBoolean writerLock = new AtomicBoolean();

    public Http2SessionOutputSink(Http2Session session) {
        this.http2Session = session;
        this.availConnectionWindowSize = new AtomicInteger(this.http2Session.getDefaultConnectionWindowSize());
    }

    protected Http2FrameCodec frameCodec() {
        return this.http2Session.handlerFilter.frameCodec;
    }

    protected void writeDownStream(Http2Frame frame) {
        this.http2Session.getHttp2SessionChain().write(this.http2Session.getConnection(), null, (Object)this.frameCodec().serializeAndRecycle(this.http2Session, frame), null, (MessageCloner)null);
    }

    protected void writeDownStream(List<Http2Frame> frames) {
        this.http2Session.getHttp2SessionChain().write(this.http2Session.getConnection(), null, (Object)this.frameCodec().serializeAndRecycle(this.http2Session, frames), null, (MessageCloner)null);
    }

    protected <K> void writeDownStream(K anyMessage, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner) {
        Object msg = anyMessage instanceof List ? this.frameCodec().serializeAndRecycle(this.http2Session, (List)anyMessage) : (anyMessage instanceof Http2Frame ? this.frameCodec().serializeAndRecycle(this.http2Session, (Http2Frame)anyMessage) : anyMessage);
        this.http2Session.getHttp2SessionChain().write(this.http2Session.getConnection(), null, msg, completionHandler, messageCloner);
    }

    protected int getAvailablePeerConnectionWindowSize() {
        return this.availConnectionWindowSize.get();
    }

    protected boolean canWrite() {
        return this.outputQueue.size() < 65536;
    }

    protected void notifyCanWrite(WriteHandler writeHandler) {
        this.outputQueue.notifyWritePossible(writeHandler, 65536);
    }

    protected void onPeerWindowUpdate(int delta) throws Http2SessionException {
        int currentWindow = this.availConnectionWindowSize.get();
        if (delta > 0 && currentWindow > 0 && currentWindow + delta < 0) {
            throw new Http2SessionException(ErrorCode.FLOW_CONTROL_ERROR, "Session flow-control window overflow.");
        }
        int newWindowSize = this.availConnectionWindowSize.addAndGet(delta);
        LOGGER.log(Level.FINE, "Http2Session. Expand connection window size by {0} bytes. Current connection window size is: {1}", new Object[]{delta, newWindowSize});
        this.flushOutputQueue();
    }

    protected void writeDataDownStream(Http2Stream stream, List<Http2Frame> headerFrames, Buffer data, CompletionHandler<WriteResult> completionHandler, MessageCloner<Buffer> messageCloner, boolean isLast) {
        if (data == null || !data.hasRemaining() && stream.getUnflushedWritesCount() == 1) {
            Object msg;
            if (data == null) {
                this.writeDownStream(headerFrames, completionHandler, messageCloner);
                return;
            }
            DataFrame dataFrame = ((DataFrame.DataFrameBuilder)DataFrame.builder().streamId(stream.getId())).data(data).endStream(isLast).build();
            if (headerFrames != null && !headerFrames.isEmpty()) {
                headerFrames.add(dataFrame);
                msg = headerFrames;
            } else {
                msg = dataFrame;
            }
            this.writeDownStream(msg, completionHandler, messageCloner);
            return;
        }
        if (headerFrames != null && !headerFrames.isEmpty()) {
            this.writeDownStream(headerFrames);
        }
        int dataSize = data.remaining();
        if (messageCloner != null) {
            data = messageCloner.clone(this.http2Session.getConnection(), data);
        }
        Http2OutputQueueRecord record = new Http2OutputQueueRecord(stream.getId(), data, completionHandler, isLast);
        this.outputQueue.offer(record);
        this.outputQueue.reserveSpace(record.isZeroSizeData() ? 1 : dataSize);
        this.flushOutputQueue();
    }

    private void flushOutputQueue() {
        int backoffDelay = 0;
        boolean needToNotifyQueueManagement = false;
        while (this.availConnectionWindowSize.get() > 0 && !this.outputQueue.isEmpty() && this.writerLock.compareAndSet(false, true)) {
            int availWindowSize = this.availConnectionWindowSize.get();
            int queueSize = this.outputQueue.size();
            AggrCompletionHandler completionHandlers = null;
            AggrCompletionHandler writeCompletionHandler = null;
            int writeCompletionHandlerBytes = 0;
            int bytesToTransfer = 0;
            int queueSizeToFree = 0;
            boolean breakNow = false;
            while (availWindowSize > bytesToTransfer && queueSize > queueSizeToFree) {
                AggrCompletionHandler recordCompletionHandler;
                Http2OutputQueueRecord record = this.outputQueue.poll();
                if (record == null) {
                    LOGGER.log(Level.WARNING, "UNEXPECTED NULL RECORD. Queue-size: {0} byteToTransfer={1} queueSizeToFree={2} queueSize={3}", new Object[]{this.outputQueue.size(), bytesToTransfer, queueSizeToFree, queueSize});
                    breakNow = true;
                    break;
                }
                int serializedBytes = record.serializeTo(this.tmpFramesList, Math.min(16383, availWindowSize - bytesToTransfer));
                bytesToTransfer += serializedBytes;
                queueSizeToFree += serializedBytes;
                if (record.isFinished()) {
                    if (record.isZeroSizeData()) {
                        ++queueSizeToFree;
                    }
                } else {
                    this.outputQueue.setCurrentElement(record);
                }
                if ((recordCompletionHandler = record.getCompletionHandler()) == null) continue;
                if (completionHandlers != null) {
                    completionHandlers.register(recordCompletionHandler, serializedBytes);
                    continue;
                }
                if (writeCompletionHandler == null) {
                    writeCompletionHandler = recordCompletionHandler;
                    writeCompletionHandlerBytes = serializedBytes;
                    continue;
                }
                completionHandlers = new AggrCompletionHandler();
                completionHandlers.register(writeCompletionHandler, writeCompletionHandlerBytes);
                completionHandlers.register(recordCompletionHandler, serializedBytes);
                writeCompletionHandler = completionHandlers;
            }
            if (queueSizeToFree > 0) {
                assert (!this.tmpFramesList.isEmpty());
                this.writeDownStream(this.tmpFramesList, writeCompletionHandler, null);
                int newWindowSize = this.availConnectionWindowSize.addAndGet(-bytesToTransfer);
                this.outputQueue.releaseSpace(queueSizeToFree);
                needToNotifyQueueManagement = true;
                LOGGER.log(Level.FINE, "Http2Session. Shrink connection window size by {0} bytes. Current connection window size is: {1}", new Object[]{bytesToTransfer, newWindowSize});
            }
            this.writerLock.set(false);
            if (breakNow) break;
            LockSupport.parkNanos(backoffDelay++);
        }
        if (needToNotifyQueueManagement) {
            this.outputQueue.doNotify();
        }
    }

    public void close() {
        this.outputQueue.onClose();
    }
}

