/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.List;
import org.jboss.jdeparser.AbstractJComment;
import org.jboss.jdeparser.BlockContent;
import org.jboss.jdeparser.ClassContent;
import org.jboss.jdeparser.ClassFileContent;
import org.jboss.jdeparser.CommentIndentation;
import org.jboss.jdeparser.JClassItem;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Writable;

class BlockJComment
extends AbstractJComment
implements ClassContent,
ClassFileContent,
BlockContent,
JClassItem {
    BlockJComment() {
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        writer.addIndent();
        writer.writeEscaped("/*");
        writer.pushIndent(CommentIndentation.BLOCK);
        try {
            List<Writable> contents = this.getContent();
            if (contents != null && !contents.isEmpty()) {
                writer.nl();
                super.write(writer);
            }
        }
        finally {
            writer.popIndent(CommentIndentation.BLOCK);
        }
        writer.nl();
        writer.addIndent();
        writer.writeEscaped(" */");
        writer.nl();
    }

    @Override
    public JClassItem.Kind getItemKind() {
        return JClassItem.Kind.BLOCK_COMMENT;
    }

    @Override
    public int getModifiers() {
        return 0;
    }

    @Override
    public boolean hasAllModifiers(int mods) {
        return false;
    }

    @Override
    public boolean hasAnyModifier(int mods) {
        return false;
    }

    @Override
    public String getName() {
        return null;
    }
}

