/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.validation;

import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.validation.ErrorHandler;
import com.sun.messaging.jmq.jmsclient.validation.EventHandler;
import com.sun.messaging.jms.JMSException;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidator {
    public static final String IS_Validate = "imq.xml.schema.validate";
    public static final String XSD_URI_LIST = "imq.xml.schema.uri";
    private Vector urilist = null;
    private String xsdURIList = null;
    private Validator validator = null;
    private StreamSource[] ssarray = null;
    private boolean reloadXSDOnFailure = false;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private SAXParser saxParser = null;
    private EventHandler eventHandler = null;
    private boolean debug = Debug.debug;

    protected XMLValidator() throws jakarta.jms.JMSException {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(true);
            this.saxParser = saxFactory.newSAXParser();
            this.eventHandler = new EventHandler();
        }
        catch (Exception ex) {
            JMSException jmse = new JMSException(ex.getMessage());
            jmse.setLinkedException(ex);
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected XMLValidator(String xsdURIList) throws jakarta.jms.JMSException {
        this("http://www.w3.org/2001/XMLSchema", xsdURIList);
    }

    protected XMLValidator(String schemaLang, String xsdURIList) throws jakarta.jms.JMSException {
        try {
            this.xsdURIList = xsdURIList;
            if (xsdURIList == null) {
                throw new NullPointerException("XSD URI List can not be null");
            }
            this.urilist = new Vector();
            StringTokenizer tokens = new StringTokenizer(xsdURIList, " ");
            while (tokens.hasMoreElements()) {
                String uri = tokens.nextToken();
                this.urilist.add(uri);
            }
            if (schemaLang != null) {
                this.setSchemaLanguage(schemaLang);
            }
            this.initSchema();
        }
        catch (Exception ex) {
            JMSException jmse = new JMSException(ex.getMessage());
            jmse.setLinkedException(ex);
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private synchronized void initStreamSource() {
        int size = this.urilist.size();
        this.ssarray = new StreamSource[size];
        for (int i = 0; i < size; ++i) {
            String uri = (String)this.urilist.elementAt(i);
            this.ssarray[i] = new StreamSource(uri);
        }
    }

    private synchronized void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    private synchronized void initSchema() throws SAXException {
        this.initStreamSource();
        SchemaFactory factory = SchemaFactory.newInstance(this.schemaLanguage);
        Schema schema = factory.newSchema(this.ssarray);
        this.validator = schema.newValidator();
        ErrorHandler errorHandler = new ErrorHandler();
        this.validator.setErrorHandler(errorHandler);
    }

    public synchronized void validate(String xml) throws jakarta.jms.JMSException {
        try {
            if (this.validator != null) {
                if (this.reloadXSDOnFailure) {
                    this.reloadXMLSchemaOnFailure(xml);
                } else {
                    this.doValidateXSD(xml);
                }
            } else if (this.saxParser != null) {
                StringReader reader = new StringReader(xml);
                InputSource isource = new InputSource(reader);
                this.saxParser.parse(isource, (DefaultHandler)this.eventHandler);
                this.saxParser.reset();
            }
        }
        catch (Exception ex) {
            JMSException jmse = new JMSException(ex.getMessage());
            jmse.setLinkedException(ex);
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private synchronized void reloadXMLSchemaOnFailure(String xml) throws SAXException, IOException {
        if (this.debug) {
            Debug.println("*** In reloadXMLSchemaOnFailure, validating xml ... ");
        }
        try {
            this.doValidateXSD(xml);
        }
        catch (Exception e) {
            if (this.debug) {
                Debug.println("*** reloading XSD from " + this.xsdURIList);
            }
            this.initSchema();
            if (this.debug) {
                Debug.println("*** re-validating XML ..." + xml);
            }
            this.doValidateXSD(xml);
        }
    }

    private synchronized void doValidateXSD(String xml) throws SAXException, IOException {
        StringReader reader = new StringReader(xml);
        InputSource isource = new InputSource(reader);
        SAXSource saxSource = new SAXSource(isource);
        this.validator.validate(saxSource);
    }

    public synchronized void validateURI(String xmluri) throws jakarta.jms.JMSException {
        try {
            if (this.validator != null) {
                StreamResult result = new StreamResult(System.out);
                StreamSource source = new StreamSource(xmluri);
                this.validator.validate(source, result);
            } else if (this.saxParser != null) {
                System.out.println("*** use saxParser .... isValidating: " + this.saxParser.isValidating());
                this.saxParser.parse(xmluri, (DefaultHandler)this.eventHandler);
            }
        }
        catch (Exception ex) {
            JMSException jmse = new JMSException(ex.getMessage());
            jmse.setLinkedException(ex);
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    public String getURIList() {
        return this.xsdURIList;
    }

    public synchronized void setReloadOnFailure(boolean doReload) {
        this.reloadXSDOnFailure = doReload;
    }

    public boolean getReloadOnFailure() {
        return this.reloadXSDOnFailure;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            XMLValidator xmlValidator = new XMLValidator(args[0]);
            xmlValidator.validateURI(args[1]);
            System.out.println("xml is validated: " + args[1]);
        } else {
            XMLValidator xmlValidator = new XMLValidator();
            xmlValidator.validateURI(args[0]);
            System.out.println("xml is validated without schema: " + args[0]);
        }
    }
}

