/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataFilter;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.TableDataSorter;
import com.sun.data.provider.impl.BasicTableDataFilter;
import com.sun.data.provider.impl.BasicTableDataSorter;
import com.sun.data.provider.impl.ObjectArrayDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import com.sun.webui.jsf.component.HiddenField;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableFooter;
import com.sun.webui.jsf.component.TableHeader;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.FacesListener;
import jakarta.faces.event.PhaseId;
import java.beans.Beans;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableRowGroup
extends UIComponentBase
implements NamingContainer {
    public static final String COLUMN_FOOTER_BAR_ID = "_columnFooterBar";
    public static final String COLUMN_HEADER_BAR_ID = "_columnHeaderBar";
    public static final String EMPTY_DATA_COLUMN_ID = "_emptyDataColumn";
    public static final String EMPTY_DATA_COLUMN_FACET = "emptyDataColumn";
    public static final String EMPTY_DATA_TEXT_ID = "_emptyDataText";
    public static final String EMPTY_DATA_TEXT_FACET = "emptyDataText";
    public static final String FOOTER_FACET = "footer";
    public static final String GROUP_FOOTER_BAR_ID = "_groupFooterBar";
    public static final String GROUP_FOOTER_ID = "_groupFooter";
    public static final String GROUP_FOOTER_FACET = "groupFooter";
    public static final String GROUP_HEADER_BAR_ID = "_groupHeaderBar";
    public static final String GROUP_HEADER_ID = "_groupHeader";
    public static final String GROUP_HEADER_FACET = "groupHeader";
    public static final String HEADER_FACET = "header";
    public static final String TABLE_COLUMN_FOOTER_BAR_ID = "_tableColumnFooterBar";
    private Map<String, SavedState> saved = new HashMap<String, SavedState>();
    private transient TableDataFilter filter = null;
    private transient TableDataSorter sorter = null;
    private boolean paginated = false;
    private boolean paginatedSet = false;
    private TableRowDataProvider provider = null;
    private Table tableAncestor = null;
    private List<TableColumn> tableColumnChildren = null;
    private RowKey[] filteredRowKeys = null;
    private RowKey[] sortedRowKeys = null;
    private int columnCount = -1;
    private boolean aboveColumnFooter = false;
    private boolean aboveColumnFooterSet = false;
    private boolean aboveColumnHeader = false;
    private boolean aboveColumnHeaderSet = false;
    private String align = null;
    private String bgColor = null;
    private String charAttr = null;
    private String charOff = null;
    private boolean collapsed = false;
    private boolean collapsedSet = false;
    private String emptyDataMsg = null;
    private String extraFooterHtml = null;
    private String extraHeaderHtml = null;
    private int first = Integer.MIN_VALUE;
    private boolean firstSet = false;
    private String footerText = null;
    private boolean groupToggleButton = false;
    private boolean groupToggleButtonSet = false;
    private String headerText = null;
    private boolean multipleColumnFooters = false;
    private boolean multipleColumnFootersSet = false;
    private boolean multipleTableColumnFooters = false;
    private boolean multipleTableColumnFootersSet = false;
    private String onClick = null;
    private String onDblClick = null;
    private String onKeyDown = null;
    private String onKeyPress = null;
    private String onKeyUp = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private int rows = Integer.MIN_VALUE;
    private boolean rowsSet = false;
    private boolean selectMultipleToggleButton = false;
    private boolean selectMultipleToggleButtonSet = false;
    private boolean selected = false;
    private boolean selectedSet = false;
    private Object sourceData = null;
    private String sourceVar = null;
    private String styleClasses = null;
    private TableDataFilter tableDataFilter = null;
    private TableDataSorter tableDataSorter = null;
    private String toolTip = null;
    private String valign = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public TableRowGroup() {
        this.setRendererType("com.sun.webui.jsf.TableRowGroup");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.TableRowGroup";
    }

    public void clear() {
        this.provider = null;
        this.tableAncestor = null;
        this.tableColumnChildren = null;
        this.filteredRowKeys = null;
        this.sortedRowKeys = null;
        this.columnCount = -1;
        Iterator<TableColumn> kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn kid = kids.next();
            kid.clear();
        }
    }

    public Table getTableAncestor() {
        if (this.tableAncestor == null) {
            TableRowGroup component = this;
            while (component != null) {
                if (!((component = component.getParent()) instanceof Table)) continue;
                this.tableAncestor = (Table)((Object)component);
                break;
            }
        }
        return this.tableAncestor;
    }

    public Iterator<TableColumn> getTableColumnChildren() {
        if (this.tableColumnChildren == null) {
            this.tableColumnChildren = new ArrayList<TableColumn>();
            for (UIComponent kid : this.getChildren()) {
                if (!(kid instanceof TableColumn)) continue;
                this.tableColumnChildren.add((TableColumn)kid);
            }
        }
        return this.tableColumnChildren.iterator();
    }

    public int getColumnCount() {
        if (this.columnCount == -1) {
            this.columnCount = 0;
            Iterator<TableColumn> kids = this.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                this.columnCount += col.getColumnCount();
            }
        }
        return this.columnCount;
    }

    public UIComponent getEmptyDataColumn() {
        UIComponent facet = this.getFacet(EMPTY_DATA_COLUMN_FACET);
        if (facet != null) {
            return facet;
        }
        TableColumn child = new TableColumn();
        child.setId(EMPTY_DATA_COLUMN_ID);
        child.setColSpan(this.getColumnCount());
        child.getChildren().add(this.getEmptyDataText());
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getEmptyDataText() {
        RowKey[] rowKeys;
        UIComponent facet = this.getFacet(EMPTY_DATA_TEXT_FACET);
        if (facet != null) {
            return facet;
        }
        Theme theme = this.getTheme();
        String msg = null;
        msg = this.getEmptyDataMsg() != null ? this.getEmptyDataMsg() : ((rowKeys = this.getRowKeys()) != null && rowKeys.length > 0 ? theme.getMessage("table.filteredData") : theme.getMessage("table.emptyData"));
        StaticText child = new StaticText();
        child.setId(EMPTY_DATA_TEXT_ID);
        child.setStyleClass(theme.getStyleClass("TABLE_MESSAGE_TEXT"));
        child.setText(msg);
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getGroupFooter() {
        UIComponent facet = this.getFacet(GROUP_FOOTER_FACET);
        if (facet != null) {
            return facet;
        }
        TableFooter child = new TableFooter();
        child.setId(GROUP_FOOTER_ID);
        child.setColSpan(this.getColumnCount());
        child.setExtraHtml(this.getExtraFooterHtml());
        child.setGroupFooter(true);
        facet = this.getFacet(FOOTER_FACET);
        if (!(facet != null && facet.isRendered() || this.getFooterText() != null)) {
            child.setRendered(false);
        } else {
            this.log("getGroupFooter", "Group footer not rendered, nothing to display");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public UIComponent getGroupHeader() {
        UIComponent facet = this.getFacet(GROUP_HEADER_FACET);
        if (facet != null) {
            return facet;
        }
        TableHeader child = new TableHeader();
        child.setId(GROUP_HEADER_ID);
        child.setScope("colgroup");
        child.setColSpan(this.getColumnCount());
        child.setExtraHtml(this.getExtraHeaderHtml());
        child.setGroupHeader(true);
        boolean emptyTable = this.getRowCount() == 0;
        boolean renderControls = !emptyTable && (this.isSelectMultipleToggleButton() || this.isGroupToggleButton());
        facet = this.getFacet(HEADER_FACET);
        if (!(facet != null && facet.isRendered() || this.getHeaderText() != null || renderControls)) {
            child.setRendered(false);
        } else {
            this.log("getGroupHeader", "Group header not rendered, nothing to display");
        }
        this.getFacets().put(child.getId(), child);
        return child;
    }

    public void clearFilter() {
        this.getTableDataFilter().setFilterCriteria(null);
        this.setPage(1);
        this.filteredRowKeys = null;
        this.sortedRowKeys = null;
    }

    public RowKey[] getFilteredRowKeys() {
        if (this.filteredRowKeys != null) {
            return this.filteredRowKeys;
        }
        this.filteredRowKeys = this.getRowKeys();
        TableDataProvider tableProvider = this.getTableRowDataProvider().getTableDataProvider();
        if (tableProvider == null) {
            this.log("getFilteredRowKeys", "Cannot obtain filtered row keys, TableDataProvider is null");
            return this.filteredRowKeys;
        }
        TableDataFilter tableFilter = this.getTableDataFilter();
        if (tableProvider != tableFilter) {
            this.filteredRowKeys = tableFilter.filter(tableProvider, this.filteredRowKeys);
        } else {
            this.log("getFilteredRowKeys", "Row keys already filtered, TableDataFilter and TableDataProvider are the same instance");
        }
        return this.filteredRowKeys;
    }

    public TableDataFilter getTableDataFilter() {
        ValueExpression vb;
        Object tdf = this.tableDataFilter != null ? this.tableDataFilter : ((vb = this.getValueExpression("tableDataFilter")) != null ? (TableDataFilter)vb.getValue(this.getFacesContext().getELContext()) : null);
        if (tdf != null) {
            return tdf;
        }
        if (this.filter == null) {
            this.filter = new BasicTableDataFilter();
        }
        return this.filter;
    }

    public void setFilterCriteria(FilterCriteria[] newFilterCriteria) {
        this.clearFilter();
        this.getTableDataFilter().setFilterCriteria(newFilterCriteria);
    }

    public void setTableDataFilter(TableDataFilter newFilter) {
        this.filter = newFilter;
    }

    public int getFirst() {
        int firstRow;
        int last = this.getLast();
        if (this.isPaginated()) {
            Object result;
            ValueExpression vb;
            int zFirst = this.firstSet ? this.first : ((vb = this.getValueExpression("first")) != null ? ((result = vb.getValue(this.getFacesContext().getELContext())) == null ? Integer.MIN_VALUE : (Integer)result) : 0);
            firstRow = Math.max(0, zFirst);
        } else {
            firstRow = 0;
        }
        if (firstRow < last) {
            return firstRow;
        }
        return last;
    }

    public void setFirst(int newFirst) {
        if (newFirst < 0) {
            this.log("setFirst", "First row cannot be < 0");
            throw new IllegalArgumentException(Integer.toString(newFirst));
        }
        this.first = newFirst;
        this.firstSet = true;
    }

    public int getLast() {
        return Math.max(0, this.getPages() - 1) * this.getRows();
    }

    public int getPage() {
        if (!this.isPaginated()) {
            return 1;
        }
        return this.getFirst() / this.getRows() + 1;
    }

    public int getPages() {
        if (!this.isPaginated()) {
            return 1;
        }
        int rowCount = this.getRowCount();
        int tableRows = this.getRows();
        int modulus = tableRows > 0 ? rowCount % tableRows : 0;
        int result = tableRows > 0 ? rowCount / tableRows : 1;
        if (modulus > 0) {
            return ++result;
        }
        return result;
    }

    public boolean isPaginated() {
        if (!this.paginatedSet) {
            Table table = this.getTableAncestor();
            if (table != null) {
                this.setPaginated(table.isPaginationControls());
            } else {
                this.log("isPaginated", "Cannot initialize paginated state, Table is null");
            }
        }
        return this.paginated;
    }

    public void setPage(int page) {
        int row = (page - 1) * this.getRows();
        int result = Math.min(row, this.getLast());
        this.setFirst(Math.min(Math.max(result, 0), this.getRowCount()));
    }

    public void setPaginated(boolean newPaginated) {
        this.paginated = newPaginated;
        this.paginatedSet = true;
    }

    public int getRows() {
        if (this.isPaginated()) {
            Object result;
            ValueExpression vb;
            int tableRows = this.rowsSet ? this.rows : ((vb = this.getValueExpression("rows")) != null ? ((result = vb.getValue(this.getFacesContext().getELContext())) == null ? Integer.MIN_VALUE : (Integer)result) : 25);
            return Math.max(1, tableRows);
        }
        return 0;
    }

    public void setRows(int newRows) {
        if (newRows < 0) {
            this.log("setRows", "Paginated rows cannot be < 0");
            throw new IllegalArgumentException(Integer.toString(newRows));
        }
        this.rows = newRows;
        this.rowsSet = true;
    }

    public boolean isRowAvailable() {
        boolean result = false;
        TableDataProvider tableProvider = this.getTableRowDataProvider().getTableDataProvider();
        if (tableProvider != null) {
            result = tableProvider.isRowAvailable(this.getRowKey());
        } else {
            this.log("isRowAvailable", "Cannot determine if row is available, TableDataProvider is null");
        }
        return result;
    }

    public RowKey[] getHiddenRowKeys() {
        if (!this.isPaginated()) {
            return null;
        }
        RowKey[] rowKeys = this.getSortedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        int firstRow = this.getFirst();
        int tableRows = this.getRows();
        for (int i = 0; i < rowKeys.length; ++i) {
            if (i >= firstRow && i < firstRow + tableRows) continue;
            list.add(rowKeys[i]);
        }
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public FieldKey getFieldKey(String fieldId) {
        return this.getTableRowDataProvider().getFieldKey(fieldId);
    }

    public int getRowCount() {
        RowKey[] rowKeys = this.getFilteredRowKeys();
        if (rowKeys != null) {
            return rowKeys.length;
        }
        return 0;
    }

    public RowKey getRowKey() {
        return this.getTableRowDataProvider().getTableRow();
    }

    public RowKey[] getRowKeys() {
        RowKey[] rowKeys = null;
        TableDataProvider tableProvider = this.getTableRowDataProvider().getTableDataProvider();
        if (tableProvider == null) {
            this.log("getRowKeys", "Cannot obtain row keys, TableDataProvider is null");
            return rowKeys;
        }
        if (Beans.isDesignTime()) {
            this.log("getRowKeys", "Creating dummy data for design-time behavior");
            rowKeys = tableProvider.getRowKeys(tableProvider.getRowCount(), null);
            if (this.getRows() == 0 || rowKeys == null || rowKeys.length == 0) {
                this.log("getRowKeys", "Cannot create dummy data, DataProvider has no rows");
                return rowKeys;
            }
            ArrayList<RowKey> list = new ArrayList<RowKey>();
            for (int i = 0; i < this.getRows() + 1; ++i) {
                list.add(rowKeys[i % rowKeys.length]);
            }
            rowKeys = new RowKey[list.size()];
            return list.toArray(rowKeys);
        }
        int rowCount = tableProvider.getRowCount();
        if (rowCount == -1) {
            this.log("getRowKeys", "Manually calculating row count, DataProvider.getRowCount() is -1");
            int index = 0;
            while ((rowKeys = tableProvider.getRowKeys(rowCount = 1000000 * ++index, null)) != null && rowKeys.length - 1 == rowCount) {
            }
        } else {
            rowKeys = tableProvider.getRowKeys(rowCount, null);
        }
        return rowKeys;
    }

    protected TableRowDataProvider getTableRowDataProvider() {
        if (this.provider == null) {
            TableDataProvider tdp;
            this.log("getTableRowDataProvider", "Re-evaluating sourceData, TableRowDataProvider is null");
            Object obj = this.getSourceData();
            if (obj == null) {
                tdp = null;
            } else if (obj instanceof TableDataProvider) {
                tdp = (TableDataProvider)obj;
            } else if (obj instanceof List) {
                tdp = new ObjectListDataProvider((List)obj);
            } else if (Object[].class.isAssignableFrom(obj.getClass())) {
                tdp = new ObjectArrayDataProvider((Object[])obj);
            } else {
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(obj);
                tdp = new ObjectListDataProvider(list);
            }
            this.provider = new TableRowDataProvider(tdp);
        }
        return this.provider;
    }

    public Class getType(FieldKey fieldKey) {
        return this.getTableRowDataProvider().getType(fieldKey);
    }

    public RowKey[] getRenderedRowKeys() {
        RowKey[] rowKeys = this.getSortedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        int firstRow = this.getFirst();
        int tableRows = this.getRows();
        for (int i = firstRow; !(i >= rowKeys.length || this.isPaginated() && i >= firstRow + tableRows); ++i) {
            list.add(rowKeys[i]);
        }
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public void setRowKey(RowKey rowKey) {
        this.saveDescendantState();
        this.getTableRowDataProvider().setTableRow(rowKey);
        String tableSourceVar = this.getSourceVar();
        if (tableSourceVar != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (rowKey == null) {
                requestMap.remove(tableSourceVar);
            } else if (this.isRowAvailable()) {
                requestMap.put(tableSourceVar, this.getTableRowDataProvider());
            } else {
                requestMap.remove(tableSourceVar);
            }
        } else {
            this.log("setRowKey", "Cannot set row key, sourceVar property is null");
        }
        this.restoreDescendantState();
    }

    public void setSourceData(Object newSourceData) {
        this.sourceData = newSourceData;
        this.setPage(1);
        this.clear();
    }

    public int getHiddenSelectedRowsCount() {
        RowKey[] rowKeys = this.getHiddenSelectedRowKeys();
        if (rowKeys != null) {
            return rowKeys.length;
        }
        return 0;
    }

    public RowKey[] getHiddenSelectedRowKeys() {
        RowKey[] rowKeys = this.getHiddenRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        RowKey rowKey = this.getRowKey();
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        for (RowKey rowKey1 : rowKeys) {
            this.setRowKey(rowKey1);
            if (!this.isRowAvailable() || !this.isSelected()) continue;
            list.add(rowKey1);
        }
        this.setRowKey(rowKey);
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public int getSelectedRowsCount() {
        RowKey[] rowKeys = this.getSelectedRowKeys();
        if (rowKeys != null) {
            return rowKeys.length;
        }
        return 0;
    }

    public RowKey[] getSelectedRowKeys() {
        RowKey[] rowKeys = this.getFilteredRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        RowKey rowKey = this.getRowKey();
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        for (RowKey rowKey1 : rowKeys) {
            this.setRowKey(rowKey1);
            if (!this.isRowAvailable() || !this.isSelected()) continue;
            list.add(rowKey1);
        }
        this.setRowKey(rowKey);
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public int getRenderedSelectedRowsCount() {
        RowKey[] rowKeys = this.getRenderedSelectedRowKeys();
        if (rowKeys != null) {
            return rowKeys.length;
        }
        return 0;
    }

    public RowKey[] getRenderedSelectedRowKeys() {
        RowKey[] rowKeys = this.getRenderedRowKeys();
        if (rowKeys == null) {
            return rowKeys;
        }
        RowKey rowKey = this.getRowKey();
        ArrayList<RowKey> list = new ArrayList<RowKey>();
        for (RowKey rowKey1 : rowKeys) {
            this.setRowKey(rowKey1);
            if (!this.isRowAvailable() || !this.isSelected()) continue;
            list.add(rowKey1);
        }
        this.setRowKey(rowKey);
        rowKeys = new RowKey[list.size()];
        return list.toArray(rowKeys);
    }

    public void addSort(SortCriteria criteria) {
        if (criteria == null) {
            return;
        }
        TableDataSorter tableSorter = this.getTableDataSorter();
        SortCriteria[] oldCriteria = tableSorter.getSortCriteria();
        if (oldCriteria != null) {
            for (int i = 0; i < oldCriteria.length; ++i) {
                String key;
                if (oldCriteria[i] == null || (key = oldCriteria[i].getCriteriaKey()) == null || !key.equals(criteria.getCriteriaKey())) continue;
                oldCriteria[i] = criteria;
                return;
            }
        }
        int oldLength = oldCriteria != null ? oldCriteria.length : 0;
        SortCriteria[] newCriteria = new SortCriteria[oldLength + 1];
        if (oldLength > 0) {
            System.arraycopy(oldCriteria, 0, newCriteria, 0, oldLength);
        }
        newCriteria[oldLength] = criteria;
        tableSorter.setSortCriteria(newCriteria);
        this.sortedRowKeys = null;
        this.setPage(1);
    }

    public void clearSort() {
        this.getTableDataSorter().setSortCriteria(null);
        this.sortedRowKeys = null;
        this.setPage(1);
    }

    public int getSortCount() {
        int result = 0;
        SortCriteria[] sortCriteria = this.getTableDataSorter().getSortCriteria();
        if (sortCriteria != null) {
            result = sortCriteria.length;
        }
        return result;
    }

    public int getSortLevel(SortCriteria criteria) {
        int result = -1;
        if (criteria == null) {
            return result;
        }
        SortCriteria[] sortCriteria = this.getTableDataSorter().getSortCriteria();
        if (sortCriteria != null) {
            for (int i = 0; i < sortCriteria.length; ++i) {
                String key;
                if (sortCriteria[i] == null || (key = sortCriteria[i].getCriteriaKey()) == null || !key.equals(criteria.getCriteriaKey())) continue;
                result = i + 1;
                break;
            }
        }
        return result;
    }

    public boolean isDescendingSort(SortCriteria criteria) {
        boolean result = false;
        if (criteria == null) {
            return result;
        }
        SortCriteria[] sortCriteria = this.getTableDataSorter().getSortCriteria();
        if (sortCriteria != null) {
            for (SortCriteria sortCriteria1 : sortCriteria) {
                String key;
                if (sortCriteria1 == null || (key = sortCriteria1.getCriteriaKey()) == null || !key.equals(criteria.getCriteriaKey())) continue;
                result = !sortCriteria1.isAscending();
                break;
            }
        }
        return result;
    }

    public RowKey[] getSortedRowKeys() {
        if (this.sortedRowKeys != null) {
            return this.sortedRowKeys;
        }
        this.sortedRowKeys = this.getFilteredRowKeys();
        TableDataProvider tableProvider = this.getTableRowDataProvider().getTableDataProvider();
        if (tableProvider == null) {
            this.log("getSortedRowKeys", "Cannot obtain sorted row keys, TableDataProvider is null");
            return this.sortedRowKeys;
        }
        TableDataSorter tableSorter = this.getTableDataSorter();
        if (tableProvider != tableSorter) {
            this.sortedRowKeys = tableSorter.sort(tableProvider, this.sortedRowKeys);
        }
        return this.sortedRowKeys;
    }

    public TableDataSorter getTableDataSorter() {
        ValueExpression vb;
        Object tds = this.tableDataSorter != null ? this.tableDataSorter : ((vb = this.getValueExpression("tableDataSorter")) != null ? (TableDataSorter)vb.getValue(this.getFacesContext().getELContext()) : null);
        if (tds != null) {
            return tds;
        }
        if (this.sorter == null) {
            this.sorter = new BasicTableDataSorter();
        }
        return this.sorter;
    }

    public void setTableDataSorter(TableDataSorter newSorter) {
        this.sorter = newSorter;
    }

    public void setSortCriteria(SortCriteria[] newSortCriteria) {
        this.clearSort();
        this.getTableDataSorter().setSortCriteria(newSortCriteria);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])((Object[])state)[0];
        super.restoreState(context, values[0]);
        this.aboveColumnFooter = (Boolean)values[1];
        this.aboveColumnFooterSet = (Boolean)values[2];
        this.aboveColumnHeader = (Boolean)values[3];
        this.aboveColumnHeaderSet = (Boolean)values[4];
        this.align = (String)values[5];
        this.bgColor = (String)values[6];
        this.charAttr = (String)values[7];
        this.charOff = (String)values[8];
        this.collapsed = (Boolean)values[9];
        this.collapsedSet = (Boolean)values[10];
        this.emptyDataMsg = (String)values[11];
        this.extraFooterHtml = (String)values[12];
        this.extraHeaderHtml = (String)values[13];
        this.first = (Integer)values[14];
        this.firstSet = (Boolean)values[15];
        this.footerText = (String)values[16];
        this.groupToggleButton = (Boolean)values[17];
        this.groupToggleButtonSet = (Boolean)values[18];
        this.headerText = (String)values[19];
        this.multipleColumnFooters = (Boolean)values[20];
        this.multipleColumnFootersSet = (Boolean)values[21];
        this.multipleTableColumnFooters = (Boolean)values[22];
        this.multipleTableColumnFootersSet = (Boolean)values[23];
        this.onClick = (String)values[24];
        this.onDblClick = (String)values[25];
        this.onKeyDown = (String)values[26];
        this.onKeyPress = (String)values[27];
        this.onKeyUp = (String)values[28];
        this.onMouseDown = (String)values[29];
        this.onMouseMove = (String)values[30];
        this.onMouseOut = (String)values[31];
        this.onMouseOver = (String)values[32];
        this.onMouseUp = (String)values[33];
        this.rows = (Integer)values[34];
        this.rowsSet = (Boolean)values[35];
        this.selectMultipleToggleButton = (Boolean)values[36];
        this.selectMultipleToggleButtonSet = (Boolean)values[37];
        this.selected = (Boolean)values[38];
        this.selectedSet = (Boolean)values[39];
        this.sourceData = (TableDataProvider)values[40];
        this.sourceVar = (String)values[41];
        this.styleClasses = (String)values[42];
        this.tableDataFilter = (TableDataFilter)values[43];
        this.tableDataSorter = (TableDataSorter)values[44];
        this.toolTip = (String)values[45];
        this.valign = (String)values[46];
        this.visible = (Boolean)values[47];
        this.visibleSet = (Boolean)values[48];
        Object[] values2 = (Object[])state;
        values2[0] = values;
        this.saved = (Map)values2[1];
        this.setPaginated((Boolean)values2[2]);
        TableDataSorter tableSorter = this.getTableDataSorter();
        tableSorter.setSortCriteria((SortCriteria[])values2[3]);
        TableDataFilter tableFilter = this.getTableDataFilter();
        tableFilter.setFilterCriteria((FilterCriteria[])values2[4]);
        this.filteredRowKeys = (RowKey[])values2[5];
        this.sortedRowKeys = (RowKey[])values2[6];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.aboveColumnFooter ? Boolean.TRUE : Boolean.FALSE, this.aboveColumnFooterSet ? Boolean.TRUE : Boolean.FALSE, this.aboveColumnHeader ? Boolean.TRUE : Boolean.FALSE, this.aboveColumnHeaderSet ? Boolean.TRUE : Boolean.FALSE, this.align, this.bgColor, this.charAttr, this.charOff, this.collapsed ? Boolean.TRUE : Boolean.FALSE, this.collapsedSet ? Boolean.TRUE : Boolean.FALSE, this.emptyDataMsg, this.extraFooterHtml, this.extraHeaderHtml, this.first, this.firstSet ? Boolean.TRUE : Boolean.FALSE, this.footerText, this.groupToggleButton ? Boolean.TRUE : Boolean.FALSE, this.groupToggleButtonSet ? Boolean.TRUE : Boolean.FALSE, this.headerText, this.multipleColumnFooters ? Boolean.TRUE : Boolean.FALSE, this.multipleColumnFootersSet ? Boolean.TRUE : Boolean.FALSE, this.multipleTableColumnFooters ? Boolean.TRUE : Boolean.FALSE, this.multipleTableColumnFootersSet ? Boolean.TRUE : Boolean.FALSE, this.onClick, this.onDblClick, this.onKeyDown, this.onKeyPress, this.onKeyUp, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, this.rows, this.rowsSet ? Boolean.TRUE : Boolean.FALSE, this.selectMultipleToggleButton ? Boolean.TRUE : Boolean.FALSE, this.selectMultipleToggleButtonSet ? Boolean.TRUE : Boolean.FALSE, this.selected ? Boolean.TRUE : Boolean.FALSE, this.selectedSet ? Boolean.TRUE : Boolean.FALSE, this.sourceData, this.sourceVar, this.styleClasses, this.tableDataFilter, this.tableDataSorter, this.toolTip, this.valign, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        Object[] values2 = new Object[8];
        values2[0] = values;
        values2[1] = this.saved;
        values2[2] = this.isPaginated() ? Boolean.TRUE : Boolean.FALSE;
        values2[3] = this.getTableDataSorter().getSortCriteria();
        values2[4] = this.getTableDataFilter().getFilterCriteria();
        values2[5] = this.getFilteredRowKeys();
        values2[6] = this.getSortedRowKeys();
        return values2;
    }

    public void setValueExpression(String name, ValueExpression valueExpression) {
        if ("sourceData".equals(name)) {
            this.setPage(1);
            this.clear();
        } else if ("sourceVar".equals(name) && !valueExpression.isLiteralText()) {
            this.log("setValueExpression", "sourceVar cannot equal given name");
            throw new IllegalArgumentException();
        }
        super.setValueExpression(name, valueExpression);
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            this.log("getClientId", "Cannot obtain client Id, FacesContext is null");
            throw new NullPointerException();
        }
        String baseClientId = super.getClientId(context);
        if (this.getRowKey() != null) {
            return baseClientId + UINamingContainer.getSeparatorChar((FacesContext)context) + this.getRowKey().getRowId();
        }
        return baseClientId;
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new WrapperEvent((UIComponent)this, event, this.getRowKey()));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof WrapperEvent)) {
            super.broadcast(event);
            return;
        }
        WrapperEvent revent = (WrapperEvent)event;
        RowKey oldRowKey = this.getRowKey();
        this.setRowKey(revent.getRowKey());
        FacesEvent rowEvent = revent.getFacesEvent();
        rowEvent.getComponent().broadcast(rowEvent);
        this.setRowKey(oldRowKey);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.isNestedWithinTableRowGroup()) {
            this.clear();
        }
        if (!this.keepSaved(context)) {
            this.saved = new HashMap<String, SavedState>();
        }
        super.encodeBegin(context);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            this.log("processDecodes", "Cannot decode, FacesContext is null");
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.log("processDecodes", "Component not rendered, nothing to decode");
            return;
        }
        if (this.saved == null || !this.keepSaved(context)) {
            this.saved = new HashMap<String, SavedState>();
        }
        this.iterate(context, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            this.log("processValidators", "Cannot validate, FacesContext is null");
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.log("processValidators", "Component not rendered, nothing to validate");
            return;
        }
        this.iterate(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            this.log("processUpdates", "Cannot update, FacesContext is null");
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            this.log("processUpdates", "Component not rendered, nothing to update");
            return;
        }
        this.iterate(context, PhaseId.UPDATE_MODEL_VALUES);
        UIComponent header = this.getFacet(GROUP_HEADER_ID);
        UIComponent field = header != null ? (UIComponent)header.getFacets().get("_collapsedHiddenField") : null;
        if (field instanceof HiddenField) {
            Boolean value = (Boolean)((HiddenField)field).getText();
            this.setCollapsed(value);
        } else {
            this.log("processUpdates", "Cannot obtain collapsed hidden field value");
        }
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public boolean isAboveColumnFooter() {
        if (this.aboveColumnFooterSet) {
            return this.aboveColumnFooter;
        }
        ValueExpression vb = this.getValueExpression("aboveColumnFooter");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setAboveColumnFooter(boolean newAboveColumnFooter) {
        this.aboveColumnFooter = newAboveColumnFooter;
        this.aboveColumnFooterSet = true;
    }

    public boolean isAboveColumnHeader() {
        if (this.aboveColumnHeaderSet) {
            return this.aboveColumnHeader;
        }
        ValueExpression vb = this.getValueExpression("aboveColumnHeader");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setAboveColumnHeader(boolean newAboveColumnHeader) {
        this.aboveColumnHeader = newAboveColumnHeader;
        this.aboveColumnHeaderSet = true;
    }

    public String getAlign() {
        if (this.align != null) {
            return this.align;
        }
        ValueExpression vb = this.getValueExpression("align");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setAlign(String newAlign) {
        this.align = newAlign;
    }

    public String getBgColor() {
        if (this.bgColor != null) {
            return this.bgColor;
        }
        ValueExpression vb = this.getValueExpression("bgColor");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setBgColor(String newBgColor) {
        this.bgColor = newBgColor;
    }

    public String getChar() {
        if (this.charAttr != null) {
            return this.charAttr;
        }
        ValueExpression vb = this.getValueExpression("char");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setChar(String newCharAttr) {
        this.charAttr = newCharAttr;
    }

    public String getCharOff() {
        if (this.charOff != null) {
            return this.charOff;
        }
        ValueExpression vb = this.getValueExpression("charOff");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setCharOff(String newCharOff) {
        this.charOff = newCharOff;
    }

    public boolean isCollapsed() {
        if (this.collapsedSet) {
            return this.collapsed;
        }
        ValueExpression vb = this.getValueExpression("collapsed");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setCollapsed(boolean newCollapsed) {
        this.collapsed = newCollapsed;
        this.collapsedSet = true;
    }

    public String getEmptyDataMsg() {
        if (this.emptyDataMsg != null) {
            return this.emptyDataMsg;
        }
        ValueExpression vb = this.getValueExpression("emptyDataMsg");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setEmptyDataMsg(String newEmptyDataMsg) {
        this.emptyDataMsg = newEmptyDataMsg;
    }

    public String getExtraFooterHtml() {
        if (this.extraFooterHtml != null) {
            return this.extraFooterHtml;
        }
        ValueExpression vb = this.getValueExpression("extraFooterHtml");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setExtraFooterHtml(String newExtraFooterHtml) {
        this.extraFooterHtml = newExtraFooterHtml;
    }

    public String getExtraHeaderHtml() {
        if (this.extraHeaderHtml != null) {
            return this.extraHeaderHtml;
        }
        ValueExpression vb = this.getValueExpression("extraHeaderHtml");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setExtraHeaderHtml(String newExtraHeaderHtml) {
        this.extraHeaderHtml = newExtraHeaderHtml;
    }

    public String getFooterText() {
        if (this.footerText != null) {
            return this.footerText;
        }
        ValueExpression vb = this.getValueExpression("footerText");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setFooterText(String newFooterText) {
        this.footerText = newFooterText;
    }

    public boolean isGroupToggleButton() {
        if (this.groupToggleButtonSet) {
            return this.groupToggleButton;
        }
        ValueExpression vb = this.getValueExpression("groupToggleButton");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setGroupToggleButton(boolean newGroupToggleButton) {
        this.groupToggleButton = newGroupToggleButton;
        this.groupToggleButtonSet = true;
    }

    public String getHeaderText() {
        if (this.headerText != null) {
            return this.headerText;
        }
        ValueExpression vb = this.getValueExpression("headerText");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setHeaderText(String newHeaderText) {
        this.headerText = newHeaderText;
    }

    public boolean isMultipleColumnFooters() {
        if (this.multipleColumnFootersSet) {
            return this.multipleColumnFooters;
        }
        ValueExpression vb = this.getValueExpression("multipleColumnFooters");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setMultipleColumnFooters(boolean newMultipleColumnFooters) {
        this.multipleColumnFooters = newMultipleColumnFooters;
        this.multipleColumnFootersSet = true;
    }

    public boolean isMultipleTableColumnFooters() {
        if (this.multipleTableColumnFootersSet) {
            return this.multipleTableColumnFooters;
        }
        ValueExpression vb = this.getValueExpression("multipleTableColumnFooters");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setMultipleTableColumnFooters(boolean newMultipleTableColumnFooters) {
        this.multipleTableColumnFooters = newMultipleTableColumnFooters;
        this.multipleTableColumnFootersSet = true;
    }

    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression vb = this.getValueExpression("onClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClick(String newOnClick) {
        this.onClick = newOnClick;
    }

    public String getOnDblClick() {
        if (this.onDblClick != null) {
            return this.onDblClick;
        }
        ValueExpression vb = this.getValueExpression("onDblClick");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnDblClick(String newOnDblClick) {
        this.onDblClick = newOnDblClick;
    }

    public String getOnKeyDown() {
        if (this.onKeyDown != null) {
            return this.onKeyDown;
        }
        ValueExpression vb = this.getValueExpression("onKeyDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyDown(String newOnKeyDown) {
        this.onKeyDown = newOnKeyDown;
    }

    public String getOnKeyPress() {
        if (this.onKeyPress != null) {
            return this.onKeyPress;
        }
        ValueExpression vb = this.getValueExpression("onKeyPress");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyPress(String newOnKeyPress) {
        this.onKeyPress = newOnKeyPress;
    }

    public String getOnKeyUp() {
        if (this.onKeyUp != null) {
            return this.onKeyUp;
        }
        ValueExpression vb = this.getValueExpression("onKeyUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnKeyUp(String newOnKeyUp) {
        this.onKeyUp = newOnKeyUp;
    }

    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression vb = this.getValueExpression("onMouseDown");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseDown(String newOnMouseDown) {
        this.onMouseDown = newOnMouseDown;
    }

    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression vb = this.getValueExpression("onMouseMove");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseMove(String newOnMouseMove) {
        this.onMouseMove = newOnMouseMove;
    }

    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression vb = this.getValueExpression("onMouseOut");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOut(String newOnMouseOut) {
        this.onMouseOut = newOnMouseOut;
    }

    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression vb = this.getValueExpression("onMouseOver");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOver(String newOnMouseOver) {
        this.onMouseOver = newOnMouseOver;
    }

    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression vb = this.getValueExpression("onMouseUp");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseUp(String newOnMouseUp) {
        this.onMouseUp = newOnMouseUp;
    }

    public boolean isSelectMultipleToggleButton() {
        if (this.selectMultipleToggleButtonSet) {
            return this.selectMultipleToggleButton;
        }
        ValueExpression vb = this.getValueExpression("selectMultipleToggleButton");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setSelectMultipleToggleButton(boolean newSelectMultipleToggleButton) {
        this.selectMultipleToggleButton = newSelectMultipleToggleButton;
        this.selectMultipleToggleButtonSet = true;
    }

    public boolean isSelected() {
        if (this.selectedSet) {
            return this.selected;
        }
        ValueExpression vb = this.getValueExpression("selected");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setSelected(boolean newSelected) {
        this.selected = newSelected;
        this.selectedSet = true;
    }

    public Object getSourceData() {
        if (this.sourceData != null) {
            return this.sourceData;
        }
        ValueExpression vb = this.getValueExpression("sourceData");
        if (vb != null) {
            return vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public String getSourceVar() {
        if (this.sourceVar != null) {
            return this.sourceVar;
        }
        ValueExpression vb = this.getValueExpression("sourceVar");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setSourceVar(String newSourceVar) {
        this.sourceVar = newSourceVar;
    }

    public String getStyleClasses() {
        if (this.styleClasses != null) {
            return this.styleClasses;
        }
        ValueExpression vb = this.getValueExpression("styleClasses");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClasses(String newStyleClasses) {
        this.styleClasses = newStyleClasses;
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression vb = this.getValueExpression("toolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String newToolTip) {
        this.toolTip = newToolTip;
    }

    public String getValign() {
        if (this.valign != null) {
            return this.valign;
        }
        ValueExpression vb = this.getValueExpression("valign");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setValign(String newValign) {
        this.valign = newValign;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(this.getFacesContext());
    }

    private boolean isNestedWithinTableRowGroup() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TableRowGroup)) continue;
            return true;
        }
        return false;
    }

    private void iterate(FacesContext context, PhaseId phaseId) {
        if (this.isNestedWithinTableRowGroup()) {
            this.clear();
        }
        this.setRowKey(null);
        Iterator facets = this.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            UIComponent facet = (UIComponent)this.getFacets().get(facets.next());
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                facet.processDecodes(context);
                continue;
            }
            if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                facet.processValidators(context);
                continue;
            }
            if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                facet.processUpdates(context);
                continue;
            }
            this.log("iterate", "Cannot process component facets, Invalid phase ID");
            throw new IllegalArgumentException();
        }
        this.setRowKey(null);
        Iterator<TableColumn> kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn kid = kids.next();
            if (!kid.isRendered()) {
                this.log("iterate", "Cannot process TableColumn facets, TableColumn not rendered");
                continue;
            }
            this.iterateTableColumnFacets(context, kid, phaseId);
        }
        RowKey[] rowKeys = this.getRenderedRowKeys();
        if (rowKeys == null) {
            this.log("iterate", "Cannot iterate over TableColumn children, RowKey array is null");
            return;
        }
        for (RowKey rowKey : rowKeys) {
            this.setRowKey(rowKey);
            if (!this.isRowAvailable()) {
                this.log("iterate", "Cannot iterate over TableColumn children, row not available");
                break;
            }
            kids = this.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn kid = kids.next();
                if (!kid.isRendered()) {
                    this.log("iterate", "Cannot process TableColumn, not rendered");
                    continue;
                }
                for (UIComponent grandkid : kid.getChildren()) {
                    if (!grandkid.isRendered()) {
                        this.log("iterate", "Cannot process TableColumn child, not rendered");
                        continue;
                    }
                    this.iterateTableColumnChildren(context, grandkid, phaseId);
                }
            }
        }
        this.setRowKey(null);
    }

    private void iterateTableColumnFacets(FacesContext context, TableColumn component, PhaseId phaseId) {
        if (component == null) {
            this.log("iterateTableColumnFacets", "Cannot iterate over TableColumn facets,TableColumn is null");
            return;
        }
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                this.iterateTableColumnFacets(context, col, phaseId);
            }
        } else {
            Iterator facets = component.getFacets().keySet().iterator();
            while (facets.hasNext()) {
                UIComponent facet = (UIComponent)component.getFacets().get(facets.next());
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    facet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    facet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    facet.processUpdates(context);
                    continue;
                }
                this.log("iterateTableColumnFacets", "Cannot iterate over TableColumn facets, Invalid phase ID");
                throw new IllegalArgumentException();
            }
        }
    }

    private void iterateTableColumnChildren(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (component == null) {
            this.log("iterateTableColumnChildren", "Cannot iterate over TableColumn children, UIComponent is null");
            return;
        }
        if (component instanceof TableColumn) {
            Iterator kids = component.getChildren().iterator();
            if (kids.hasNext()) {
                while (kids.hasNext()) {
                    UIComponent kid = (UIComponent)kids.next();
                    this.iterateTableColumnChildren(context, kid, phaseId);
                }
            }
        } else if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            component.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            component.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            component.processUpdates(context);
        } else {
            this.log("iterateTableColumnChildren", "Cannot iterate over TableColumn children, Invalid phase ID");
            throw new IllegalArgumentException();
        }
    }

    private boolean keepSaved(FacesContext context) {
        for (String clientId : this.saved.keySet()) {
            SavedState state = this.saved.get(clientId);
            if (state == null || state.getSubmittedValue() == null) continue;
            return true;
        }
        Iterator messages = context.getMessages();
        while (messages.hasNext()) {
            FacesMessage message = (FacesMessage)messages.next();
            if (message.getSeverity().compareTo((Object)FacesMessage.SEVERITY_ERROR) < 0) continue;
            return true;
        }
        return this.isNestedWithinTableRowGroup();
    }

    private void log(String method, String message) {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }

    private void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator<TableColumn> kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn kid = kids.next();
            if (!kid.isRendered()) continue;
            this.restoreDescendantState((UIComponent)kid, context);
        }
    }

    private void restoreDescendantState(UIComponent component, FacesContext context) {
        String id = component.getId();
        component.setId(id);
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = this.saved.get(clientId);
            if (state == null) {
                state = new SavedState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
            ConversionUtilities.restoreRenderedValueState(context, component);
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            this.restoreDescendantState((UIComponent)kids.next(), context);
        }
    }

    private void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        Iterator<TableColumn> kids = this.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn kid = kids.next();
            if (!kid.isRendered()) {
                this.log("saveDescendantState", "Cannot save descendant state, TableColumn not rendered");
                continue;
            }
            this.saveDescendantState((UIComponent)kid, context);
        }
    }

    private void saveDescendantState(UIComponent component, FacesContext context) {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            SavedState state = this.saved.get(clientId);
            if (state == null) {
                state = new SavedState();
                this.saved.put(clientId, state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
            ConversionUtilities.saveRenderedValueState(context, component);
        }
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            this.saveDescendantState((UIComponent)kids.next(), context);
        }
    }

    static final class WrapperEvent
    extends FacesEvent {
        private static final long serialVersionUID = 6625734597395780327L;
        private final FacesEvent event;
        private final RowKey rowKey;

        WrapperEvent(UIComponent component, FacesEvent newEvent, RowKey newRowKey) {
            super(component);
            this.event = newEvent;
            this.rowKey = newRowKey;
        }

        public FacesEvent getFacesEvent() {
            return this.event;
        }

        public RowKey getRowKey() {
            return this.rowKey;
        }

        public PhaseId getPhaseId() {
            return this.event.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.event.setPhaseId(phaseId);
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return false;
        }

        public void processListener(FacesListener listener) {
            throw new IllegalStateException();
        }
    }

    private static final class SavedState
    implements Serializable {
        private static final long serialVersionUID = -5042211238247402956L;
        private Object submittedValue;
        private boolean valid = true;
        private Object value;
        private boolean localValueSet;

        private SavedState() {
        }

        public Object getSubmittedValue() {
            return this.submittedValue;
        }

        public void setSubmittedValue(Object newSubmittedValue) {
            this.submittedValue = newSubmittedValue;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean newValid) {
            this.valid = newValid;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object newValue) {
            this.value = newValue;
        }

        public boolean isLocalValueSet() {
            return this.localValueSet;
        }

        public void setLocalValueSet(boolean newLocalValueSet) {
            this.localValueSet = newLocalValueSet;
        }

        public String toString() {
            return "submittedValue: " + this.submittedValue + " value: " + this.value + " localValueSet: " + this.localValueSet;
        }
    }
}

