/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.security.trust.client;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.IssuedTokenProvider;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.impl.IssuedTokenContextImpl;
import java.util.HashMap;
import java.util.Map;

public class IssuedTokenManager {
    private final Map<String, IssuedTokenProvider> itpMap = new HashMap<String, IssuedTokenProvider>();
    private final Map<String, String> itpClassMap = new HashMap<String, String>();
    private static IssuedTokenManager manager = new IssuedTokenManager();

    private IssuedTokenManager() {
        this.addDefaultProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IssuedTokenManager getInstance() {
        Class<IssuedTokenManager> clazz = IssuedTokenManager.class;
        synchronized (IssuedTokenManager.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public IssuedTokenContext createIssuedTokenContext(IssuedTokenConfiguration config, String appliesTo) {
        IssuedTokenContextImpl ctx = new IssuedTokenContextImpl();
        ctx.getSecurityPolicy().add(config);
        ctx.setEndpointAddress(appliesTo);
        return ctx;
    }

    public void getIssuedToken(IssuedTokenContext ctx) throws WSTrustException {
        IssuedTokenConfiguration config = (IssuedTokenConfiguration)ctx.getSecurityPolicy().get(0);
        IssuedTokenProvider provider = this.getIssuedTokenProvider(config.getProtocol());
        provider.issue(ctx);
    }

    public void renewIssuedToken(IssuedTokenContext ctx) throws WSTrustException {
        IssuedTokenConfiguration config = (IssuedTokenConfiguration)ctx.getSecurityPolicy().get(0);
        IssuedTokenProvider provider = this.getIssuedTokenProvider(config.getProtocol());
        provider.renew(ctx);
    }

    public void cancelIssuedToken(IssuedTokenContext ctx) throws WSTrustException {
        IssuedTokenConfiguration config = (IssuedTokenConfiguration)ctx.getSecurityPolicy().get(0);
        IssuedTokenProvider provider = this.getIssuedTokenProvider(config.getProtocol());
        provider.cancel(ctx);
    }

    public void validateIssuedToken(IssuedTokenContext ctx) throws WSTrustException {
        IssuedTokenConfiguration config = (IssuedTokenConfiguration)ctx.getSecurityPolicy().get(0);
        IssuedTokenProvider provider = this.getIssuedTokenProvider(config.getProtocol());
        provider.validate(ctx);
    }

    private void addDefaultProviders() {
        this.itpClassMap.put("http://schemas.xmlsoap.org/ws/2005/02/trust", "com.sun.xml.ws.security.trust.impl.client.STSIssuedTokenProviderImpl");
        this.itpClassMap.put("http://docs.oasis-open.org/ws-sx/ws-trust/200512", "com.sun.xml.ws.security.trust.impl.client.STSIssuedTokenProviderImpl");
        this.itpClassMap.put("http://schemas.xmlsoap.org/ws/2005/02/sc", "com.sun.xml.ws.security.secconv.impl.client.SCTokenProviderImpl");
        this.itpClassMap.put("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "com.sun.xml.ws.security.secconv.impl.client.SCTokenProviderImpl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IssuedTokenProvider getIssuedTokenProvider(String protocol) throws WSTrustException {
        IssuedTokenProvider itp = null;
        Map<String, IssuedTokenProvider> map = this.itpMap;
        synchronized (map) {
            itp = this.itpMap.get(protocol);
            if (itp != null) return itp;
            String type = this.itpClassMap.get(protocol);
            if (type == null) throw new WSTrustException("IssueTokenProvider for the protocol: " + protocol + "is not supported");
            try {
                Class<?> clazz = null;
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                clazz = loader == null ? Class.forName(type) : loader.loadClass(type);
                if (clazz == null) return itp;
                Class<?> typedClass = clazz;
                itp = (IssuedTokenProvider)typedClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.itpMap.put(protocol, itp);
            }
            catch (Exception e) {
                throw new WSTrustException("IssueTokenProvider for the protocol: " + protocol + "is not supported", e);
            }
            return itp;
        }
    }
}

