/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.tree.CheckContext;
import org.glassfish.rmic.tools.tree.CodeContext;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.Statement;
import org.glassfish.rmic.tools.tree.Vset;

public class CompoundStatement
extends Statement {
    Statement[] args;

    public CompoundStatement(long where, Statement[] args) {
        super(105, where);
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            args[i] = new CompoundStatement(where, new Statement[0]);
        }
    }

    public void insertStatement(Statement s) {
        Statement[] newargs = new Statement[1 + this.args.length];
        newargs[0] = s;
        for (int i = 0; i < this.args.length; ++i) {
            newargs[i + 1] = this.args[i];
        }
        this.args = newargs;
    }

    @Override
    Vset check(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        this.checkLabel(env, ctx);
        if (this.args.length > 0) {
            vset = this.reach(env, vset);
            CheckContext newctx = new CheckContext(ctx, this);
            Environment newenv = Context.newEnvironment(env, newctx);
            for (int i = 0; i < this.args.length; ++i) {
                vset = this.args[i].checkBlockStatement(newenv, newctx, vset, exp);
            }
            vset = vset.join(newctx.vsBreak);
        }
        return ctx.removeAdditionalVars(vset);
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        int i;
        ctx = new Context(ctx, this);
        boolean expand = false;
        int count = 0;
        for (i = 0; i < this.args.length; ++i) {
            Statement s = this.args[i];
            if (s == null) continue;
            if ((s = s.inline(env, ctx)) != null) {
                count = s.op == 105 && s.labels == null ? (count += ((CompoundStatement)s).args.length) : ++count;
                expand = true;
            }
            this.args[i] = s;
        }
        switch (count) {
            case 0: {
                return null;
            }
            case 1: {
                i = this.args.length;
                while (i-- > 0) {
                    if (this.args[i] == null) continue;
                    return this.eliminate(env, this.args[i]);
                }
                break;
            }
        }
        if (expand || count != this.args.length) {
            Statement[] newArgs = new Statement[count];
            int i2 = this.args.length;
            while (i2-- > 0) {
                Statement s = this.args[i2];
                if (s == null) continue;
                if (s.op == 105 && s.labels == null) {
                    Statement[] a = ((CompoundStatement)s).args;
                    int j = a.length;
                    while (j-- > 0) {
                        newArgs[--count] = a[j];
                    }
                    continue;
                }
                newArgs[--count] = s;
            }
            this.args = newArgs;
        }
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        CompoundStatement s = (CompoundStatement)this.clone();
        s.args = new Statement[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            s.args[i] = this.args[i].copyInline(ctx, valNeeded);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        int cost = 0;
        for (int i = 0; i < this.args.length && cost < thresh; cost += this.args[i].costInline(thresh, env, ctx), ++i) {
        }
        return cost;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        CodeContext newctx = new CodeContext(ctx, this);
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].code(env, newctx, asm);
        }
        asm.add(newctx.breakLabel);
    }

    @Override
    public Expression firstConstructor() {
        return this.args.length > 0 ? this.args[0].firstConstructor() : null;
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("{\n");
        for (int i = 0; i < this.args.length; ++i) {
            this.printIndent(out, indent + 1);
            if (this.args[i] != null) {
                this.args[i].print(out, indent + 1);
            } else {
                out.print("<empty>");
            }
            out.print("\n");
        }
        this.printIndent(out, indent);
        out.print("}");
    }
}

