/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jms.injection;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;

public abstract class ForwardingJMSContext
implements JMSContext {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ForwardingJMSContext.class);

    protected abstract JMSContext delegate();

    public JMSContext createContext(int sessionMode) {
        return this.delegate().createContext(sessionMode);
    }

    public JMSProducer createProducer() {
        return this.delegate().createProducer();
    }

    public String getClientID() {
        return this.delegate().getClientID();
    }

    public void setClientID(String clientID) {
        throw this.getUnsupportedException();
    }

    public ConnectionMetaData getMetaData() {
        return this.delegate().getMetaData();
    }

    public ExceptionListener getExceptionListener() {
        return null;
    }

    public void setExceptionListener(ExceptionListener listener) {
        throw this.getUnsupportedException();
    }

    public void start() {
        throw this.getUnsupportedException();
    }

    public void stop() {
        throw this.getUnsupportedException();
    }

    public void setAutoStart(boolean autoStart) {
        throw this.getUnsupportedException();
    }

    public boolean getAutoStart() {
        return true;
    }

    public void close() {
        throw this.getUnsupportedException();
    }

    public BytesMessage createBytesMessage() {
        return this.delegate().createBytesMessage();
    }

    public MapMessage createMapMessage() {
        return this.delegate().createMapMessage();
    }

    public Message createMessage() {
        return this.delegate().createMessage();
    }

    public ObjectMessage createObjectMessage() {
        return this.delegate().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        return this.delegate().createObjectMessage(object);
    }

    public StreamMessage createStreamMessage() {
        return this.delegate().createStreamMessage();
    }

    public TextMessage createTextMessage() {
        return this.delegate().createTextMessage();
    }

    public TextMessage createTextMessage(String text) {
        return this.delegate().createTextMessage(text);
    }

    public boolean getTransacted() {
        return this.delegate().getTransacted();
    }

    public int getSessionMode() {
        return this.delegate().getSessionMode();
    }

    public void commit() {
        throw this.getUnsupportedException();
    }

    public void rollback() {
        throw this.getUnsupportedException();
    }

    public void recover() {
        throw this.getUnsupportedException();
    }

    public JMSConsumer createConsumer(Destination destination) {
        return this.delegate().createConsumer(destination);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        return this.delegate().createConsumer(destination, messageSelector);
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        return this.delegate().createConsumer(destination, messageSelector, noLocal);
    }

    public Queue createQueue(String queueName) {
        return this.delegate().createQueue(queueName);
    }

    public Topic createTopic(String topicName) {
        return this.delegate().createTopic(topicName);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        return this.delegate().createDurableConsumer(topic, name);
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        return this.delegate().createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        return this.delegate().createSharedConsumer(topic, sharedSubscriptionName);
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        return this.delegate().createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        return this.delegate().createSharedDurableConsumer(topic, name);
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        return this.delegate().createSharedDurableConsumer(topic, name, messageSelector);
    }

    public QueueBrowser createBrowser(Queue queue) {
        return this.delegate().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        return this.delegate().createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() {
        return this.delegate().createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() {
        return this.delegate().createTemporaryTopic();
    }

    public void unsubscribe(String name) {
        this.delegate().unsubscribe(name);
    }

    public void acknowledge() {
        throw this.getUnsupportedException();
    }

    private IllegalStateRuntimeException getUnsupportedException() {
        return new IllegalStateRuntimeException(localStrings.getLocalString("JMSContext.injection.not.supported", "This method is not permitted on a container-managed (injected) JMSContext."));
    }
}

