/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class CollectionContainerPolicy
extends InterfaceContainerPolicy {
    public CollectionContainerPolicy() {
    }

    public CollectionContainerPolicy(Class<?> containerClass) {
        super(containerClass);
    }

    public CollectionContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    @Override
    public boolean addInto(Object key, Object element, Object container, AbstractSession session) {
        Object elementToAdd = element;
        if (this.elementDescriptor != null) {
            elementToAdd = this.elementDescriptor.getObjectBuilder().wrapObject(element, session);
        }
        try {
            return ((Collection)container).add(elementToAdd);
        }
        catch (ClassCastException | IllegalArgumentException | UnsupportedOperationException ex1) {
            throw QueryException.cannotAddElement(element, container, ex1);
        }
    }

    @Override
    public Object buildContainerFromVector(Vector vector, AbstractSession session) {
        if (this.getContainerClass() == vector.getClass() && !this.hasElementDescriptor()) {
            return vector;
        }
        return super.buildContainerFromVector(vector, session);
    }

    @Override
    public void clear(Object container) {
        try {
            ((Collection)container).clear();
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "clear()");
        }
    }

    @Override
    public Object cloneFor(Object container) {
        if (container == null) {
            return null;
        }
        if (container instanceof Cloneable) {
            return super.cloneFor(container);
        }
        Collection original = (Collection)container;
        Collection clone = (Collection)this.containerInstance(original.size());
        clone.addAll(original);
        return clone;
    }

    @Override
    protected boolean contains(Object element, Object container) {
        return ((Collection)container).contains(element);
    }

    @Override
    public Class<?> getInterfaceType() {
        return CoreClassConstants.Collection_Class;
    }

    @Override
    public boolean hasOrder() {
        return Helper.classImplementsInterface(this.getContainerClass(), ClassConstants.SortedSet_Class);
    }

    @Override
    public boolean isValidContainer(Object container) {
        return container instanceof Collection;
    }

    @Override
    public boolean isCollectionPolicy() {
        return true;
    }

    @Override
    public Object iteratorFor(Object container) {
        return ((Collection)container).iterator();
    }

    @Override
    protected boolean removeFrom(Object key, Object element, Object container) {
        try {
            return ((Collection)container).remove(element);
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(element, "remove(Object element)");
        }
    }

    @Override
    public int sizeFor(Object container) {
        return ((Collection)container).size();
    }
}

