/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.authorization.spi.impl;

import jakarta.ejb.EJBContext;
import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyFactory;
import jakarta.security.jacc.PrincipalMapper;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.glassfish.soteria.authorization.EJB;

class Authorization {
    Authorization() {
    }

    public static Subject getSubject() {
        return (Subject)Authorization.getFromContext("javax.security.auth.Subject.container");
    }

    public static Principal getCallerPrincipal() {
        Subject subject = Authorization.getSubject();
        if (subject == null) {
            return null;
        }
        PrincipalMapper mapper = (PrincipalMapper)Authorization.getFromContext("jakarta.security.jacc.PrincipalMapper");
        return mapper.getCallerPrincipal(subject);
    }

    public static boolean isCallerInRole(String role) {
        Subject subject = Authorization.getSubject();
        if (Authorization.hasPermission(subject, (Permission)new WebRoleRefPermission("", role))) {
            return true;
        }
        EJBContext ejbContext = EJB.getEJBContext();
        if (ejbContext == null) {
            return false;
        }
        String ejbName = EJB.getCurrentEJBName(ejbContext);
        if (ejbName != null) {
            return Authorization.hasPermission(subject, (Permission)new EJBRoleRefPermission(ejbName, role));
        }
        return ejbContext.isCallerInRole(role);
    }

    public static boolean hasAccessToWebResource(String resource, String ... methods) {
        return Authorization.hasPermission(Authorization.getSubject(), (Permission)new WebResourcePermission(resource, methods));
    }

    public static Set<String> getAllDeclaredCallerRoles() {
        PermissionCollection permissionCollection = Authorization.getPermissionCollection(Authorization.getSubject());
        permissionCollection.implies((Permission)new WebRoleRefPermission("", "nothing"));
        permissionCollection.implies((Permission)new EJBRoleRefPermission("", "nothing"));
        return Authorization.filterRoles(permissionCollection);
    }

    public static boolean hasPermission(Subject subject, Permission permission) {
        return Authorization.getPolicy().implies(permission, subject);
    }

    public static PermissionCollection getPermissionCollection(Subject subject) {
        return Authorization.getPolicy().getPermissionCollection(subject);
    }

    private static Policy getPolicy() {
        return PolicyFactory.getPolicyFactory().getPolicy();
    }

    public static Set<String> filterRoles(PermissionCollection permissionCollection) {
        HashSet<String> roles = new HashSet<String>();
        for (Permission permission : Collections.list(permissionCollection.elements())) {
            String role;
            if (!Authorization.isRolePermission(permission) || roles.contains(role = permission.getActions()) || !Authorization.isCallerInRole(role)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static <T> T getFromContext(String contextName) {
        return (T)PolicyContext.get((String)contextName);
    }

    public static boolean isRolePermission(Permission permission) {
        return permission instanceof WebRoleRefPermission || permission instanceof EJBRoleRefPermission;
    }
}

