/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.helper.CoreConversionManager;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class ConversionManager
extends CoreConversionManager
implements Serializable,
Cloneable {
    protected Map<Class<?>, Object> defaultNullValues;
    private static ZoneId defaultZoneOffset = null;
    protected boolean shouldUseClassLoaderFromCurrentThread = false;
    protected static ConversionManager defaultManager;
    private static ClassLoader defaultLoader;
    protected ClassLoader loader;
    protected Map<Object, List<Class<?>>> dataTypesConvertedFromAClass = new Hashtable();
    protected Map<Class<?>, List<Class<?>>> dataTypesConvertedToAClass = new Hashtable();

    private static ZoneId getDefaultZoneOffset() {
        if (defaultZoneOffset == null) {
            ZoneId tzoneid;
            block11: {
                tzoneid = null;
                String tzone = null;
                try {
                    tzone = PrivilegedAccessHelper.getSystemProperty("org.eclipse.persistence.conversion.useTimeZone");
                    if (tzone != null) {
                        try {
                            tzoneid = ZoneId.of(tzone);
                        }
                        catch (Throwable t) {
                            if (AbstractSessionLog.getLog().shouldLog(6)) {
                                AbstractSessionLog.getLog().log(6, "invalid_tzone", "org.eclipse.persistence.conversion.useTimeZone", (Object)tzone);
                            }
                        }
                    }
                }
                catch (Exception t) {
                    // empty catch block
                }
                String propVal = null;
                try {
                    if (tzoneid == null) {
                        propVal = PrivilegedAccessHelper.getSystemProperty("org.eclipse.persistence.conversion.useDefaultTimeZoneForJavaTime", "false");
                        tzoneid = Boolean.parseBoolean(propVal) ? ZoneId.systemDefault() : ZoneOffset.UTC;
                    }
                }
                catch (Exception e) {
                    tzoneid = ZoneOffset.UTC;
                    if (!AbstractSessionLog.getLog().shouldLog(6)) break block11;
                    AbstractSessionLog.getLog().log(6, "invalid_default_tzone", "org.eclipse.persistence.conversion.useDefaultTimeZoneForJavaTime", (Object)propVal);
                }
            }
            defaultZoneOffset = tzoneid;
            if (AbstractSessionLog.getLog().shouldLog(2)) {
                AbstractSessionLog.getLog().log(2, "using_conversion_tzone", defaultZoneOffset);
            }
        }
        return defaultZoneOffset;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            return null;
        }
    }

    @Override
    public <T> T convertObject(Object sourceObject, Class<T> javaClass) throws ConversionException {
        if (sourceObject == null) {
            if (javaClass != null) {
                return this.getDefaultNullValue(javaClass);
            }
            return null;
        }
        if (sourceObject.getClass() == javaClass || javaClass == null || javaClass == CoreClassConstants.OBJECT || javaClass == ClassConstants.BLOB || javaClass == ClassConstants.CLOB || javaClass.getName().contains("json")) {
            return (T)sourceObject;
        }
        try {
            if (javaClass == CoreClassConstants.STRING) {
                return (T)this.convertObjectToString(sourceObject);
            }
            if (javaClass == CoreClassConstants.UTILDATE) {
                return (T)this.convertObjectToUtilDate(sourceObject);
            }
            if (javaClass == ClassConstants.SQLDATE) {
                return (T)this.convertObjectToDate(sourceObject);
            }
            if (javaClass == ClassConstants.TIME) {
                return (T)this.convertObjectToTime(sourceObject);
            }
            if (javaClass == ClassConstants.TIMESTAMP) {
                return (T)this.convertObjectToTimestamp(sourceObject);
            }
            if (javaClass == ClassConstants.TIME_INSTANT) {
                return (T)this.convertObjectToInstant(sourceObject);
            }
            if (javaClass == ClassConstants.TIME_LDATE) {
                return (T)this.convertObjectToLocalDate(sourceObject);
            }
            if (javaClass == ClassConstants.TIME_LDATETIME) {
                return (T)this.convertObjectToLocalDateTime(sourceObject);
            }
            if (javaClass == ClassConstants.TIME_LTIME) {
                return (T)this.convertObjectToLocalTime(sourceObject);
            }
            if (javaClass == ClassConstants.TIME_ODATETIME) {
                return (T)this.convertObjectToOffsetDateTime(sourceObject);
            }
            if (javaClass == ClassConstants.TIME_OTIME) {
                return (T)this.convertObjectToOffsetTime(sourceObject);
            }
            if (javaClass == ClassConstants.TIME_YEAR) {
                return (T)this.convertObjectToYear(sourceObject);
            }
            if (javaClass == CoreClassConstants.CALENDAR || javaClass == CoreClassConstants.GREGORIAN_CALENDAR) {
                return (T)this.convertObjectToCalendar(sourceObject);
            }
            if (javaClass == CoreClassConstants.CHAR || javaClass == CoreClassConstants.PCHAR && !(sourceObject instanceof Character)) {
                return (T)this.convertObjectToChar(sourceObject);
            }
            if (javaClass == CoreClassConstants.INTEGER || javaClass == CoreClassConstants.PINT && !(sourceObject instanceof Integer)) {
                return (T)this.convertObjectToInteger(sourceObject);
            }
            if (javaClass == CoreClassConstants.DOUBLE || javaClass == CoreClassConstants.PDOUBLE && !(sourceObject instanceof Double)) {
                return (T)this.convertObjectToDouble(sourceObject);
            }
            if (javaClass == CoreClassConstants.FLOAT || javaClass == CoreClassConstants.PFLOAT && !(sourceObject instanceof Float)) {
                return (T)this.convertObjectToFloat(sourceObject);
            }
            if (javaClass == CoreClassConstants.LONG || javaClass == CoreClassConstants.PLONG && !(sourceObject instanceof Long)) {
                return (T)this.convertObjectToLong(sourceObject);
            }
            if (javaClass == CoreClassConstants.SHORT || javaClass == CoreClassConstants.PSHORT && !(sourceObject instanceof Short)) {
                return (T)this.convertObjectToShort(sourceObject);
            }
            if (javaClass == CoreClassConstants.BYTE || javaClass == CoreClassConstants.PBYTE && !(sourceObject instanceof Byte)) {
                return (T)this.convertObjectToByte(sourceObject);
            }
            if (javaClass == CoreClassConstants.BIGINTEGER) {
                return (T)this.convertObjectToBigInteger(sourceObject);
            }
            if (javaClass == CoreClassConstants.BIGDECIMAL) {
                return (T)this.convertObjectToBigDecimal(sourceObject);
            }
            if (javaClass == CoreClassConstants.NUMBER) {
                return (T)this.convertObjectToNumber(sourceObject);
            }
            if (javaClass == CoreClassConstants.BOOLEAN || javaClass == CoreClassConstants.PBOOLEAN && !(sourceObject instanceof Boolean)) {
                return (T)this.convertObjectToBoolean(sourceObject);
            }
            if (javaClass == CoreClassConstants.APBYTE) {
                return (T)this.convertObjectToByteArray(sourceObject);
            }
            if (javaClass == CoreClassConstants.ABYTE) {
                return (T)this.convertObjectToByteObjectArray(sourceObject);
            }
            if (javaClass == CoreClassConstants.APCHAR) {
                return (T)this.convertObjectToCharArray(sourceObject);
            }
            if (javaClass == ClassConstants.ACHAR) {
                return (T)this.convertObjectToCharacterArray(sourceObject);
            }
            if (sourceObject.getClass() == CoreClassConstants.STRING && javaClass == CoreClassConstants.CLASS) {
                return (T)this.convertObjectToClass(sourceObject);
            }
            if (javaClass == CoreClassConstants.URL_Class) {
                return (T)this.convertObjectToUrl(sourceObject);
            }
            if (javaClass == CoreClassConstants.UUID) {
                return (T)this.convertObjectToUUID(sourceObject);
            }
        }
        catch (ConversionException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw ConversionException.couldNotBeConverted(sourceObject, javaClass, e);
        }
        if (javaClass == CoreClassConstants.PBOOLEAN && sourceObject instanceof Boolean || javaClass == CoreClassConstants.PLONG && sourceObject instanceof Long || javaClass == CoreClassConstants.PINT && sourceObject instanceof Integer || javaClass == CoreClassConstants.PFLOAT && sourceObject instanceof Float || javaClass == CoreClassConstants.PDOUBLE && sourceObject instanceof Double || javaClass == CoreClassConstants.PBYTE && sourceObject instanceof Byte || javaClass == CoreClassConstants.PCHAR && sourceObject instanceof Character || javaClass == CoreClassConstants.PSHORT && sourceObject instanceof Short) {
            return (T)sourceObject;
        }
        if (javaClass.isInstance(sourceObject)) {
            return (T)sourceObject;
        }
        if (ClassConstants.NOCONVERSION.isAssignableFrom(javaClass)) {
            return (T)sourceObject;
        }
        throw ConversionException.couldNotBeConverted(sourceObject, javaClass);
    }

    protected BigDecimal convertObjectToBigDecimal(Object sourceObject) throws ConversionException {
        BigDecimal bigDecimal;
        block5: {
            bigDecimal = null;
            try {
                if (sourceObject instanceof String) {
                    bigDecimal = new BigDecimal((String)sourceObject);
                    break block5;
                }
                if (sourceObject instanceof BigInteger) {
                    bigDecimal = new BigDecimal((BigInteger)sourceObject);
                    break block5;
                }
                if (sourceObject instanceof Number) {
                    String numberString = String.valueOf(sourceObject);
                    bigDecimal = numberString.endsWith(".0") || numberString.contains(".0E+") ? new BigDecimal(((Number)sourceObject).doubleValue()) : new BigDecimal(numberString);
                    break block5;
                }
                throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.BIGDECIMAL);
            }
            catch (NumberFormatException exception) {
                throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.BIGDECIMAL, exception);
            }
        }
        return bigDecimal;
    }

    protected BigInteger convertObjectToBigInteger(Object sourceObject) throws ConversionException {
        BigInteger bigInteger;
        block9: {
            bigInteger = null;
            try {
                if (sourceObject instanceof BigInteger) {
                    bigInteger = (BigInteger)sourceObject;
                    break block9;
                }
                if (sourceObject instanceof String) {
                    bigInteger = new BigInteger((String)sourceObject);
                    break block9;
                }
                if (sourceObject instanceof BigDecimal) {
                    bigInteger = ((BigDecimal)sourceObject).toBigInteger();
                    break block9;
                }
                if (sourceObject instanceof Number) {
                    bigInteger = new BigInteger(String.valueOf(((Number)sourceObject).longValue()));
                    break block9;
                }
                if (sourceObject instanceof Byte[]) {
                    Byte[] objectBytes = (Byte[])sourceObject;
                    byte[] bytes = new byte[objectBytes.length];
                    for (int index = 0; index < objectBytes.length; ++index) {
                        bytes[index] = objectBytes[index];
                    }
                    bigInteger = new BigInteger(bytes);
                    break block9;
                }
                if (sourceObject instanceof byte[]) {
                    bigInteger = new BigInteger((byte[])sourceObject);
                    break block9;
                }
                throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.BIGINTEGER);
            }
            catch (NumberFormatException exception) {
                throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.BIGINTEGER, exception);
            }
        }
        return bigInteger;
    }

    protected Boolean convertObjectToBoolean(Object sourceObject) {
        if (sourceObject instanceof Character) {
            switch (Character.toLowerCase(((Character)sourceObject).charValue())) {
                case '1': 
                case 't': {
                    return Boolean.TRUE;
                }
                case '0': 
                case 'f': {
                    return Boolean.FALSE;
                }
            }
        }
        if (sourceObject instanceof String) {
            String stringValue = ((String)sourceObject).toLowerCase();
            if (stringValue.equals("t") || stringValue.equals("true") || stringValue.equals("1")) {
                return Boolean.TRUE;
            }
            if (stringValue.equals("f") || stringValue.equals("false") || stringValue.equals("0")) {
                return Boolean.FALSE;
            }
        }
        if (sourceObject instanceof Number) {
            int intValue = ((Number)sourceObject).intValue();
            if (intValue != 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.BOOLEAN);
    }

    protected Byte convertObjectToByte(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return Byte.valueOf((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return ((Number)sourceObject).byteValue();
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.BYTE, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.BYTE);
    }

    protected byte[] convertObjectToByteArray(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof byte[]) {
            return (byte[])sourceObject;
        }
        if (sourceObject instanceof Byte[]) {
            Byte[] objectBytes = (Byte[])sourceObject;
            byte[] bytes = new byte[objectBytes.length];
            for (int index = 0; index < objectBytes.length; ++index) {
                Byte value = objectBytes[index];
                if (value == null) continue;
                bytes[index] = value;
            }
            return bytes;
        }
        if (sourceObject instanceof String) {
            return HexFormat.of().parseHex((String)sourceObject);
        }
        if (sourceObject instanceof Blob) {
            Blob blob = (Blob)sourceObject;
            try {
                return blob.getBytes(1L, (int)blob.length());
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception);
            }
        }
        if (sourceObject instanceof InputStream) {
            InputStream inputStream = (InputStream)sourceObject;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int tempInt = inputStream.read();
                while (tempInt != -1) {
                    outputStream.write(tempInt);
                    tempInt = inputStream.read();
                }
                return outputStream.toByteArray();
            }
            catch (IOException ioException) {
                throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.APBYTE, ioException);
            }
        }
        if (sourceObject instanceof BigInteger) {
            return ((BigInteger)sourceObject).toByteArray();
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.APBYTE);
    }

    protected Byte[] convertObjectToByteObjectArray(Object sourceObject) throws ConversionException {
        byte[] bytes = this.convertObjectToByteArray(sourceObject);
        Byte[] objectBytes = new Byte[bytes.length];
        for (int index = 0; index < bytes.length; ++index) {
            objectBytes[index] = bytes[index];
        }
        return objectBytes;
    }

    protected Calendar convertObjectToCalendar(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof Calendar) {
            return (Calendar)sourceObject;
        }
        if (sourceObject instanceof java.util.Date) {
            return Helper.calendarFromUtilDate((java.util.Date)sourceObject);
        }
        return Helper.calendarFromUtilDate(this.convertObjectToUtilDate(sourceObject));
    }

    protected Character convertObjectToChar(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof String) {
            if (((String)sourceObject).isEmpty()) {
                return this.getDefaultNullValue(CoreClassConstants.PCHAR);
            }
            return Character.valueOf(((String)sourceObject).charAt(0));
        }
        if (sourceObject instanceof Number) {
            return Character.valueOf((char)((Number)sourceObject).byteValue());
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.CHAR);
    }

    protected Character[] convertObjectToCharacterArray(Object sourceObject) throws ConversionException {
        String stringValue = this.convertObjectToString(sourceObject);
        Character[] chars = new Character[stringValue.length()];
        for (int index = 0; index < stringValue.length(); ++index) {
            chars[index] = Character.valueOf(stringValue.charAt(index));
        }
        return chars;
    }

    protected char[] convertObjectToCharArray(Object sourceObject) throws ConversionException {
        if (sourceObject instanceof Character[]) {
            Character[] objectChars = (Character[])sourceObject;
            char[] chars = new char[objectChars.length];
            for (int index = 0; index < objectChars.length; ++index) {
                chars[index] = objectChars[index].charValue();
            }
            return chars;
        }
        String stringValue = this.convertObjectToString(sourceObject);
        char[] chars = new char[stringValue.length()];
        for (int index = 0; index < stringValue.length(); ++index) {
            chars[index] = stringValue.charAt(index);
        }
        return chars;
    }

    protected <T> Class<T> convertObjectToClass(Object sourceObject) throws ConversionException {
        Class<Object> theClass = null;
        if (!(sourceObject instanceof String)) {
            throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.CLASS);
        }
        try {
            theClass = ConversionManager.getPrimitiveClass((String)sourceObject);
            if (theClass == null) {
                theClass = Class.forName((String)sourceObject, true, this.getLoader());
            }
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConvertedToClass(sourceObject, CoreClassConstants.CLASS, exception);
        }
        return theClass;
    }

    protected Date convertObjectToDate(Object sourceObject) throws ConversionException {
        Date date = null;
        if (sourceObject instanceof Date) {
            date = (Date)sourceObject;
        } else if (sourceObject instanceof Timestamp) {
            date = Helper.dateFromTimestamp((Timestamp)sourceObject);
        } else if (sourceObject.getClass() == CoreClassConstants.UTILDATE) {
            date = Helper.sqlDateFromUtilDate((java.util.Date)sourceObject);
        } else {
            if (sourceObject instanceof Calendar) {
                return Helper.dateFromCalendar((Calendar)sourceObject);
            }
            if (sourceObject instanceof String) {
                date = Helper.dateFromString((String)sourceObject);
            } else if (sourceObject instanceof Long) {
                date = Helper.dateFromLong((Long)sourceObject);
            } else {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.SQLDATE);
            }
        }
        return date;
    }

    protected Double convertObjectToDouble(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return Double.valueOf((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return ((Number)sourceObject).doubleValue();
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.DOUBLE, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.DOUBLE);
    }

    protected Float convertObjectToFloat(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return Float.valueOf((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return Float.valueOf(((Number)sourceObject).floatValue());
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.FLOAT, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.FLOAT);
    }

    protected Integer convertObjectToInteger(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return Integer.valueOf((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return ((Number)sourceObject).intValue();
            }
            if (sourceObject instanceof Boolean) {
                if (((Boolean)sourceObject).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.INTEGER, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.INTEGER);
    }

    protected Long convertObjectToLong(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return Long.valueOf((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return ((Number)sourceObject).longValue();
            }
            if (sourceObject instanceof java.util.Date) {
                return ((java.util.Date)sourceObject).getTime();
            }
            if (sourceObject instanceof Calendar) {
                return ((Calendar)sourceObject).getTimeInMillis();
            }
            if (sourceObject instanceof Boolean) {
                if (((Boolean)sourceObject).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.LONG, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.LONG);
    }

    protected BigDecimal convertObjectToNumber(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return new BigDecimal((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return new BigDecimal(((Number)sourceObject).doubleValue());
            }
            if (sourceObject instanceof Boolean) {
                if (((Boolean)sourceObject).booleanValue()) {
                    return BigDecimal.valueOf(1L);
                }
                return BigDecimal.valueOf(0L);
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.NUMBER, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.NUMBER);
    }

    protected Short convertObjectToShort(Object sourceObject) throws ConversionException {
        try {
            if (sourceObject instanceof String) {
                return Short.valueOf((String)sourceObject);
            }
            if (sourceObject instanceof Number) {
                return ((Number)sourceObject).shortValue();
            }
            if (sourceObject instanceof Boolean) {
                if (((Boolean)sourceObject).booleanValue()) {
                    return (short)1;
                }
                return (short)0;
            }
        }
        catch (Exception exception) {
            throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.SHORT, exception);
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.SHORT);
    }

    protected String convertObjectToString(Object sourceObject) throws ConversionException {
        Class<?> sourceObjectClass = sourceObject.getClass();
        if (sourceObject instanceof Number) {
            return sourceObject.toString();
        }
        if (sourceObjectClass == CoreClassConstants.BOOLEAN) {
            return sourceObject.toString();
        }
        if (sourceObjectClass == CoreClassConstants.UTILDATE) {
            return Helper.printTimestamp(Helper.timestampFromDate((java.util.Date)sourceObject));
        }
        if (sourceObject instanceof Calendar) {
            return Helper.printCalendar((Calendar)sourceObject);
        }
        if (sourceObjectClass == ClassConstants.TIMESTAMP) {
            return Helper.printTimestamp((Timestamp)sourceObject);
        }
        if (sourceObject instanceof Date) {
            return Helper.printDate((Date)sourceObject);
        }
        if (sourceObject instanceof Time) {
            return Helper.printTime((Time)sourceObject);
        }
        if (sourceObjectClass == CoreClassConstants.APBYTE) {
            return HexFormat.of().formatHex((byte[])sourceObject);
        }
        if (sourceObjectClass == CoreClassConstants.ABYTE) {
            return HexFormat.of().formatHex(this.convertObjectToByteArray(sourceObject));
        }
        if (sourceObjectClass == CoreClassConstants.APCHAR) {
            return new String((char[])sourceObject);
        }
        if (sourceObjectClass == ClassConstants.ACHAR) {
            return new String(this.convertObjectToCharArray(sourceObject));
        }
        if (sourceObject instanceof Class) {
            return ((Class)sourceObject).getName();
        }
        if (sourceObjectClass == CoreClassConstants.CHAR) {
            return sourceObject.toString();
        }
        if (sourceObject instanceof Clob) {
            Clob clob = (Clob)sourceObject;
            try {
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception);
            }
        }
        return sourceObject.toString();
    }

    protected Time convertObjectToTime(Object sourceObject) throws ConversionException {
        Time time = null;
        if (sourceObject instanceof Time) {
            return (Time)sourceObject;
        }
        if (sourceObject instanceof String) {
            time = Helper.timeFromString((String)sourceObject);
        } else if (sourceObject.getClass() == CoreClassConstants.UTILDATE) {
            time = Helper.timeFromDate((java.util.Date)sourceObject);
        } else if (sourceObject instanceof Timestamp) {
            time = Helper.timeFromTimestamp((Timestamp)sourceObject);
        } else {
            if (sourceObject instanceof Calendar) {
                return Helper.timeFromCalendar((Calendar)sourceObject);
            }
            if (sourceObject instanceof Long) {
                time = Helper.timeFromLong((Long)sourceObject);
            } else if (sourceObject.getClass() == ClassConstants.TIME_LTIME) {
                time = Time.valueOf((LocalTime)sourceObject);
            } else if (sourceObject.getClass() == ClassConstants.TIME_OTIME) {
                time = Time.valueOf(((OffsetTime)sourceObject).toLocalTime());
            } else {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME);
            }
        }
        return time;
    }

    protected Timestamp convertObjectToTimestamp(Object sourceObject) throws ConversionException {
        Timestamp timestamp = null;
        if (sourceObject instanceof Timestamp) {
            return (Timestamp)sourceObject;
        }
        if (sourceObject instanceof String) {
            timestamp = Helper.timestampFromString((String)sourceObject);
        } else if (sourceObject instanceof java.util.Date) {
            timestamp = Helper.timestampFromDate((java.util.Date)sourceObject);
        } else {
            if (sourceObject instanceof Calendar) {
                return Helper.timestampFromCalendar((Calendar)sourceObject);
            }
            if (sourceObject instanceof Long) {
                timestamp = Helper.timestampFromLong((Long)sourceObject);
            } else if (sourceObject instanceof LocalDateTime) {
                timestamp = Timestamp.valueOf((LocalDateTime)sourceObject);
            } else {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIMESTAMP);
            }
        }
        return timestamp;
    }

    protected Instant convertObjectToInstant(Object sourceObject) throws ConversionException {
        Instant instant = null;
        if (sourceObject instanceof Instant) {
            return (Instant)sourceObject;
        }
        if (sourceObject instanceof String) {
            instant = Instant.parse((String)sourceObject);
        } else if (sourceObject instanceof Date) {
            instant = Instant.ofEpochMilli(((Date)sourceObject).getTime());
        } else if (sourceObject instanceof Timestamp) {
            instant = ((Timestamp)sourceObject).toInstant();
        } else if (sourceObject instanceof java.util.Date) {
            instant = ((java.util.Date)sourceObject).toInstant();
        } else if (sourceObject instanceof Calendar) {
            Calendar cal = (Calendar)sourceObject;
            instant = cal.toInstant();
        } else if (sourceObject instanceof LocalDateTime) {
            instant = ((LocalDateTime)sourceObject).toInstant(ZoneOffset.UTC);
        } else if (sourceObject instanceof Long) {
            instant = Instant.ofEpochSecond((Long)sourceObject);
        } else {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME_LDATE);
        }
        return instant;
    }

    protected LocalDate convertObjectToLocalDate(Object sourceObject) throws ConversionException {
        LocalDate localDate = null;
        if (sourceObject instanceof LocalDate) {
            return (LocalDate)sourceObject;
        }
        if (sourceObject instanceof String) {
            localDate = LocalDate.parse(((String)sourceObject).replace(' ', 'T'), Helper.getDefaultDateTimeFormatter());
        } else if (sourceObject instanceof Date) {
            localDate = ((Date)sourceObject).toLocalDate();
        } else if (sourceObject instanceof Timestamp) {
            localDate = ((Timestamp)sourceObject).toLocalDateTime().toLocalDate();
        } else if (sourceObject instanceof java.util.Date) {
            localDate = ((java.util.Date)sourceObject).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        } else if (sourceObject instanceof Calendar) {
            Calendar cal = (Calendar)sourceObject;
            localDate = LocalDate.of(cal.get(1), cal.get(2) + 1, cal.get(5));
        } else if (sourceObject instanceof Long) {
            localDate = LocalDate.ofEpochDay((Long)sourceObject);
        } else {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME_LDATE);
        }
        return localDate;
    }

    protected LocalTime convertObjectToLocalTime(Object sourceObject) throws ConversionException {
        LocalTime localTime = null;
        if (sourceObject instanceof LocalTime) {
            return (LocalTime)sourceObject;
        }
        if (sourceObject instanceof String) {
            localTime = LocalTime.parse(((String)sourceObject).replace(' ', 'T'), Helper.getDefaultDateTimeFormatter());
        } else if (sourceObject instanceof Timestamp) {
            localTime = ((Timestamp)sourceObject).toLocalDateTime().toLocalTime();
        } else if (sourceObject instanceof Time) {
            localTime = ((Time)sourceObject).toLocalTime();
        } else if (sourceObject instanceof java.util.Date) {
            Calendar cal = Helper.allocateCalendar();
            cal.setTime((java.util.Date)sourceObject);
            localTime = LocalTime.of(cal.get(11), cal.get(12), cal.get(13), cal.get(14));
            Helper.releaseCalendar(cal);
        } else if (sourceObject instanceof Calendar) {
            Calendar cal = (Calendar)sourceObject;
            localTime = LocalTime.of(cal.get(11), cal.get(12), cal.get(13), cal.get(14));
        } else if (sourceObject instanceof Long) {
            localTime = LocalTime.ofSecondOfDay((Long)sourceObject);
        } else {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME_LTIME);
        }
        return localTime;
    }

    protected LocalDateTime convertObjectToLocalDateTime(Object sourceObject) throws ConversionException {
        LocalDateTime localDateTime = null;
        if (sourceObject instanceof LocalDateTime) {
            return (LocalDateTime)sourceObject;
        }
        if (sourceObject instanceof String) {
            localDateTime = LocalDateTime.parse(((String)sourceObject).replace(' ', 'T'), Helper.getDefaultDateTimeFormatter());
        } else if (sourceObject instanceof Timestamp) {
            localDateTime = ((Timestamp)sourceObject).toLocalDateTime();
        } else if (sourceObject instanceof java.util.Date) {
            Calendar cal = Helper.allocateCalendar();
            cal.setTime((java.util.Date)sourceObject);
            localDateTime = LocalDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
            Helper.releaseCalendar(cal);
        } else if (sourceObject instanceof Calendar) {
            Calendar cal = (Calendar)sourceObject;
            localDateTime = LocalDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
        } else if (sourceObject instanceof Long) {
            localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond((Long)sourceObject), ConversionManager.getDefaultZoneOffset());
        } else {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME_LDATETIME);
        }
        return localDateTime;
    }

    protected OffsetDateTime convertObjectToOffsetDateTime(Object sourceObject) throws ConversionException {
        OffsetDateTime offsetDateTime = null;
        if (sourceObject instanceof OffsetDateTime) {
            return (OffsetDateTime)sourceObject;
        }
        if (sourceObject instanceof String) {
            LocalDateTime ldt = LocalDateTime.parse(((String)sourceObject).replace(' ', 'T'), Helper.getDefaultDateTimeFormatter());
            return ldt.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        }
        if (sourceObject instanceof java.util.Date) {
            Calendar cal = Helper.allocateCalendar();
            cal.setTime((java.util.Date)sourceObject);
            offsetDateTime = OffsetDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000, ZoneOffset.ofTotalSeconds((cal.get(15) + cal.get(16)) / 1000));
            Helper.releaseCalendar(cal);
        } else if (sourceObject instanceof Calendar) {
            Calendar cal = (Calendar)sourceObject;
            offsetDateTime = OffsetDateTime.of(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14) * 1000000, ZoneOffset.ofTotalSeconds((cal.get(15) + cal.get(16)) / 1000));
        } else if (sourceObject instanceof Long) {
            offsetDateTime = OffsetDateTime.ofInstant(Instant.ofEpochSecond((Long)sourceObject), ConversionManager.getDefaultZoneOffset());
        } else {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME_ODATETIME);
        }
        return offsetDateTime;
    }

    protected OffsetTime convertObjectToOffsetTime(Object sourceObject) throws ConversionException {
        OffsetTime offsetTime = null;
        if (sourceObject instanceof OffsetTime) {
            return (OffsetTime)sourceObject;
        }
        if (sourceObject instanceof String) {
            try {
                offsetTime = OffsetTime.parse(((String)sourceObject).replace(' ', 'T'), Helper.getDefaultDateTimeFormatter());
            }
            catch (Exception e) {
                LocalTime localTime = LocalTime.parse(((String)sourceObject).replace(' ', 'T'), Helper.getDefaultDateTimeFormatter());
                offsetTime = OffsetTime.of(localTime, OffsetDateTime.now().getOffset());
            }
        } else if (sourceObject instanceof java.util.Date) {
            Calendar cal = Helper.allocateCalendar();
            cal.setTime((java.util.Date)sourceObject);
            offsetTime = OffsetTime.of(cal.get(11), cal.get(12), cal.get(13), cal.get(14), ZoneOffset.ofTotalSeconds((cal.get(15) + cal.get(16)) / 1000));
            Helper.releaseCalendar(cal);
        } else if (sourceObject instanceof Calendar) {
            Calendar cal = (Calendar)sourceObject;
            offsetTime = OffsetTime.of(cal.get(11), cal.get(12), cal.get(13), cal.get(14), ZoneOffset.ofTotalSeconds((cal.get(15) + cal.get(16)) / 1000));
        } else if (sourceObject instanceof Long) {
            offsetTime = OffsetTime.ofInstant(Instant.ofEpochSecond((Long)sourceObject), ConversionManager.getDefaultZoneOffset());
        } else {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME_OTIME);
        }
        return offsetTime;
    }

    protected Year convertObjectToYear(Object sourceObject) throws ConversionException {
        Year year = null;
        if (sourceObject instanceof Year) {
            return (Year)sourceObject;
        }
        if (sourceObject instanceof String) {
            try {
                year = Year.of(Integer.valueOf((String)sourceObject));
            }
            catch (Exception e) {
                throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME_YEAR);
            }
        } else if (sourceObject instanceof java.util.Date) {
            Calendar cal = Helper.allocateCalendar();
            cal.setTime((java.util.Date)sourceObject);
            year = Year.of(cal.get(1));
            Helper.releaseCalendar(cal);
        } else if (sourceObject instanceof Calendar) {
            Calendar cal = (Calendar)sourceObject;
            year = Year.of(cal.get(1));
        } else if (sourceObject instanceof Integer) {
            year = Year.of((Integer)sourceObject);
        } else if (sourceObject instanceof Long) {
            year = Year.of(((Long)sourceObject).intValue());
        } else {
            throw ConversionException.couldNotBeConverted(sourceObject, ClassConstants.TIME_OTIME);
        }
        return year;
    }

    protected URL convertObjectToUrl(Object sourceObject) throws ConversionException {
        if (sourceObject.getClass() == CoreClassConstants.URL_Class) {
            return (URL)sourceObject;
        }
        if (sourceObject.getClass() == CoreClassConstants.STRING) {
            try {
                return new URL((String)sourceObject);
            }
            catch (Exception e) {
                throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.URL_Class, e);
            }
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.URL_Class);
    }

    protected UUID convertObjectToUUID(Object sourceObject) throws ConversionException {
        if (sourceObject.getClass() == CoreClassConstants.UUID) {
            return (UUID)sourceObject;
        }
        if (sourceObject.getClass() == CoreClassConstants.STRING) {
            try {
                return UUID.fromString((String)sourceObject);
            }
            catch (Exception e) {
                throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.UUID, e);
            }
        }
        throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.UUID);
    }

    protected java.util.Date convertObjectToUtilDate(Object sourceObject) throws ConversionException {
        java.util.Date date = null;
        if (sourceObject.getClass() == java.util.Date.class) {
            date = (java.util.Date)sourceObject;
        } else if (sourceObject instanceof Date) {
            date = Helper.utilDateFromSQLDate((Date)sourceObject);
        } else if (sourceObject instanceof Time) {
            date = Helper.utilDateFromTime((Time)sourceObject);
        } else if (sourceObject instanceof String) {
            date = Helper.utilDateFromTimestamp(Helper.timestampFromString((String)sourceObject));
        } else if (sourceObject instanceof Timestamp) {
            date = Helper.utilDateFromTimestamp((Timestamp)sourceObject);
        } else {
            if (sourceObject instanceof Calendar) {
                return ((Calendar)sourceObject).getTime();
            }
            if (sourceObject instanceof Long) {
                date = Helper.utilDateFromLong((Long)sourceObject);
            } else if (sourceObject instanceof java.util.Date) {
                date = new java.util.Date(((java.util.Date)sourceObject).getTime());
            } else if (sourceObject instanceof LocalDateTime) {
                date = Helper.utilDateFromTimestamp(Timestamp.valueOf((LocalDateTime)sourceObject));
            } else {
                throw ConversionException.couldNotBeConverted(sourceObject, CoreClassConstants.UTILDATE);
            }
        }
        return date;
    }

    public <T> Class<T> convertClassNameToClass(String className) throws ConversionException {
        return this.convertObjectToClass(className);
    }

    public static ConversionManager getDefaultManager() {
        if (defaultManager == null) {
            ConversionManager.setDefaultManager(new ConversionManager());
            defaultManager.setShouldUseClassLoaderFromCurrentThread(true);
        }
        return defaultManager;
    }

    public <T> T getDefaultNullValue(Class<T> theClass) {
        if (this.defaultNullValues == null) {
            return null;
        }
        return (T)this.getDefaultNullValues().get(theClass);
    }

    public Map<Class<?>, Object> getDefaultNullValues() {
        return this.defaultNullValues;
    }

    @Override
    public ClassLoader getLoader() {
        if (this.shouldUseClassLoaderFromCurrentThread()) {
            return PrivilegedAccessHelper.callDoPrivileged(() -> PrivilegedAccessHelper.getContextClassLoader(Thread.currentThread()));
        }
        if (this.loader == null) {
            if (defaultLoader == null) {
                ClassLoader loader = PrivilegedAccessHelper.callDoPrivileged(() -> PrivilegedAccessHelper.getClassLoaderForClass(ClassConstants.ConversionManager_Class));
                this.setLoader(loader);
            } else {
                this.setLoader(ConversionManager.getDefaultLoader());
            }
        }
        return this.loader;
    }

    public boolean hasDefaultNullValues() {
        return this.defaultNullValues != null;
    }

    public static <T> Class<T> loadClass(String className) {
        return ConversionManager.getDefaultManager().convertObject(className, CoreClassConstants.CLASS);
    }

    public static <T> Class<T> getObjectClass(Class<?> javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (javaClass.isPrimitive()) {
            if (javaClass == CoreClassConstants.PCHAR) {
                return CoreClassConstants.CHAR;
            }
            if (javaClass == CoreClassConstants.PINT) {
                return CoreClassConstants.INTEGER;
            }
            if (javaClass == CoreClassConstants.PDOUBLE) {
                return CoreClassConstants.DOUBLE;
            }
            if (javaClass == CoreClassConstants.PFLOAT) {
                return CoreClassConstants.FLOAT;
            }
            if (javaClass == CoreClassConstants.PLONG) {
                return CoreClassConstants.LONG;
            }
            if (javaClass == CoreClassConstants.PSHORT) {
                return CoreClassConstants.SHORT;
            }
            if (javaClass == CoreClassConstants.PBYTE) {
                return CoreClassConstants.BYTE;
            }
            if (javaClass == CoreClassConstants.PBOOLEAN) {
                return CoreClassConstants.BOOLEAN;
            }
        } else {
            if (javaClass == CoreClassConstants.APBYTE) {
                return CoreClassConstants.APBYTE;
            }
            if (javaClass == CoreClassConstants.APCHAR) {
                return CoreClassConstants.APCHAR;
            }
            return javaClass;
        }
        return javaClass;
    }

    public static <T> Class<T> getPrimitiveClass(String classType) {
        return switch (classType) {
            case "int" -> Integer.TYPE;
            case "boolean" -> Boolean.TYPE;
            case "char" -> Character.TYPE;
            case "short" -> Short.TYPE;
            case "byte" -> Byte.TYPE;
            case "float" -> Float.TYPE;
            case "double" -> Double.TYPE;
            case "long" -> Long.TYPE;
            default -> null;
        };
    }

    public static void setDefaultManager(ConversionManager theManager) {
        defaultManager = theManager;
    }

    public void setDefaultNullValue(Class<?> theClass, Object theValue) {
        if (this.defaultNullValues == null) {
            this.defaultNullValues = new HashMap(5);
        }
        this.getDefaultNullValues().put(theClass, theValue);
    }

    public void setDefaultNullValues(Map<Class<?>, Object> defaultNullValues) {
        this.defaultNullValues = defaultNullValues;
    }

    public void setLoader(ClassLoader classLoader) {
        this.shouldUseClassLoaderFromCurrentThread = false;
        this.loader = classLoader;
    }

    public static void setDefaultLoader(ClassLoader classLoader) {
        defaultLoader = classLoader;
    }

    public static ClassLoader getDefaultLoader() {
        return defaultLoader;
    }

    public void setShouldUseClassLoaderFromCurrentThread(boolean useCurrentThread) {
        this.shouldUseClassLoaderFromCurrentThread = useCurrentThread;
    }

    public boolean shouldUseClassLoaderFromCurrentThread() {
        return this.shouldUseClassLoaderFromCurrentThread;
    }

    public List<Class<?>> getDataTypesConvertedFrom(Class<?> javaClass) {
        if (this.dataTypesConvertedFromAClass.isEmpty()) {
            this.buildDataTypesConvertedFromAClass();
        }
        return this.dataTypesConvertedFromAClass.get(javaClass);
    }

    public List<Class<?>> getDataTypesConvertedTo(Class<?> javaClass) {
        if (this.dataTypesConvertedToAClass.isEmpty()) {
            this.buildDataTypesConvertedToAClass();
        }
        return this.dataTypesConvertedToAClass.get(javaClass);
    }

    protected List<Class<?>> buildNumberVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(BigInteger.class);
        vec.add(BigDecimal.class);
        vec.add(Byte.class);
        vec.add(Double.class);
        vec.add(Float.class);
        vec.add(Integer.class);
        vec.add(Long.class);
        vec.add(Short.class);
        vec.add(Number.class);
        return vec;
    }

    protected List<Class<?>> buildDateTimeVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(java.util.Date.class);
        vec.add(Timestamp.class);
        vec.add(Calendar.class);
        return vec;
    }

    protected void buildDataTypesConvertedFromAClass() {
        this.dataTypesConvertedFromAClass.put(BigDecimal.class, this.buildFromBigDecimalVec());
        this.dataTypesConvertedFromAClass.put(BigInteger.class, this.buildFromBigIntegerVec());
        this.dataTypesConvertedFromAClass.put(Blob.class, this.buildFromBlobVec());
        this.dataTypesConvertedFromAClass.put(Boolean.class, this.buildFromBooleanVec());
        this.dataTypesConvertedFromAClass.put(byte[].class, this.buildFromByteArrayVec());
        this.dataTypesConvertedFromAClass.put(Byte.class, this.buildFromByteVec());
        this.dataTypesConvertedFromAClass.put(Calendar.class, this.buildFromCalendarVec());
        this.dataTypesConvertedFromAClass.put(Character.class, this.buildFromCharacterVec());
        this.dataTypesConvertedFromAClass.put(Clob.class, this.buildFromClobVec());
        this.dataTypesConvertedFromAClass.put(Date.class, this.buildFromDateVec());
        this.dataTypesConvertedFromAClass.put(Double.class, this.buildFromDoubleVec());
        this.dataTypesConvertedFromAClass.put(Float.class, this.buildFromFloatVec());
        this.dataTypesConvertedFromAClass.put(Integer.class, this.buildFromIntegerVec());
        this.dataTypesConvertedFromAClass.put(Long.class, this.buildFromLongVec());
        this.dataTypesConvertedFromAClass.put(Number.class, this.buildFromNumberVec());
        this.dataTypesConvertedFromAClass.put(Short.class, this.buildFromShortVec());
        this.dataTypesConvertedFromAClass.put(String.class, this.buildFromStringVec());
        this.dataTypesConvertedFromAClass.put(Timestamp.class, this.buildFromTimestampVec());
        this.dataTypesConvertedFromAClass.put(Time.class, this.buildFromTimeVec());
        this.dataTypesConvertedFromAClass.put(java.util.Date.class, this.buildFromUtilDateVec());
        this.dataTypesConvertedFromAClass.put(Byte[].class, this.buildFromByteObjectArraryVec());
        this.dataTypesConvertedFromAClass.put(char[].class, this.buildFromCharArrayVec());
        this.dataTypesConvertedFromAClass.put(Character[].class, this.buildFromCharacterArrayVec());
    }

    protected List<Class<?>> buildFromBooleanVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(String.class);
        vec.add(Boolean.class);
        vec.add(Integer.class);
        vec.add(Long.class);
        vec.add(Short.class);
        vec.add(Number.class);
        vec.add(Character[].class);
        vec.add(char[].class);
        vec.add(Boolean.TYPE);
        vec.add(Integer.TYPE);
        vec.add(Long.TYPE);
        vec.add(Short.TYPE);
        return vec;
    }

    protected List<Class<?>> buildFromNumberVec() {
        List<Class<?>> vec = this.buildNumberVec();
        vec.add(String.class);
        vec.add(Character.class);
        vec.add(Boolean.class);
        vec.add(Character[].class);
        vec.add(char[].class);
        vec.add(Character.TYPE);
        vec.add(Integer.TYPE);
        vec.add(Double.TYPE);
        vec.add(Float.TYPE);
        vec.add(Long.TYPE);
        vec.add(Short.TYPE);
        vec.add(Byte.TYPE);
        vec.add(Boolean.TYPE);
        return vec;
    }

    protected List<Class<?>> buildFromBigDecimalVec() {
        return this.buildFromNumberVec();
    }

    protected List<Class<?>> buildFromBigIntegerVec() {
        return this.buildFromNumberVec();
    }

    protected List<Class<?>> buildFromIntegerVec() {
        return this.buildFromNumberVec();
    }

    protected List<Class<?>> buildFromFloatVec() {
        return this.buildFromNumberVec();
    }

    protected List<Class<?>> buildFromDoubleVec() {
        return this.buildFromNumberVec();
    }

    protected List<Class<?>> buildFromShortVec() {
        return this.buildFromNumberVec();
    }

    protected List<Class<?>> buildFromByteVec() {
        return this.buildFromNumberVec();
    }

    protected List<Class<?>> buildFromLongVec() {
        List<Class<?>> vec = this.buildFromNumberVec();
        vec.addAll(this.buildDateTimeVec());
        vec.add(Date.class);
        vec.add(Time.class);
        return vec;
    }

    protected List<Class<?>> buildFromStringVec() {
        List<Class<?>> vec = this.buildFromLongVec();
        vec.add(Byte[].class);
        vec.add(byte[].class);
        vec.add(Clob.class);
        return vec;
    }

    protected List<Class<?>> buildFromCharacterVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(String.class);
        vec.add(Boolean.class);
        vec.add(Character[].class);
        vec.add(Character.class);
        vec.add(char[].class);
        vec.add(Character.TYPE);
        vec.add(Boolean.TYPE);
        return vec;
    }

    protected List<Class<?>> buildFromByteArrayVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(String.class);
        vec.add(byte[].class);
        vec.add(Byte[].class);
        vec.add(Character[].class);
        vec.add(char[].class);
        return vec;
    }

    protected List<Class<?>> buildFromClobVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(String.class);
        vec.add(Character[].class);
        vec.add(char[].class);
        return vec;
    }

    protected List<Class<?>> buildFromBlobVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(String.class);
        vec.add(Byte[].class);
        vec.add(byte[].class);
        vec.add(Character[].class);
        vec.add(char[].class);
        return vec;
    }

    protected List<Class<?>> buildFromUtilDateVec() {
        List<Class<?>> vec = this.buildDateTimeVec();
        vec.add(String.class);
        vec.add(Long.class);
        vec.add(Date.class);
        vec.add(Time.class);
        vec.add(Long.TYPE);
        vec.add(Character[].class);
        vec.add(char[].class);
        return vec;
    }

    protected List<Class<?>> buildFromTimestampVec() {
        return this.buildFromUtilDateVec();
    }

    protected List<Class<?>> buildFromCalendarVec() {
        return this.buildFromUtilDateVec();
    }

    protected List<Class<?>> buildFromDateVec() {
        List<Class<?>> vec = this.buildDateTimeVec();
        vec.add(String.class);
        vec.add(Long.class);
        vec.add(Date.class);
        vec.add(Long.TYPE);
        vec.add(Character[].class);
        vec.add(char[].class);
        return vec;
    }

    protected List<Class<?>> buildFromTimeVec() {
        List<Class<?>> vec = this.buildDateTimeVec();
        vec.add(String.class);
        vec.add(Long.class);
        vec.add(Time.class);
        vec.add(Long.TYPE);
        vec.add(Character[].class);
        vec.add(char[].class);
        return vec;
    }

    protected List<Class<?>> buildFromByteObjectArraryVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(Blob.class);
        vec.add(byte[].class);
        return vec;
    }

    protected List<Class<?>> buildFromCharArrayVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(Clob.class);
        return vec;
    }

    protected List<Class<?>> buildFromCharacterArrayVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(Clob.class);
        return vec;
    }

    protected void buildDataTypesConvertedToAClass() {
        this.dataTypesConvertedToAClass.put(BigDecimal.class, this.buildToBigDecimalVec());
        this.dataTypesConvertedToAClass.put(BigInteger.class, this.buildToBigIntegerVec());
        this.dataTypesConvertedToAClass.put(Boolean.class, this.buildToBooleanVec());
        this.dataTypesConvertedToAClass.put(Byte.class, this.buildToByteVec());
        this.dataTypesConvertedToAClass.put(byte[].class, this.buildToByteArrayVec());
        this.dataTypesConvertedToAClass.put(Byte[].class, this.buildToByteObjectArrayVec());
        this.dataTypesConvertedToAClass.put(Calendar.class, this.buildToCalendarVec());
        this.dataTypesConvertedToAClass.put(Character.class, this.buildToCharacterVec());
        this.dataTypesConvertedToAClass.put(Character[].class, this.buildToCharacterArrayVec());
        this.dataTypesConvertedToAClass.put(char[].class, this.buildToCharArrayVec());
        this.dataTypesConvertedToAClass.put(Date.class, this.buildToDateVec());
        this.dataTypesConvertedToAClass.put(Double.class, this.buildToDoubleVec());
        this.dataTypesConvertedToAClass.put(Float.class, this.buildToFloatVec());
        this.dataTypesConvertedToAClass.put(Integer.class, this.buildToIntegerVec());
        this.dataTypesConvertedToAClass.put(Long.class, this.buildToLongVec());
        this.dataTypesConvertedToAClass.put(Number.class, this.buildToNumberVec());
        this.dataTypesConvertedToAClass.put(Short.class, this.buildToShortVec());
        this.dataTypesConvertedToAClass.put(String.class, this.buildToStringVec());
        this.dataTypesConvertedToAClass.put(Timestamp.class, this.buildToTimestampVec());
        this.dataTypesConvertedToAClass.put(Time.class, this.buildToTimeVec());
        this.dataTypesConvertedToAClass.put(java.util.Date.class, this.buildToUtilDateVec());
        this.dataTypesConvertedToAClass.put(Clob.class, this.buildToClobVec());
        this.dataTypesConvertedToAClass.put(Blob.class, this.buildToBlobVec());
    }

    protected List<Class<?>> buildAllTypesToAClassVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(String.class);
        vec.add(Integer.class);
        vec.add(java.util.Date.class);
        vec.add(Date.class);
        vec.add(Time.class);
        vec.add(Timestamp.class);
        vec.add(Calendar.class);
        vec.add(Character.class);
        vec.add(Double.class);
        vec.add(Float.class);
        vec.add(Long.class);
        vec.add(Short.class);
        vec.add(Byte.class);
        vec.add(BigInteger.class);
        vec.add(BigDecimal.class);
        vec.add(Number.class);
        vec.add(Boolean.class);
        vec.add(Character[].class);
        vec.add(Blob.class);
        vec.add(Clob.class);
        return vec;
    }

    protected List<Class<?>> buildToBigDecimalVec() {
        List<Class<?>> vec = this.buildNumberVec();
        vec.add(String.class);
        return vec;
    }

    protected List<Class<?>> buildToBigIntegerVec() {
        return this.buildToBigDecimalVec();
    }

    protected List<Class<?>> buildToBooleanVec() {
        List<Class<?>> vec = this.buildToBigDecimalVec();
        vec.add(Character.class);
        vec.add(Boolean.class);
        return vec;
    }

    protected List<Class<?>> buildToByteVec() {
        return this.buildToBigDecimalVec();
    }

    protected List<Class<?>> buildToDoubleVec() {
        return this.buildToBigDecimalVec();
    }

    protected List<Class<?>> buildToFloatVec() {
        return this.buildToBigDecimalVec();
    }

    protected List<Class<?>> buildToIntegerVec() {
        List<Class<?>> vec = this.buildToBigDecimalVec();
        vec.add(Boolean.class);
        return vec;
    }

    protected List<Class<?>> buildToLongVec() {
        List<Class<?>> vec = this.buildToIntegerVec();
        vec.add(Calendar.class);
        vec.add(java.util.Date.class);
        return vec;
    }

    protected List<Class<?>> buildToNumberVec() {
        return this.buildToIntegerVec();
    }

    protected List<Class<?>> buildToShortVec() {
        return this.buildToIntegerVec();
    }

    protected List<Class<?>> buildToByteArrayVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(String.class);
        vec.add(Blob.class);
        vec.add(byte[].class);
        vec.add(Byte[].class);
        return vec;
    }

    protected List<Class<?>> buildToByteObjectArrayVec() {
        List<Class<?>> vec = this.buildToByteArrayVec();
        vec.add(Byte[].class);
        return vec;
    }

    protected List<Class<?>> buildToCharacterVec() {
        List<Class<?>> vec = this.buildToBigDecimalVec();
        vec.add(Character.class);
        return vec;
    }

    protected List<Class<?>> buildToCharacterArrayVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected List<Class<?>> buildToCharArrayVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected List<Class<?>> buildToStringVec() {
        return this.buildAllTypesToAClassVec();
    }

    protected List<Class<?>> buildToCalendarVec() {
        List<Class<?>> vec = this.buildDateTimeVec();
        vec.add(String.class);
        vec.add(Long.class);
        vec.add(Date.class);
        vec.add(Time.class);
        return vec;
    }

    protected List<Class<?>> buildToTimestampVec() {
        return this.buildToCalendarVec();
    }

    protected List<Class<?>> buildToUtilDateVec() {
        return this.buildToCalendarVec();
    }

    protected List<Class<?>> buildToDateVec() {
        List<Class<?>> vec = this.buildDateTimeVec();
        vec.add(String.class);
        vec.add(Long.class);
        vec.add(Date.class);
        return vec;
    }

    protected List<Class<?>> buildToTimeVec() {
        List<Class<?>> vec = this.buildDateTimeVec();
        vec.add(String.class);
        vec.add(Long.class);
        vec.add(Time.class);
        return vec;
    }

    protected List<Class<?>> buildToBlobVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(Byte[].class);
        vec.add(byte[].class);
        return vec;
    }

    protected List<Class<?>> buildToClobVec() {
        CopyOnWriteArrayList vec = new CopyOnWriteArrayList();
        vec.add(String.class);
        vec.add(char[].class);
        vec.add(Character[].class);
        return vec;
    }
}

