/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.common.iiop.security;

import com.sun.enterprise.common.iiop.security.GSSUtilsContract;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.common.Util;
import java.lang.annotation.Annotation;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GSSUPName {
    private static Logger _logger = null;
    public static final char AT_CHAR = '@';
    public static final String AT_STRING = "@";
    public static final char ESCAPE_CHAR = '\\';
    public static final String ESCAPE_STRING = "\\";
    private String username;
    private String realm;
    private GSSUtilsContract gssUtils;

    public GSSUPName(String username, String realm) {
        this.username = username;
        this.realm = realm;
        this.gssUtils = (GSSUtilsContract)Util.getDefaultHabitat().getService(GSSUtilsContract.class, new Annotation[0]);
    }

    public GSSUPName(byte[] GSSExportedName) {
        int realm_index = 0;
        int user_index = -1;
        String expname = "";
        String name_value = "";
        String name_scope = "";
        byte[] exportedname = null;
        this.gssUtils = (GSSUtilsContract)Util.getDefaultHabitat().getService(GSSUtilsContract.class, new Annotation[0]);
        assert (this.gssUtils != null);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Attempting to create a mechanism specific name from the exported name.");
        }
        try {
            exportedname = this.gssUtils.importName(this.gssUtils.GSSUP_MECH_OID(), GSSExportedName);
            expname = new String(exportedname, "UTF8");
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "NCLS-SECURITY-05300", e.getLocalizedMessage());
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Mechanism specific name: " + expname);
        }
        int at_index = expname.indexOf(64);
        int esc_index = expname.indexOf(92);
        if (at_index == -1) {
            name_value = expname;
        } else if (esc_index == -1) {
            if (at_index != 0) {
                name_value = expname.substring(0, at_index);
            }
            name_scope = expname.substring(at_index + 1);
        } else {
            user_index = 0;
            realm_index = 0;
            int i = 0;
            while ((i = expname.indexOf(64, i)) != -1) {
                if (expname.charAt(i - 1) != '\\') {
                    realm_index = i;
                    break;
                }
                ++i;
            }
            name_value = expname.substring(user_index, realm_index);
            name_scope = expname.substring(realm_index + 1);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "name_value: " + name_value + " ;  name_scope: " + name_scope);
        }
        if (name_value.length() > 0 && at_index != -1) {
            StringBuilder strbuf = new StringBuilder("");
            int starti = 0;
            int endi = 0;
            while ((endi = name_value.indexOf(92, starti)) != -1) {
                strbuf.append(name_value.substring(starti, endi));
                starti = endi + 1;
            }
            strbuf.append(name_value.substring(starti));
            name_value = strbuf.toString();
        }
        this.username = name_value;
        this.realm = name_scope;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Constructed GSSUPName ( " + this.toString() + " )");
        }
    }

    public byte[] getExportedName() {
        byte[] expname = new byte[]{};
        byte[] expname_utf8 = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Going to create exported name for:" + this.toString());
        }
        StringBuffer strbuf = new StringBuffer("");
        int at_index = this.username.indexOf(64);
        int esc_index = this.username.indexOf(92);
        if (at_index == -1 && esc_index == -1) {
            strbuf = new StringBuffer(this.username);
        } else {
            StringTokenizer strtok;
            if (esc_index != -1) {
                strtok = new StringTokenizer(this.username, ESCAPE_STRING);
                while (strtok.hasMoreTokens()) {
                    strbuf.append(strtok.nextToken());
                    strbuf.append('\\').append('\\');
                }
            }
            if (at_index != -1) {
                strtok = new StringTokenizer(this.username, AT_STRING);
                while (strtok.hasMoreTokens()) {
                    strbuf.append(strtok.nextToken());
                    strbuf.append('\\').append('@');
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "username after processing for @ and \\: " + String.valueOf(strbuf));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "username and realm name : " + String.valueOf(strbuf));
        }
        try {
            expname_utf8 = strbuf.toString().getBytes("UTF8");
            assert (this.gssUtils != null);
            expname = this.gssUtils.createExportedName(this.gssUtils.GSSUP_MECH_OID(), expname_utf8);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "NCLS-SECURITY-05301", e.getLocalizedMessage());
        }
        if (_logger.isLoggable(Level.FINE)) {
            assert (this.gssUtils != null);
            _logger.log(Level.FINE, "GSSUPName in exported format = " + this.gssUtils.dumpHex(expname));
        }
        return expname;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUser() {
        return this.username;
    }

    public boolean equals(Object o) {
        GSSUPName nm;
        return o instanceof GSSUPName && (nm = (GSSUPName)o).getUser().equals(this.username) && nm.getRealm().equals(this.realm);
    }

    public int hashCode() {
        return this.username.hashCode() + this.realm.hashCode();
    }

    public String toString() {
        String s = "Username = " + this.username;
        s = s + " Realm = " + this.realm;
        return s;
    }

    private static void testGSSUP(String user, String realm) {
        _logger.log(Level.FINE, "Running unit test for TestGSSUPName.");
        _logger.log(Level.FINE, "Creating a GSSUPName instance");
        GSSUPName gssname = new GSSUPName(user, realm);
        _logger.log(Level.FINE, "GSSUPName : " + gssname.toString());
        _logger.log(Level.FINE, "Obtaining an exported name form");
        byte[] expname = gssname.getExportedName();
        _logger.log(Level.FINE, "Creating a GSSUPName instance from exported name");
        GSSUPName gssname1 = new GSSUPName(expname);
        _logger.log(Level.FINE, "GSSUPName created from exported name: " + gssname1.toString());
    }

    public static void main(String[] args) {
        GSSUPName.testGSSUP("sekhar@vajjha@la@", "sun.com");
        GSSUPName.testGSSUP("sekhar", "sun.com");
        GSSUPName.testGSSUP("sekhar", "");
        GSSUPName.testGSSUP("", "sun.com");
    }

    static {
        _logger = SecurityLoggerInfo.getLogger();
    }
}

