/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.commands;

import com.sun.enterprise.config.serverbeans.Domain;
import org.glassfish.api.ActionReport;
import org.glassfish.security.services.config.SecurityConfiguration;
import org.glassfish.security.services.config.SecurityConfigurations;
import org.glassfish.security.services.config.SecurityProvider;

public class CLIUtil {
    public static SecurityConfiguration findSecurityConfiguration(Domain domain, String serviceName, ActionReport report) {
        SecurityConfigurations secConfigs = (SecurityConfigurations)domain.getExtensionByType(SecurityConfigurations.class);
        if (secConfigs == null) {
            report.setMessage("Unable to locate security configurations");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        SecurityConfiguration ssc = secConfigs.getSecurityServiceByName(serviceName);
        if (ssc == null) {
            report.setMessage("Unable to locate security service: " + serviceName);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        return ssc;
    }

    public static SecurityProvider findSecurityProvider(Domain domain, String serviceName, String providerName, ActionReport report) {
        SecurityConfiguration sc = CLIUtil.findSecurityConfiguration(domain, serviceName, report);
        if (sc == null) {
            return null;
        }
        SecurityProvider provider = sc.getSecurityProviderByName(providerName);
        if (provider == null) {
            report.setMessage("Unable to locate security provider: " + providerName);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        return provider;
    }
}

