/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.LocalTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.BaseTransactionManager;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransaction1PCommitEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransaction2PCompleteEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransaction2PPrepareEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.LocalTransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionEvent;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.HashSet;

public class LocalTransactionManager
extends BaseTransactionManager {
    LocalTransactionManager(TransactionLogManager transactionLogManager) {
        super(transactionLogManager);
    }

    @Override
    void processStoredTxnOnStartup(BaseTransaction baseTxn) {
        int state;
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " processStoredTxnOnStartup " + String.valueOf(baseTxn);
            logger.log(4, msg);
        }
        if ((state = baseTxn.getState()) == 6 || state == 7) {
            this.addToCompleteStored(baseTxn);
        } else if (state == 5) {
            this.addToIncompleteStored(baseTxn);
        }
    }

    @Override
    void replayTransactionEvent(TransactionEvent txnEvent, HashSet dstLoadedSet) throws BrokerException, IOException {
        if (Store.getDEBUG()) {
            Globals.getLogger().log(4, this.getPrefix() + " replayTransactionEvent");
        }
        LocalTransactionEvent localTxnEvent = (LocalTransactionEvent)txnEvent;
        LocalTransaction localTxn = localTxnEvent.localTransaction;
        int state = localTxn.getState();
        TransactionUID tid = localTxn.getTid();
        if (localTxnEvent.getSubType() == 0) {
            this.transactionLogManager.transactionLogReplayer.replayTransactionWork(localTxn.getTransactionWork(), tid, dstLoadedSet);
        } else if (localTxnEvent.getSubType() == 1) {
            if (this.incompleteStored.containsKey(tid)) {
                if (Store.getDEBUG()) {
                    String msg = this.getPrefix() + " found matching txn in prepared store on replay " + String.valueOf(localTxn);
                    Globals.getLogger().log(4, msg);
                }
            } else {
                this.addToIncompleteUnstored(localTxn);
            }
        } else if (localTxnEvent.getSubType() == 2) {
            BaseTransaction existingWork = null;
            if (this.incompleteUnstored.containsKey(tid)) {
                existingWork = this.removeFromIncompleteUnstored(tid);
            } else if (this.incompleteStored.containsKey(tid)) {
                existingWork = this.removeFromIncompleteStored(tid);
                this.updateStoredState(tid, state);
                this.addToCompleteStored(existingWork);
            } else if (this.completeStored.containsKey(tid)) {
                existingWork = (BaseTransaction)this.completeStored.get(tid);
            }
            if (existingWork != null) {
                if (state == 6) {
                    this.transactionLogManager.transactionLogReplayer.replayTransactionWork(existingWork.getTransactionWork(), tid, dstLoadedSet);
                }
            } else {
                logger.log(32, "Could not find prepared work for completing two-phase transaction " + String.valueOf(localTxn.getTid()));
            }
        }
    }

    @Override
    TransactionEvent generateEvent(BaseTransaction baseTxn, boolean completion) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " generateEvent " + String.valueOf(baseTxn);
            logger.log(4, msg);
        }
        LocalTransactionEvent result = null;
        if (completion) {
            result = new LocalTransaction2PCompleteEvent();
        } else if (baseTxn.getState() == 6) {
            result = new LocalTransaction1PCommitEvent();
        } else if (baseTxn.getState() == 5) {
            result = new LocalTransaction2PPrepareEvent();
        }
        result.localTransaction = (LocalTransaction)baseTxn;
        return result;
    }

    @Override
    void processTxn(BaseTransaction baseTxn) throws IOException, BrokerException {
        int state;
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " processTxn " + String.valueOf(baseTxn);
            logger.log(4, msg);
        }
        if ((state = baseTxn.getState()) == 6) {
            this.playingToMessageStore.add(baseTxn.getTid());
            this.messageListLogged(baseTxn);
        } else if (state == 5) {
            this.addToIncompleteUnstored(baseTxn);
        }
    }

    @Override
    BaseTransaction processTxnCompletion(TransactionUID tid, int state) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " processTxnCompletion " + String.valueOf(tid);
            logger.log(4, msg);
        }
        boolean removeFromStore = true;
        return this.processTxnCompletion(tid, state, removeFromStore);
    }

    @Override
    String getPrefix() {
        return "LocalTransactionManager: " + Thread.currentThread().getName();
    }
}

