/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import java.net.InetAddress;
import java.util.Collection;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.grizzly.http.server.HttpHandler;

public abstract class Endpoint {
    public static Endpoint createEndpoint(Adapter adapter) {
        return new AdapterEndpoint(adapter);
    }

    public abstract InetAddress getAddress();

    public abstract int getPort();

    public abstract String getContextRoot();

    public abstract HttpHandler getEndpointHandler();

    public abstract Collection<String> getVirtualServers();

    public abstract ApplicationContainer getContainer();

    private static class AdapterEndpoint
    extends Endpoint {
        private final Adapter adapter;

        public AdapterEndpoint(Adapter adapter) {
            this.adapter = adapter;
        }

        @Override
        public InetAddress getAddress() {
            return this.adapter.getListenAddress();
        }

        @Override
        public int getPort() {
            return this.adapter.getListenPort();
        }

        @Override
        public String getContextRoot() {
            return this.adapter.getContextRoot();
        }

        @Override
        public HttpHandler getEndpointHandler() {
            return this.adapter.getHttpService();
        }

        @Override
        public Collection<String> getVirtualServers() {
            return this.adapter.getVirtualServers();
        }

        @Override
        public ApplicationContainer getContainer() {
            return null;
        }
    }
}

