/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

class AplnExtensionCompatibility {
    private static final Logger LOG = Logger.getLogger(AplnExtensionCompatibility.class.getName());
    private static final String IMPL_CLASS_NAME = "sun.security.ssl.SSLEngineImpl";
    private static final String METHOD_NAME = "setHandshakeApplicationProtocolSelector";
    private static AplnExtensionCompatibility INSTANCE;
    private final boolean protocolSelectorSetterInApi = AplnExtensionCompatibility.isHandshakeSetterInApi();
    private final boolean protocolSelectorSetterInImpl = AplnExtensionCompatibility.isHandshakeSetterInImpl();

    public static synchronized AplnExtensionCompatibility getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AplnExtensionCompatibility();
        }
        return INSTANCE;
    }

    public boolean isAlpnExtensionAvailable() {
        return this.isProtocolSelectorSetterInApi() || this.isProtocolSelectorSetterInImpl();
    }

    public boolean isProtocolSelectorSetterInApi() {
        return this.protocolSelectorSetterInApi;
    }

    public boolean isProtocolSelectorSetterInImpl() {
        return this.protocolSelectorSetterInImpl;
    }

    public Method getProtocolSelectorSetter(SSLEngine engine) {
        Objects.requireNonNull(engine, "engine");
        try {
            Class engineClass = AplnExtensionCompatibility.isHandshakeSetterInApi() ? SSLEngine.class : engine.getClass();
            return engineClass.getMethod(METHOD_NAME, BiFunction.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The method public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> selector) is not declared by the " + engine.getClass().getName() + ".", e);
        }
    }

    private AplnExtensionCompatibility() {
    }

    private static boolean isHandshakeSetterInImpl() {
        try {
            Class.forName(IMPL_CLASS_NAME).getMethod(METHOD_NAME, BiFunction.class);
            return true;
        }
        catch (IllegalAccessError e) {
            LOG.config(() -> "The class sun.security.ssl.SSLEngineImpl is not accessible.");
            return false;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.config(() -> "The class sun.security.ssl.SSLEngineImpl cloud not be found.");
            return false;
        }
        catch (NoSuchMethodException e) {
            LOG.config(() -> "The method public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> selector) is not declared by the sun.security.ssl.SSLEngineImpl class.");
            return false;
        }
    }

    private static boolean isHandshakeSetterInApi() {
        try {
            SSLEngine.class.getMethod(METHOD_NAME, BiFunction.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            LOG.config("The method public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> selector) is not declared by the " + SSLEngine.class.getName() + ".");
            return false;
        }
    }

    public String toString() {
        return super.toString() + "ALPN available: " + this.isAlpnExtensionAvailable() + ", setHandshakeApplicationProtocolSelector in API: " + this.isProtocolSelectorSetterInApi() + ", setHandshakeApplicationProtocolSelector in impl: " + this.isProtocolSelectorSetterInImpl();
    }
}

