/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.builder.api.Prototype;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.config.ConfiguredProvider;
import io.helidon.common.config.NamedService;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ProvidedUtil;
import io.helidon.service.registry.ServiceRegistry;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConfigBuilderSupport {
    private static final String REGEX_REFERENCE = "(?<!\\\\)\\$\\{([^}:]+)(:.+?)?}";
    private static final Pattern PATTERN_REFERENCE = Pattern.compile("(?<!\\\\)\\$\\{([^}:]+)(:.+?)?}");
    private static final String REGEX_BACKSLASH = "\\\\(?=\\$\\{([^}]+)})";
    private static final Pattern PATTERN_BACKSLASH = Pattern.compile("\\\\(?=\\$\\{([^}]+)})");

    private ConfigBuilderSupport() {
    }

    public static <S extends NamedService, T extends ConfiguredProvider<S>> List<S> discoverServices(Config config, String configKey, Optional<ServiceRegistry> serviceRegistry, Class<T> providerType, Class<S> configType, boolean allFromRegistry, List<S> existingValues) {
        return ProvidedUtil.discoverServices(config, configKey, serviceRegistry, providerType, configType, allFromRegistry, existingValues);
    }

    public static <T extends NamedService> Optional<T> discoverService(Config config, String configKey, Optional<ServiceRegistry> serviceRegistry, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, boolean discoverServices, Optional<T> existingValue) {
        return ProvidedUtil.discoverService(config, configKey, serviceRegistry, providerType, configType, discoverServices, existingValue);
    }

    public static <S extends NamedService, T extends ConfiguredProvider<S>> List<S> discoverServices(Config config, String configKey, Class<T> providerType, Class<S> configType, boolean allFromServiceLoader, List<S> existingInstances) {
        return ProvidedUtil.discoverServices(config, configKey, HelidonServiceLoader.create(providerType), providerType, configType, allFromServiceLoader, existingInstances);
    }

    public static <S extends NamedService, T extends ConfiguredProvider<S>> Optional<S> discoverService(Config config, String configKey, Class<T> providerType, Class<S> configType, boolean allFromServiceLoader, Optional<S> existingValue) {
        return ProvidedUtil.discoverService(config, configKey, HelidonServiceLoader.create(providerType), providerType, configType, allFromServiceLoader, existingValue);
    }

    public static String resolveExpression(Config config, String expression) {
        Matcher m = PATTERN_REFERENCE.matcher(expression);
        try {
            StringBuilder sb = new StringBuilder();
            while (m.find()) {
                String configKey = m.group(1);
                String defaultValue = m.group(2);
                if (defaultValue == null) {
                    m.appendReplacement(sb, Matcher.quoteReplacement((String)config.get(configKey).asString().get()));
                    continue;
                }
                defaultValue = defaultValue.substring(1);
                m.appendReplacement(sb, Matcher.quoteReplacement((String)config.get(configKey).asString().orElse(defaultValue)));
            }
            m.appendTail(sb);
            m = PATTERN_BACKSLASH.matcher(sb.toString());
            return m.replaceAll("");
        }
        catch (ConfigException e) {
            throw new ConfigException("Failed to resolve expression: " + expression, e);
        }
    }

    public static interface ConfiguredBuilder<BUILDER, PROTOTYPE>
    extends Prototype.Builder<BUILDER, PROTOTYPE>,
    ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        public BUILDER config(Config var1);
    }
}

