/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.Collection;
import java.util.Properties;
import org.glassfish.api.I18n;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.util.JdbcResourcesUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.glassfish.resources.api.ResourceAttributes;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="jdbc-connection-pool")
@I18n(value="add.resources")
public class JDBCConnectionPoolManager
implements ResourceManager {
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(JDBCConnectionPoolManager.class);
    private String datasourceclassname;
    private String restype;
    private String steadypoolsize = "8";
    private String maxpoolsize = "32";
    private String maxwait = "60000";
    private String poolresize = "2";
    private String idletimeout = "300";
    private String initsql;
    private String isolationlevel;
    private String isisolationguaranteed = Boolean.TRUE.toString();
    private String isconnectvalidatereq = Boolean.FALSE.toString();
    private String validationmethod = "table";
    private String validationtable;
    private String failconnection = Boolean.FALSE.toString();
    private String allownoncomponentcallers = Boolean.FALSE.toString();
    private String nontransactionalconnections = Boolean.FALSE.toString();
    private String validateAtmostOncePeriod = "0";
    private String connectionLeakTimeout = "0";
    private String connectionLeakReclaim = Boolean.FALSE.toString();
    private String connectionCreationRetryAttempts = "0";
    private String connectionCreationRetryInterval = "10";
    private String driverclassname;
    private String sqltracelisteners;
    private String statementTimeout = "-1";
    private String statementcachesize = "0";
    private String lazyConnectionEnlistment = Boolean.FALSE.toString();
    private String lazyConnectionAssociation = Boolean.FALSE.toString();
    private String associateWithThread = Boolean.FALSE.toString();
    private String matchConnections = Boolean.FALSE.toString();
    private String maxConnectionUsageCount = "0";
    private String ping = Boolean.FALSE.toString();
    private String pooling = Boolean.TRUE.toString();
    private String validationclassname;
    private String wrapJDBCObjects = Boolean.TRUE.toString();
    private String description;
    private String jdbcconnectionpoolid;

    public String getResourceType() {
        return "jdbc-connection-pool";
    }

    public ResourceStatus create(Resources resources, ResourceAttributes attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes);
        ResourceStatus validationStatus = this.isValid(resources);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply(param -> this.createResource((Resources)param, properties), (ConfigBeanProxy)resources);
        }
        catch (TransactionFailure tfe) {
            String msg = I18N.getLocalString("create.jdbc.connection.pool.fail", "JDBC connection pool {0} create failed: {1}", new Object[]{this.jdbcconnectionpoolid, tfe.getMessage()});
            return new ResourceStatus(1, msg);
        }
        String msg = I18N.getLocalString("create.jdbc.connection.pool.success", "JDBC connection pool {0} created successfully", new Object[]{this.jdbcconnectionpoolid});
        return new ResourceStatus(0, msg);
    }

    private ResourceStatus isValid(Resources resources) {
        ResourceStatus status = new ResourceStatus(0, "Validation Successful");
        if (this.jdbcconnectionpoolid == null) {
            String msg = I18N.getLocalString("add.resources.noJdbcConnectionPoolId", "No pool name defined for JDBC Connection pool.");
            return new ResourceStatus(1, msg);
        }
        for (ResourcePool pool : resources.getResources(ResourcePool.class)) {
            if (!pool.getName().equals(this.jdbcconnectionpoolid)) continue;
            String msg = I18N.getLocalString("create.jdbc.connection.pool.duplicate", "A resource {0} already exists.", new Object[]{this.jdbcconnectionpoolid});
            return new ResourceStatus(1, msg, true);
        }
        if ("table".equals(this.validationmethod) && Boolean.TRUE.toString().equals(this.isconnectvalidatereq) && this.validationtable == null) {
            String msg = I18N.getLocalString("create.jdbc.connection.pool.validationtable_required", "--validationtable is required if --validationmethod=table and --isconnectvalidatereq=true.");
            return new ResourceStatus(1, msg, true);
        }
        return status;
    }

    private JdbcConnectionPool createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcConnectionPool newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private JdbcConnectionPool createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        JdbcConnectionPool newResource = (JdbcConnectionPool)param.createChild(JdbcConnectionPool.class);
        newResource.setWrapJdbcObjects(this.wrapJDBCObjects);
        if (this.validationtable != null) {
            newResource.setValidationTableName(this.validationtable);
        }
        newResource.setValidateAtmostOncePeriodInSeconds(this.validateAtmostOncePeriod);
        if (this.isolationlevel != null) {
            newResource.setTransactionIsolationLevel(this.isolationlevel);
        }
        newResource.setSteadyPoolSize(this.steadypoolsize);
        if (this.statementTimeout != null) {
            newResource.setStatementTimeoutInSeconds(this.statementTimeout);
        }
        if (this.restype != null) {
            newResource.setResType(this.restype);
        }
        newResource.setPoolResizeQuantity(this.poolresize);
        newResource.setNonTransactionalConnections(this.nontransactionalconnections);
        newResource.setMaxWaitTimeInMillis(this.maxwait);
        newResource.setMaxPoolSize(this.maxpoolsize);
        if (this.maxConnectionUsageCount != null) {
            newResource.setMaxConnectionUsageCount(this.maxConnectionUsageCount);
        }
        if (this.matchConnections != null) {
            newResource.setMatchConnections(this.matchConnections);
        }
        if (this.lazyConnectionEnlistment != null) {
            newResource.setLazyConnectionEnlistment(this.lazyConnectionEnlistment);
        }
        if (this.lazyConnectionAssociation != null) {
            newResource.setLazyConnectionAssociation(this.lazyConnectionAssociation);
        }
        newResource.setIsIsolationLevelGuaranteed(this.isisolationguaranteed);
        newResource.setIsConnectionValidationRequired(this.isconnectvalidatereq);
        newResource.setIdleTimeoutInSeconds(this.idletimeout);
        newResource.setFailAllConnections(this.failconnection);
        if (this.datasourceclassname != null) {
            newResource.setDatasourceClassname(this.datasourceclassname);
        }
        newResource.setConnectionValidationMethod(this.validationmethod);
        if (this.connectionLeakTimeout != null) {
            newResource.setConnectionLeakTimeoutInSeconds(this.connectionLeakTimeout);
        }
        if (this.connectionLeakReclaim != null) {
            newResource.setConnectionLeakReclaim(this.connectionLeakReclaim);
        }
        if (this.connectionCreationRetryInterval != null) {
            newResource.setConnectionCreationRetryIntervalInSeconds(this.connectionCreationRetryInterval);
        }
        if (this.connectionCreationRetryAttempts != null) {
            newResource.setConnectionCreationRetryAttempts(this.connectionCreationRetryAttempts);
        }
        if (this.associateWithThread != null) {
            newResource.setAssociateWithThread(this.associateWithThread);
        }
        if (this.allownoncomponentcallers != null) {
            newResource.setAllowNonComponentCallers(this.allownoncomponentcallers);
        }
        if (this.statementcachesize != null) {
            newResource.setStatementCacheSize(this.statementcachesize);
        }
        if (this.validationclassname != null) {
            newResource.setValidationClassname(this.validationclassname);
        }
        if (this.initsql != null) {
            newResource.setInitSql(this.initsql);
        }
        if (this.sqltracelisteners != null) {
            newResource.setSqlTraceListeners(this.sqltracelisteners);
        }
        if (this.pooling != null) {
            newResource.setPooling(this.pooling);
        }
        if (this.ping != null) {
            newResource.setPing(this.ping);
        }
        if (this.driverclassname != null) {
            newResource.setDriverClassname(this.driverclassname);
        }
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        newResource.setName(this.jdbcconnectionpoolid);
        if (properties != null) {
            for (String propertyName : properties.stringPropertyNames()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName(propertyName);
                prop.setValue(properties.getProperty(propertyName));
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    public void setAttributes(ResourceAttributes attrList) {
        this.datasourceclassname = attrList.getString("datasource-classname");
        this.restype = attrList.getString("res-type");
        this.steadypoolsize = attrList.getString("steady-pool-size");
        this.maxpoolsize = attrList.getString("max-pool-size");
        this.maxwait = attrList.getString("max-wait-time-in-millis");
        this.poolresize = attrList.getString("pool-resize-quantity");
        this.idletimeout = attrList.getString("idle-timeout-in-seconds");
        this.isolationlevel = attrList.getString("transaction-isolation-level");
        this.isisolationguaranteed = attrList.getString("is-isolation-level-guaranteed");
        this.isconnectvalidatereq = attrList.getString("is-connection-validation-required");
        this.validationmethod = attrList.getString("connection-validation-method");
        this.validationtable = attrList.getString("validation-table-name");
        this.failconnection = attrList.getString("fail-all-connections");
        this.allownoncomponentcallers = attrList.getString("allow-non-component-callers");
        this.nontransactionalconnections = attrList.getString("non-transactional-connections");
        this.validateAtmostOncePeriod = attrList.getString("validate-atmost-once-period-in-seconds");
        this.connectionLeakTimeout = attrList.getString("connection-leak-timeout-in-seconds");
        this.connectionLeakReclaim = attrList.getString("connection-leak-reclaim");
        this.connectionCreationRetryAttempts = attrList.getString("connection-creation-retry-attempts");
        this.connectionCreationRetryInterval = attrList.getString("connection-creation-retry-interval-in-seconds");
        this.statementTimeout = attrList.getString("statement-timeout-in-seconds");
        this.lazyConnectionEnlistment = attrList.getString("lazy-connection-enlistment");
        this.lazyConnectionAssociation = attrList.getString("lazy-connection-association");
        this.associateWithThread = attrList.getString("associate-with-thread");
        this.matchConnections = attrList.getString("match-connections");
        this.maxConnectionUsageCount = attrList.getString("max-connection-usage-count");
        this.wrapJDBCObjects = attrList.getString("wrap-jdbc-objects");
        this.description = attrList.getString(DESCRIPTION);
        this.jdbcconnectionpoolid = attrList.getString("name");
        this.statementcachesize = attrList.getString("statement-cache-size");
        this.validationclassname = attrList.getString("validation-classname");
        this.initsql = attrList.getString("init-sql");
        this.sqltracelisteners = attrList.getString("sql-trace-listeners");
        this.pooling = attrList.getString("pooling");
        this.ping = attrList.getString("ping");
        this.driverclassname = attrList.getString("driver-classname");
    }

    public ResourceStatus delete(Iterable<Server> servers, Iterable<Cluster> clusters, final Resources resources, String cascade, final SimpleJndiName poolName) throws Exception {
        if (poolName == null) {
            String msg = I18N.getLocalString("jdbcConnPool.resource.noJndiName", "No id defined for JDBC Connection pool.");
            return new ResourceStatus(1, msg);
        }
        if (!this.isResourceExists(resources, poolName)) {
            String msg = I18N.getLocalString("delete.jdbc.connection.pool.notfound", "A JDBC connection pool named {0} does not exist.", new Object[]{poolName});
            return new ResourceStatus(1, msg);
        }
        try {
            Object obj = this.deleteAssociatedResources(servers, clusters, resources, Boolean.parseBoolean(cascade), poolName);
            if (obj instanceof Integer && (Integer)obj == 1) {
                String msg = I18N.getLocalString("delete.jdbc.connection.pool.pool_in_use", "JDBC Connection pool {0} delete failed ", new Object[]{poolName});
                return new ResourceStatus(1, msg);
            }
            if (ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    JdbcConnectionPool cp = (JdbcConnectionPool)resources.getResourceByName(JdbcConnectionPool.class, poolName);
                    return param.getResources().remove(cp);
                }
            }, (ConfigBeanProxy)resources) == null) {
                String msg = I18N.getLocalString("delete.jdbc.connection.pool.notfound", "A JDBC connection pool named {0} does not exist.", new Object[]{poolName});
                return new ResourceStatus(1, msg);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = tfe.getMessage() != null ? tfe.getMessage() : I18N.getLocalString("jdbcConnPool.resource.deletionFailed", "JDBC Connection pool {0} delete failed ", new Object[]{poolName});
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = I18N.getLocalString("jdbcConnPool.resource.deleteSuccess", "JDBC Connection pool {0} deleted successfully", new Object[]{poolName});
        return new ResourceStatus(0, msg);
    }

    private boolean isResourceExists(Resources resources, SimpleJndiName poolName) {
        return resources.getResourceByName(JdbcConnectionPool.class, poolName) != null;
    }

    private Object deleteAssociatedResources(final Iterable<Server> servers, final Iterable<Cluster> clusters, Resources resources, boolean cascade, final SimpleJndiName poolName) throws TransactionFailure {
        if (cascade) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    Collection referringResources = JdbcResourcesUtil.getResourcesOfPool((Resources)param, (SimpleJndiName)poolName);
                    for (BindableResource referringResource : referringResources) {
                        SimpleJndiName jndiName = SimpleJndiName.of((String)referringResource.getJndiName());
                        JDBCConnectionPoolManager.this.deleteServerResourceRefs(servers, jndiName);
                        JDBCConnectionPoolManager.this.deleteClusterResourceRefs(clusters, jndiName);
                        param.getResources().remove(referringResource);
                    }
                    return true;
                }
            }, (ConfigBeanProxy)resources);
        } else {
            Collection referringResources = JdbcResourcesUtil.getResourcesOfPool((Resources)resources, (SimpleJndiName)poolName);
            if (referringResources.size() > 0) {
                return 1;
            }
        }
        return true;
    }

    private void deleteServerResourceRefs(Iterable<Server> servers, SimpleJndiName refName) throws TransactionFailure {
        if (servers != null) {
            for (Server server : servers) {
                server.deleteResourceRef(refName);
            }
        }
    }

    private void deleteClusterResourceRefs(Iterable<Cluster> clusters, SimpleJndiName refName) throws TransactionFailure {
        if (clusters != null) {
            for (Cluster cluster : clusters) {
                cluster.deleteResourceRef(refName);
            }
        }
    }

    public Resource createConfigBean(Resources resources, ResourceAttributes attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes);
        ResourceStatus status = validate ? this.isValid(resources) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage(), status.getException());
    }
}

