/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.junit.Assert;
import org.junit.Test;
import testutil.BaseTestCase;

public class GroupLevelTest
extends BaseTestCase {
    private IQueryResults qr;
    private DataEngine dataEngine;
    private String rowName;
    private ScriptExpression rowExpr;
    private String strName;
    private ScriptExpression strExpr;
    private String aggrName;
    private ScriptExpression aggrExpr;

    @Test
    public void testGroupLevelValue() throws BirtException {
        int rowCount = 10;
        this.prepare(rowCount);
        IResultIterator ri = this.qr.getResultIterator();
        Assert.assertTrue((ri.getStartingGroupLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ri.getEndingGroupLevel() != 0 ? 1 : 0) != 0);
        ri.next();
        Assert.assertTrue((ri.getStartingGroupLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ri.getEndingGroupLevel() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ri.getValue(this.rowName).equals(new Integer(10)));
        Assert.assertTrue((boolean)ri.getValue(this.aggrName).equals(new Double(55.0)));
        int i = 0;
        while (i < rowCount - 1) {
            ri.next();
            Assert.assertTrue((ri.getStartingGroupLevel() > 0 ? 1 : 0) != 0);
            if (i < rowCount - 2) {
                Assert.assertTrue((ri.getEndingGroupLevel() > 0 ? 1 : 0) != 0);
            }
            ++i;
        }
        Assert.assertTrue((ri.getStartingGroupLevel() != 0 ? 1 : 0) != 0);
        Assert.assertTrue((ri.getEndingGroupLevel() == 0 ? 1 : 0) != 0);
        ri.next();
        try {
            ri.getStartingGroupLevel();
        }
        catch (BirtException e) {
            Assert.assertTrue(("data.engine.NoCurrentRow" == e.getErrorCode() ? 1 : 0) != 0);
        }
        this.qr.close();
        this.dataEngine.shutdown();
    }

    @Test
    public void testGroupLevelValue2() throws BirtException {
        int rowCount = 1;
        this.prepare(rowCount);
        IResultIterator ri = this.qr.getResultIterator();
        Assert.assertTrue((ri.getStartingGroupLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ri.getEndingGroupLevel() == 0 ? 1 : 0) != 0);
        ri.next();
        Assert.assertTrue((ri.getStartingGroupLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((ri.getEndingGroupLevel() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ri.getValue(this.rowName).equals(new Integer(1)));
        Assert.assertTrue((boolean)ri.getValue(this.aggrName).equals(new Double(1.0)));
        ri.next();
        try {
            ri.getStartingGroupLevel();
        }
        catch (BirtException e) {
            Assert.assertTrue(("data.engine.NoCurrentRow" == e.getErrorCode() ? 1 : 0) != 0);
        }
        this.qr.close();
        this.dataEngine.shutdown();
    }

    @Test
    public void testGroupLevelValue3() throws BirtException {
        int rowCount = 0;
        this.prepare(rowCount);
        IResultIterator ri = this.qr.getResultIterator();
        ri.next();
        try {
            ri.getStartingGroupLevel();
        }
        catch (BirtException e) {
            Assert.assertTrue(("data.engine.NoCurrentRow" == e.getErrorCode() ? 1 : 0) != 0);
        }
        this.qr.close();
        this.dataEngine.shutdown();
    }

    @Test
    public void testValueOnNullResult() throws BirtException {
        int rowCount = 0;
        this.prepare(rowCount);
        IResultIterator ri = this.qr.getResultIterator();
        ri.next();
        Assert.assertTrue((boolean)ri.getValue(this.strName).toString().endsWith("abc"));
        this.qr.close();
        this.dataEngine.shutdown();
    }

    private void prepare(int rowCount) throws BirtException {
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("JUST as place folder");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("data set");
        dataSet.setDataSource(dataSource.getName());
        dataSet.setOpenScript("count=" + rowCount + ";");
        dataSet.setFetchScript("if (count==0) {return false; } else { row.NUM=count; row.SQUARE=count*count; row.STR=\"row#\" + count; --count; return true; }");
        String[] scriptColumnNames = new String[]{"NUM", "SQUARE", "STR"};
        int[] scriptColumnTypes = new int[]{2, 3, 5};
        int i = 0;
        while (i < scriptColumnNames.length) {
            ColumnDefinition colInfo = new ColumnDefinition(scriptColumnNames[i]);
            colInfo.setDataType(scriptColumnTypes[i]);
            dataSet.getResultSetHints().add(colInfo);
            ++i;
        }
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(GroupLevelTest.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(GroupLevelTest.getTempDir());
        this.dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        this.dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        this.dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.setDataSetName(dataSet.getName());
        this.rowName = "_NUM";
        this.rowExpr = new ScriptExpression("dataSetRow.NUM");
        qd.addResultSetExpression(this.rowName, (IBaseExpression)this.rowExpr);
        this.strName = "_abc";
        this.strExpr = new ScriptExpression("\"abc\"");
        qd.addResultSetExpression(this.strName, (IBaseExpression)this.strExpr);
        this.aggrName = "_SUM_NUM";
        this.aggrExpr = new ScriptExpression("Total.sum(dataSetRow.NUM)");
        qd.addResultSetExpression(this.aggrName, (IBaseExpression)this.aggrExpr);
        this.qr = this.dataEngine.prepare((IQueryDefinition)qd).execute(null);
    }
}

