/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.eclipse.birt.report.model.util.SecurityUtil;
import org.eclipse.birt.report.model.util.URIUtilImpl;

public class URIUtil {
    public static final String FILE_SCHEMA = "file";
    private static final String URL_SEPARATOR = "/";

    public static String getLocalPath(String uri) {
        return URIUtilImpl.getLocalPath(uri);
    }

    private static boolean isFileProtocol(String filePath) {
        return URIUtilImpl.getLocalPath(filePath) != null;
    }

    public static String convertFileNameToURLString(String filePath) {
        StringBuilder buffer = new StringBuilder();
        String path = filePath;
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c < '\u001f' || c == '\u007f') {
                buffer.append("%" + Character.toString(c));
            } else if (c == '#') {
                buffer.append("%23");
            } else if (c == '%') {
                buffer.append("%25");
            } else if (c == '<') {
                buffer.append("%3C");
            } else if (c == '>') {
                buffer.append("%3E");
            } else if (c == '\"') {
                buffer.append("%22");
            } else if (c == ' ') {
                buffer.append("%20");
            } else if (c == '^') {
                buffer.append("%5E");
            } else if (c == '`') {
                buffer.append("%60");
            } else if (c == '[') {
                buffer.append("%5B");
            } else if (c == ']') {
                buffer.append("%5D");
            } else if (c == '{') {
                buffer.append("%7B");
            } else if (c == '}') {
                buffer.append("%7D");
            } else if (c == '\\') {
                buffer.append(URL_SEPARATOR);
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    @Deprecated
    public static URL getDirectory(String filePath) {
        return URIUtilImpl.getDirectory(filePath);
    }

    @Deprecated
    public static URL getDirectory(URL url) {
        return URIUtilImpl.getDirectory(url);
    }

    public static String getRelativePath(String base, String resource) {
        if (base == null || resource == null) {
            return resource;
        }
        if (URIUtil.isFileProtocol(resource) && URIUtil.isFileProtocol(base)) {
            return URIUtil.createRelativePathFromFilePath(base, resource);
        }
        return URIUtil.createRelativePathFromString(base, resource, URL_SEPARATOR);
    }

    private static String createRelativePathFromFilePath(String base, String resource) {
        String baseDir = URIUtil.getLocalPath(base);
        String resourceDir = URIUtil.getLocalPath(resource);
        if (baseDir == null || resourceDir == null) {
            return resource;
        }
        File baseFile = new File(baseDir);
        File resourceFile = new File(resourceDir);
        baseDir = SecurityUtil.getFileAbsolutePath(baseFile);
        resourceDir = SecurityUtil.getFileAbsolutePath(resourceFile);
        return URIUtil.createRelativePathFromString(baseDir, resourceDir, File.separator);
    }

    private static String createRelativePathFromString(String baseDir, String resourceDir, String separator) {
        char lastChar;
        int len;
        String newBaseDir = baseDir;
        if (newBaseDir.endsWith(URL_SEPARATOR) || newBaseDir.endsWith(separator)) {
            newBaseDir = newBaseDir.substring(0, newBaseDir.length() - 1);
        }
        int matchedPos = 0;
        matchedPos = 0;
        while (matchedPos < newBaseDir.length() && matchedPos < resourceDir.length()) {
            if (newBaseDir.charAt(matchedPos) != resourceDir.charAt(matchedPos)) break;
            ++matchedPos;
        }
        if (!URIUtil.isLastDirectoryMatched(newBaseDir, resourceDir, matchedPos) && !URIUtil.isLastDirectoryMatched(resourceDir, newBaseDir, matchedPos)) {
            int oldMatchedPos = matchedPos;
            matchedPos = newBaseDir.lastIndexOf(separator, oldMatchedPos - 1);
        }
        int samePrefixPos = matchedPos;
        int upDirs = 0;
        while (matchedPos < newBaseDir.length() && matchedPos >= 0) {
            matchedPos = newBaseDir.indexOf(separator, matchedPos + 1);
            ++upDirs;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < upDirs) {
            sb.append("../");
            ++i;
        }
        if (samePrefixPos < resourceDir.length()) {
            String remainPath = resourceDir.substring(samePrefixPos + 1);
            remainPath = remainPath.replace('\\', '/');
            sb.append(remainPath);
        }
        if ((len = sb.length()) > 0 && (lastChar = sb.charAt(len - 1)) == '/') {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    public static String resolveAbsolutePath(String base, String relativePath) {
        if (base == null || relativePath == null) {
            return relativePath;
        }
        if (URIUtil.isFileProtocol(base) && URIUtil.isFileProtocol(relativePath)) {
            return URIUtil.resolveAbsolutePathFromFilePath(base, relativePath);
        }
        return URIUtil.resolveAbsolutePathFromString(base, relativePath);
    }

    private static String resolveAbsolutePathFromFilePath(String base, String relativePath) {
        File file = new File(relativePath);
        if (file.isAbsolute()) {
            return relativePath;
        }
        String baseDir = URIUtil.getLocalPath(base);
        String relativeDir = URIUtil.getLocalPath(relativePath);
        if (baseDir == null || relativeDir == null) {
            return relativePath;
        }
        File baseFile = new File(baseDir);
        File resourceFile = new File(baseFile, relativeDir);
        try {
            return resourceFile.getCanonicalPath();
        }
        catch (IOException e) {
            return resourceFile.getPath();
        }
    }

    private static String resolveAbsolutePathFromString(String base, String relativePath) {
        if (base == null || relativePath == null) {
            return relativePath;
        }
        URI uri = URIUtilImpl.resolveAbsolutePath(relativePath);
        if (uri != null && uri.isAbsolute()) {
            return relativePath;
        }
        boolean appendDirectorySeparator = false;
        if (base.length() > 0 && relativePath.length() > 0) {
            char lastBaseChar = base.charAt(base.length() - 1);
            char firstRelativeChar = relativePath.charAt(0);
            if (lastBaseChar != '/' && lastBaseChar != File.separatorChar && firstRelativeChar != '/' && firstRelativeChar != File.separatorChar) {
                appendDirectorySeparator = true;
            }
        }
        String path = null;
        path = appendDirectorySeparator ? base + URL_SEPARATOR + relativePath : base + relativePath;
        uri = URIUtilImpl.resolveAbsolutePath(path);
        if (uri != null) {
            return uri.normalize().toString();
        }
        return path;
    }

    private static boolean isLastDirectoryMatched(String baseDir, String resourceDir, int matchedPos) {
        return matchedPos == baseDir.length() && (matchedPos < resourceDir.length() && (resourceDir.charAt(matchedPos) == File.separatorChar || resourceDir.charAt(matchedPos) == '/') || matchedPos == resourceDir.length());
    }

    public static boolean isValidResourcePath(String resourceDir) {
        if (resourceDir == null) {
            return false;
        }
        File f = new File(resourceDir);
        return f.isAbsolute() && SecurityUtil.isFile(f) && SecurityUtil.isDirectory(f);
    }
}

