/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.birt.report.data.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.DriverInfo;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JarFile;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.JdbcToolKit;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.birt.report.data.oda.jdbc.utils.JDBCDriverInformation;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class JdbcDriverManagerDialog
extends TrayDialog {
    private static Logger logger = Logger.getLogger(JdbcDriverManagerDialog.class.getName());
    private TableViewer jarViewer;
    private TableViewer driverViewer;
    private Button addButton;
    private Button restoreButton;
    private Button deleteButton;
    private Button editButton;
    private Map jarMap;
    private Map driverMap;
    private TabFolder tabFolder;
    private List externalDrivers;
    private static final String TEXT_ADDBUTTON = JdbcPlugin.getResourceString("driverManagerDialog.text.Add");
    private static final String TEXT_RESTOREBUTTON = JdbcPlugin.getResourceString("driverManagerDialog.text.Restore");
    private static final String TEXT_DELETEBUTTON = JdbcPlugin.getResourceString("driverManagerDialog.text.Delete");
    private static final String TEXT_EDITBUTTON = JdbcPlugin.getResourceString("driverManagerDialog.text.Edit");
    private static final String[] TEXT4BUTTON = new String[]{TEXT_ADDBUTTON, TEXT_RESTOREBUTTON, TEXT_DELETEBUTTON, TEXT_EDITBUTTON};
    private boolean jarChanged = false;
    private static boolean driverChanged = false;
    private Hashtable jarsToBeCopied;
    private Hashtable jarsToBeDeleted;
    private Hashtable jarsToBeCopiedRuntime;
    private Hashtable jarsToBeDeletedRuntime;
    private int btnWidth = 90;
    private Comparator collator = Collator.getInstance();

    public JdbcDriverManagerDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.setShellStyle(67696);
    }

    public void create() {
        super.create();
        Point pt = this.getShell().computeSize(-1, -1);
        pt.y = Math.max(pt.y, 400);
        this.getShell().setSize(pt);
        this.getShell().setText(JdbcPlugin.getResourceString("driverManagerDialog.text.title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.addTabPages(this.tabFolder);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                int index = JdbcDriverManagerDialog.this.tabFolder.getSelectionIndex();
                if (index == 1) {
                    JdbcDriverManagerDialog.this.refreshDriverPage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.initialize();
        Utility.setSystemHelp((Control)composite, "org.eclipse.birt.cshelp.Dialog_JDBC_ManageDrivers_ID");
        return composite;
    }

    private void addTabPages(TabFolder tabFolder) {
        this.localizeButtonWidth();
        this.addJarPage(tabFolder);
        this.addDriverPage(tabFolder);
    }

    private void localizeButtonWidth() {
        this.btnWidth = Math.max(this.getMaxStringWidth(TEXT4BUTTON), this.btnWidth);
    }

    private int getMaxStringWidth(String[] strArray) {
        int maxWidth = -1;
        int i = 0;
        while (i < strArray.length) {
            int width = strArray[i].length();
            maxWidth = Math.max(maxWidth, width);
            ++i;
        }
        return this.convertWidthInCharsToPixels(maxWidth);
    }

    private void addJarPage(TabFolder tabFolder) {
        Composite page = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        page.setLayout((Layout)layout);
        page.setLayoutData((Object)new GridData(1808));
        Table table = new Table(page, 67586);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column0 = new TableColumn(table, 0);
        column0.setWidth(20);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.jarColumnFileName"));
        column1.setWidth(150);
        column1.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog.this.sortJar(1, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.jarColumnLocation"));
        column2.setWidth(280);
        column2.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog.this.sortJar(2, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.jarViewer = new TableViewer(table);
        this.jarViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Map) {
                    return ((Map)inputElement).entrySet().toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.jarViewer.setSorter(null);
        this.jarViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JdbcDriverManagerDialog.this.updateJarButtons();
            }
        });
        Label lb = new Label(page, 0);
        lb.setText(JdbcPlugin.getResourceString("driverManagerDialog.message.NotInODADirectory"));
        lb = new Label(page, 0);
        lb.setText(JdbcPlugin.getResourceString("driverManagerDialog.message.FileNotExist"));
        lb = new Label(page, 0);
        lb.setText(JdbcPlugin.getResourceString("driverManagerDialog.message.FileRestored"));
        Composite buttons = new Composite(page, 0);
        buttons.setLayoutData((Object)new GridData(32));
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(TEXT_ADDBUTTON);
        data = new GridData(32);
        data.widthHint = this.btnWidth;
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog.this.addJars();
            }
        });
        this.restoreButton = new Button(buttons, 8);
        this.restoreButton.setText(TEXT_RESTOREBUTTON);
        data = new GridData(32);
        data.widthHint = this.btnWidth;
        this.restoreButton.setLayoutData((Object)data);
        this.restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog.this.restoreJars();
            }
        });
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(TEXT_DELETEBUTTON);
        data = new GridData(32);
        data.widthHint = this.btnWidth;
        this.deleteButton.setLayoutData((Object)data);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog.this.deleteJars();
            }
        });
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setControl((Control)page);
        tabItem.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.JarFile"));
    }

    private void addDriverPage(TabFolder tabFolder) {
        Composite page = new Composite((Composite)tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        page.setLayout((Layout)layout);
        page.setLayoutData((Object)new GridData(1808));
        Table table = new Table(page, 67584);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column0 = new TableColumn(table, 0);
        column0.setWidth(20);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.driverColumnClassName"));
        column1.setWidth(300);
        column1.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog.this.sortDriver(1, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.driverColumnDisplayName"));
        column2.setWidth(100);
        column2.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog.this.sortDriver(2, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.driverColumnTemplate"));
        column3.setWidth(100);
        column3.addSelectionListener(new SelectionListener(){
            private boolean asc = false;

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog.this.sortDriver(3, this.asc);
                this.asc = !this.asc;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.driverViewer = new TableViewer(table);
        this.driverViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Map) {
                    return ((Map)inputElement).entrySet().toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.driverViewer.setSorter(null);
        this.driverViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JdbcDriverManagerDialog.this.updateDriverButtons();
            }
        });
        this.driverViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JdbcDriverManagerDialog.this.editDriver();
            }
        });
        Composite buttons = new Composite(page, 0);
        buttons.setLayoutData((Object)new GridData(32));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(TEXT_EDITBUTTON);
        data = new GridData(32);
        data.widthHint = this.btnWidth;
        this.editButton.setLayoutData((Object)data);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JdbcDriverManagerDialog.this.editDriver();
            }
        });
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setControl((Control)page);
        tabItem.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.Drivers"));
    }

    private void initialize() {
        this.jarMap = new HashMap();
        this.driverMap = new HashMap();
        this.jarsToBeCopied = new Hashtable();
        this.jarsToBeDeleted = new Hashtable();
        this.jarsToBeCopiedRuntime = new Hashtable();
        this.jarsToBeDeletedRuntime = new Hashtable();
        this.updateJarMap();
        this.updateDriverMapInit();
        this.updateExternalDriverList();
        this.refreshJarViewer();
        this.refreshDriverViewer();
        this.updateJarButtons();
        this.updateDriverButtons();
    }

    private void updateJarMap() {
        File jarPath = JarFile.getDriverLocation();
        if (jarPath != null && jarPath.exists() && jarPath.isDirectory()) {
            File[] jars = jarPath.listFiles(new FileFilter(){
                Map deletedJars = Utility.getPreferenceStoredMap("Deleted Jar List");

                @Override
                public boolean accept(File pathname) {
                    return pathname.exists() && pathname.isFile() && !this.deletedJars.containsKey(pathname.getName()) && (pathname.getName().endsWith(".jar") || pathname.getName().endsWith(".zip"));
                }
            });
            int i = 0;
            while (i < jars.length) {
                this.jarMap.put(jars[i].getName(), new JarFile(jars[i].getName(), jars[i].getAbsolutePath(), "", false));
                ++i;
            }
        }
        this.jarMap.putAll(Utility.getPreferenceStoredMap("JDBC Jar List"));
        this.checkJarState();
    }

    private void sortDriver(final int columnIndex, final boolean asc) {
        this.driverViewer.setComparator(new ViewerComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                String source = (String)o1;
                String target = (String)o2;
                int result = 0;
                if (columnIndex == 1) {
                    result = this.compareStr(JdbcDriverManagerDialog.this.getDriverClassName(source), JdbcDriverManagerDialog.this.getDriverClassName(target));
                } else if (columnIndex == 2) {
                    result = this.compareStr(JdbcDriverManagerDialog.this.getDisplayName(source), JdbcDriverManagerDialog.this.getDisplayName(target));
                } else if (columnIndex == 3) {
                    result = this.compareStr(JdbcDriverManagerDialog.this.getUrlTemplate(source), JdbcDriverManagerDialog.this.getUrlTemplate(target));
                }
                if (!asc) {
                    return result;
                }
                return result *= -1;
            }

            private int compareStr(Object o1, Object o2) {
                return JdbcDriverManagerDialog.this.collator.compare(o1, o2);
            }
        }));
        this.refreshDriver();
    }

    private void updateExternalDriverList() {
        ArrayList<JarFile> externalJars = new ArrayList<JarFile>();
        JarFile[] jars = this.jarMap.values().toArray(new JarFile[0]);
        int i = 0;
        while (i < jars.length) {
            externalJars.add(jars[i]);
            ++i;
        }
        List drivers = JdbcToolKit.getDriverByJar(externalJars);
        this.externalDrivers = new ArrayList();
        if (drivers != null) {
            int i2 = 0;
            while (i2 < drivers.size()) {
                this.externalDrivers.add(((JDBCDriverInformation)drivers.get(i2)).toString());
                ++i2;
            }
        }
    }

    private String getDriverClassName(String source) {
        int index = source.lastIndexOf("=");
        if (index != -1 && this.driverMap.containsKey(source.substring(0, index))) {
            return source.substring(0, index);
        }
        return source;
    }

    private String getDisplayName(String source) {
        DriverInfo driverInfo = (DriverInfo)this.driverMap.get(this.getDriverClassName(source));
        return driverInfo.getDisplayName();
    }

    private String getUrlTemplate(String source) {
        DriverInfo driverInfo = (DriverInfo)this.driverMap.get(this.getDriverClassName(source));
        return driverInfo.getUrlTemplate();
    }

    private void sortJar(final int columnIndex, final boolean asc) {
        this.jarViewer.setComparator(new ViewerComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                String source = (String)o1;
                String target = (String)o2;
                int result = 0;
                if (columnIndex == 1) {
                    result = this.compareStr(JdbcDriverManagerDialog.this.getFileName(source), JdbcDriverManagerDialog.this.getFileName(target));
                } else if (columnIndex == 2) {
                    result = this.compareStr(JdbcDriverManagerDialog.this.getFilePath(source), JdbcDriverManagerDialog.this.getFilePath(target));
                }
                if (!asc) {
                    return result;
                }
                return result *= -1;
            }

            private int compareStr(Object o1, Object o2) {
                return JdbcDriverManagerDialog.this.collator.compare(o1, o2);
            }
        }));
        this.refreshJar();
    }

    private String getFileName(String source) {
        int index = source.lastIndexOf("=");
        if (index != -1 && this.jarMap.containsKey(source.substring(0, index))) {
            return source.substring(0, index);
        }
        return source;
    }

    private String getFilePath(String source) {
        JarFile jarFile = (JarFile)this.jarMap.get(this.getFileName(source));
        return jarFile.getFilePath();
    }

    private void refreshJarViewer() {
        this.jarViewer.setInput(null);
        this.jarViewer.setInput((Object)this.jarMap);
        this.refreshJar();
    }

    private void refreshJar() {
        int i = 0;
        while (i < this.jarViewer.getTable().getItemCount()) {
            TableItem ti = this.jarViewer.getTable().getItem(i);
            Object element = ti.getData();
            String c0 = "";
            String c1 = "";
            String c2 = "";
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                JarFile jarInfo = (JarFile)entry.getValue();
                c0 = jarInfo.getState();
                c1 = (String)entry.getKey();
                c2 = jarInfo.getFilePath();
            }
            ti.setText(0, c0);
            ti.setText(1, c1);
            ti.setText(2, c2);
            ++i;
        }
    }

    private void checkJarState() {
        for (JarFile jarInfo : this.jarMap.values()) {
            jarInfo.checkJarState();
        }
    }

    private void updateDriverMapInit() {
        this.updateDriverMap(JdbcToolKit.getJdbcDriversFromODADir("org.eclipse.birt.report.data.oda.jdbc"));
    }

    private void updateDriverMapRuntime() {
        if (this.jarsToBeCopiedRuntime.equals(this.jarsToBeDeletedRuntime)) {
            return;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        Iterator jarsCopyIterator = this.jarsToBeCopiedRuntime.values().iterator();
        while (jarsCopyIterator.hasNext()) {
            fileList.add(new File(((JarFile)jarsCopyIterator.next()).getFilePath()));
        }
        List addedDrivers = JdbcToolKit.addToDriverList(fileList);
        if (addedDrivers != null) {
            int i = 0;
            while (i < addedDrivers.size()) {
                this.externalDrivers.add(((JDBCDriverInformation)addedDrivers.get(i)).toString());
                ++i;
            }
        }
        fileList.clear();
        Iterator jarsDeleteIterator = this.jarsToBeDeletedRuntime.values().iterator();
        while (jarsDeleteIterator.hasNext()) {
            fileList.add(new File(((JarFile)jarsDeleteIterator.next()).getFilePath()));
        }
        List removedDrivers = JdbcToolKit.removeFromDriverList(fileList);
        if (removedDrivers != null) {
            int i = 0;
            while (i < removedDrivers.size()) {
                this.externalDrivers.remove(((JDBCDriverInformation)removedDrivers.get(i)).toString());
                ++i;
            }
        }
        this.resetRuntimeJars();
        this.updateDriverMap(JdbcToolKit.getDriverList());
    }

    private void resetRuntimeJars() {
        this.jarsToBeCopiedRuntime.clear();
        this.jarsToBeDeletedRuntime.clear();
    }

    private void updateDriverMap(List driverList) {
        this.driverMap.clear();
        for (JDBCDriverInformation info : driverList) {
            if (this.driverMap.containsKey(info.toString())) continue;
            this.driverMap.put(info.toString(), new DriverInfo(info.toString(), info.getDisplayName(), info.getUrlFormat()));
        }
    }

    private void refreshDriverViewer() {
        this.driverViewer.setInput(null);
        this.driverViewer.setInput((Object)this.driverMap);
        this.refreshDriver();
    }

    private void refreshDriver() {
        int i = 0;
        while (i < this.driverViewer.getTable().getItemCount()) {
            TableItem ti = this.driverViewer.getTable().getItem(i);
            Object element = ti.getData();
            String c1 = "";
            String c2 = "";
            String c3 = "";
            if (element instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)element;
                DriverInfo driverInfo = (DriverInfo)entry.getValue();
                c1 = entry.getKey().toString();
                c2 = driverInfo.getDisplayName();
                c3 = driverInfo.getUrlTemplate();
            }
            ti.setText(0, "");
            ti.setText(1, c1);
            ti.setText(2, c2);
            ti.setText(3, c3);
            ++i;
        }
    }

    private void updateJarButtons() {
        int[] indices = this.jarViewer.getTable().getSelectionIndices();
        boolean enableRestoreBtn = indices.length > 0;
        int i = 0;
        while (i < indices.length) {
            if (!"x".equals(this.jarViewer.getTable().getItem(indices[i]).getText())) {
                enableRestoreBtn = false;
                break;
            }
            ++i;
        }
        this.restoreButton.setEnabled(enableRestoreBtn && this.jarViewer.getTable().getSelectionIndex() >= 0 && this.jarViewer.getTable().getSelectionIndex() < this.jarViewer.getTable().getItemCount());
        this.deleteButton.setEnabled(this.jarViewer.getTable().getSelectionIndex() >= 0 && this.jarViewer.getTable().getSelectionIndex() < this.jarViewer.getTable().getItemCount());
    }

    private void updateDriverButtons() {
        if (this.driverViewer.getTable().getSelectionIndex() >= 0 && this.driverViewer.getTable().getSelectionIndex() < this.driverViewer.getTable().getItemCount()) {
            if (this.externalDrivers != null) {
                Object obj = ((Map.Entry)this.driverViewer.getTable().getSelection()[0].getData()).getValue();
                this.editButton.setEnabled(this.externalDrivers.contains(((DriverInfo)obj).getDriverName()));
            } else {
                this.editButton.setEnabled(false);
            }
        } else {
            this.editButton.setEnabled(false);
        }
    }

    private void refreshDriverPage() {
        if (this.jarChanged && (this.jarsToBeCopiedRuntime.size() > 0 || this.jarsToBeDeletedRuntime.size() > 0)) {
            this.updateDriverMapRuntime();
            this.refreshDriverViewer();
            this.updateDriverButtons();
            this.jarChanged = false;
        }
    }

    private void addJars() {
        this.jarChanged = true;
        FileDialog dlg = new FileDialog(this.getShell(), 2);
        dlg.setFilterExtensions(new String[]{"*.jar", "*.zip"});
        if (dlg.open() != null) {
            String[] jarNames = dlg.getFileNames();
            String folder = dlg.getFilterPath() + File.separator;
            int i = 0;
            while (i < jarNames.length) {
                this.addSingleJar(folder + jarNames[i], jarNames[i]);
                ++i;
            }
            this.refreshJarViewer();
            this.updateJarButtons();
        }
    }

    private void addSingleJar(String folder, String fileName) {
        if (folder == null || folder.trim().length() == 0 || fileName == null || fileName.trim().length() == 0) {
            return;
        }
        if (this.jarMap.containsKey(fileName) && !"x".equals(((JarFile)this.jarMap.get(fileName)).getState())) {
            MessageDialog.openError(null, (String)JdbcPlugin.getResourceString("driverManagerDialog.text.DriverError"), (String)JdbcPlugin.getResourceString("driverManagerDialog.error.CanNotAddDriver"));
            return;
        }
        JarFile jarInfo = new JarFile(fileName, folder, "", false);
        System.out.println(jarInfo.toString());
        if (this.jarsToBeDeleted.containsKey(fileName)) {
            this.jarsToBeDeleted.remove(fileName);
        } else {
            this.jarsToBeCopied.put(fileName, jarInfo);
        }
        if (this.jarsToBeDeletedRuntime.containsKey(fileName)) {
            this.jarsToBeDeletedRuntime.remove(fileName);
        } else {
            this.jarsToBeCopiedRuntime.put(fileName, jarInfo);
        }
        this.jarMap.put(fileName, jarInfo);
    }

    private void restoreJars() {
        this.jarChanged = true;
        TableItem[] restoredItems = this.jarViewer.getTable().getSelection();
        int[] indices = this.jarViewer.getTable().getSelectionIndices();
        int i = 0;
        while (i < restoredItems.length) {
            this.restoreSingleJar(restoredItems[i], indices[i]);
            ++i;
        }
        this.refreshJarViewer();
        this.updateJarButtons();
    }

    private void restoreSingleJar(TableItem item, int index) {
        if (index >= 0 && index < this.jarViewer.getTable().getItemCount()) {
            Map.Entry fn = (Map.Entry)this.jarViewer.getTable().getItem(index).getData();
            JarFile jarFile = (JarFile)fn.getValue();
            jarFile.setRestored();
            this.jarsToBeCopied.put(jarFile.getFileName(), jarFile);
            this.jarsToBeCopiedRuntime.put(jarFile.getFileName(), jarFile);
            jarFile.checkJarState();
        }
    }

    private void deleteJars() {
        this.jarChanged = true;
        TableItem[] deletedItems = this.jarViewer.getTable().getSelection();
        int[] indices = this.jarViewer.getTable().getSelectionIndices();
        int i = 0;
        while (i < deletedItems.length) {
            this.deleteSingleJar(deletedItems[i], indices[i] - i);
            ++i;
        }
        this.jarViewer.getTable().select(this.jarViewer.getTable().getItemCount() - 1);
        this.refreshJarViewer();
        this.updateJarButtons();
    }

    private void deleteSingleJar(TableItem item, int index) {
        Map.Entry fn = (Map.Entry)item.getData();
        JarFile jarFile = (JarFile)fn.getValue();
        jarFile.setToBeDeleted(true);
        if (this.jarsToBeCopied.containsKey(jarFile.getFileName())) {
            this.jarsToBeCopied.remove(jarFile.getFileName());
        } else if (jarFile.getState().indexOf("x") == -1) {
            this.jarsToBeDeleted.put(jarFile.getFileName(), jarFile);
        }
        if (this.jarsToBeCopiedRuntime.containsKey(jarFile.getFileName())) {
            this.jarsToBeCopiedRuntime.remove(jarFile.getFileName());
        } else if (jarFile.getState().indexOf("x") == -1) {
            this.jarsToBeDeletedRuntime.put(jarFile.getFileName(), jarFile);
        }
        this.jarMap.remove(fn.getKey());
        this.jarViewer.getTable().remove(index);
    }

    private void editDriver() {
        if (this.driverViewer.getTable().getSelectionIndex() >= 0 && this.driverViewer.getTable().getSelectionIndex() < this.driverViewer.getTable().getItemCount()) {
            EditJdbcDriverDialog dlg = new EditJdbcDriverDialog(this.getShell());
            Object obj = this.driverViewer.getTable().getItem(this.driverViewer.getTable().getSelectionIndex()).getData();
            DriverInfo driverInfo = (DriverInfo)((Map.Entry)obj).getValue();
            if (this.externalDrivers == null || !this.externalDrivers.contains(driverInfo.getDriverName())) {
                return;
            }
            if (obj instanceof Map.Entry) {
                dlg.setDriverClassName(((Map.Entry)obj).getKey().toString());
                dlg.setDisplayName(driverInfo.getDisplayName());
                dlg.setUrlTemplate(driverInfo.getUrlTemplate());
            }
            if (dlg.open() == 0) {
                if (!(!(obj instanceof Map.Entry) || dlg.getDisplayName().trim().equals(driverInfo.getDisplayName().trim()) && dlg.getUrlTemplate().trim().equals(driverInfo.getUrlTemplate().trim()))) {
                    driverInfo.setDisplayName(dlg.getDisplayName());
                    driverInfo.setUrlTemplate(dlg.getUrlTemplate());
                    this.driverMap.put(((Map.Entry)obj).getKey(), driverInfo);
                    Utility.setPreferenceStoredMap("JDBC Driver Map", this.driverMap);
                    driverChanged = true;
                }
                this.refreshDriverViewer();
                this.updateDriverButtons();
            }
        }
    }

    public static boolean needResetPreferences() {
        return driverChanged;
    }

    public static void resetDriverChangedStatus() {
        driverChanged = false;
    }

    protected void cancelPressed() {
        super.cancelPressed();
        JdbcToolKit.discardAddedInDrivers();
    }

    protected void okPressed() {
        if (!this.jarChanged && this.jarsToBeCopied.size() == 0 && this.jarsToBeDeleted.size() == 0 && this.jarsToBeCopiedRuntime.size() == 0 && this.jarsToBeDeletedRuntime.size() == 0) {
            super.okPressed();
        } else {
            if (this.jarsToBeDeleted.values().iterator().hasNext()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)JdbcPlugin.getResourceString("driverManagerDialog.fileDelete.title"), (String)JdbcPlugin.getResourceString("driverManagerDialog.fileDelete.text"));
            }
            this.okPressedProcess();
        }
    }

    private void okPressedProcess() {
        JDBCDriverInformation info;
        Utility.setPreferenceStoredMap("JDBC Jar List", this.jarMap);
        Utility.setPreferenceStoredMap("JDBC Driver Map", this.driverMap);
        Iterator jarsCopyIterator = this.jarsToBeCopied.values().iterator();
        JDBCDriverManager manager = JDBCDriverManager.getInstance();
        ArrayList drivers = new ArrayList();
        ArrayList<JarFile> jarList = new ArrayList<JarFile>();
        while (jarsCopyIterator.hasNext()) {
            JarFile jar = (JarFile)jarsCopyIterator.next();
            jar.copyJarToODADir();
            Utility.removeMapEntryFromPreferenceStoredMap("Deleted Jar List", jar.getFileName());
            jarList.add(jar);
        }
        if (jarList.size() > 0) {
            drivers.addAll(JdbcToolKit.getDriverByJar(jarList));
            int i = 0;
            while (i < drivers.size()) {
                info = (JDBCDriverInformation)drivers.get(i);
                try {
                    String driverClassName = info.getDriverClassName();
                    manager.loadAndRegisterDriver(driverClassName, null);
                }
                catch (OdaException e) {
                    logger.log(Level.WARNING, "", e);
                    MessageDialog.openError(null, (String)JdbcPlugin.getResourceString("driverManagerDialog.ErrorDialog.addDriver.title"), (String)(JdbcPlugin.getResourceString("driverManagerDialog.ErrorDialog.addDriver.message") + info.getDriverClassName()));
                }
                ++i;
            }
            drivers.clear();
        }
        Iterator jarsDeleteIterator = this.jarsToBeDeleted.values().iterator();
        ArrayList<JarFile> deletedJars = new ArrayList<JarFile>();
        while (jarsDeleteIterator.hasNext()) {
            JarFile jar = (JarFile)jarsDeleteIterator.next();
            jar.deleteJarFromODADir();
            Utility.putPreferenceStoredMapValue("Deleted Jar List", jar.getFileName(), jar);
            deletedJars.add(jar);
        }
        if (deletedJars.size() > 0) {
            drivers.addAll(JdbcToolKit.getDriverByJar(deletedJars));
            int i = 0;
            while (i < drivers.size()) {
                info = (JDBCDriverInformation)drivers.get(i);
                try {
                    manager.deregisterDriver(info.getDriverClassName());
                }
                catch (OdaException e) {
                    MessageDialog.openError(null, (String)JdbcPlugin.getResourceString("driverManagerDialog.ErrorDialog.deregisterDriver.title"), (String)(JdbcPlugin.getResourceString("driverManagerDialog.ErrorDialog.deregisterDriver.message") + info.getDriverClassName()));
                }
                ++i;
            }
        }
        this.refreshDriverPage();
        super.okPressed();
    }

    static class EditJdbcDriverDialog
    extends Dialog {
        private Label classNameLabel;
        private Text displayNameText;
        private Text templateText;
        private String className = "";
        private String displayName = "";
        private String template = "";

        public EditJdbcDriverDialog(Shell parentShell) {
            super(parentShell);
        }

        public void create() {
            super.create();
            Point pt = this.getShell().computeSize(-1, -1);
            pt.x = Math.max(pt.x, 400);
            this.getShell().setSize(pt);
            this.getShell().setText(JdbcPlugin.getResourceString("driverManagerDialog.text.EditDriverTitle"));
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 5;
            composite.setLayout((Layout)layout);
            Label lb = new Label(composite, 0);
            lb.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.EditDriverClassName"));
            this.classNameLabel = new Label(composite, 0);
            this.classNameLabel.setLayoutData((Object)new GridData(768));
            this.classNameLabel.setText(this.className);
            lb = new Label(composite, 0);
            lb.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.EditDriverDisplayName"));
            this.displayNameText = new Text(composite, 2048);
            this.displayNameText.setLayoutData((Object)new GridData(768));
            this.displayNameText.setText(this.displayName);
            this.displayNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    displayName = displayNameText.getText();
                }
            });
            lb = new Label(composite, 0);
            lb.setText(JdbcPlugin.getResourceString("driverManagerDialog.text.EditDriverTemplate"));
            this.templateText = new Text(composite, 2048);
            this.templateText.setLayoutData((Object)new GridData(768));
            this.templateText.setText(this.template);
            this.templateText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    template = templateText.getText();
                }
            });
            return composite;
        }

        void setDriverClassName(String name) {
            this.className = name;
            if (this.classNameLabel != null) {
                this.classNameLabel.setText(name);
            }
        }

        void setDisplayName(String name) {
            this.displayName = name;
            if (this.displayNameText != null) {
                this.displayNameText.setText(name);
            }
        }

        void setUrlTemplate(String name) {
            this.template = name;
            if (this.templateText != null) {
                this.templateText.setText(name);
            }
        }

        String getDisplayName() {
            return this.displayName == null ? "" : this.displayName;
        }

        String getUrlTemplate() {
            return this.template == null ? "" : this.template;
        }
    }
}

