/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc.document;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.toc.ITOCConstants;
import org.eclipse.birt.report.engine.toc.ITOCWriter;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCEntry;
import org.eclipse.birt.report.engine.toc.document.DocTreeNode;

public class TOCWriterV3
implements ITOCWriter,
ITOCConstants {
    private RAOutputStream out;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
    private DataOutputStream output = new DataOutputStream(this.buffer);
    private DocTreeNode root;
    private long offset;

    public TOCWriterV3(RAOutputStream out) throws IOException {
        this.out = out;
        IOUtil.writeString((DataOutputStream)this.output, (String)"__Version : 3.0");
        out.write(this.buffer.toByteArray());
        this.offset = out.getOffset();
        this.root = new DocTreeNode();
        this.root.setNodeId("/");
        this.root.offset = (int)this.offset;
        this.writeTreeNode(this.root);
    }

    @Override
    public ITreeNode getTree() {
        return this.root;
    }

    DocTreeNode getParent(TOCEntry entry) {
        TOCEntry parent = entry.getParent();
        if (parent != null) {
            return (DocTreeNode)parent.getTreeNode();
        }
        return this.root;
    }

    @Override
    public void startTOCEntry(TOCEntry tocEntry) throws IOException {
        DocTreeNode node = new DocTreeNode(tocEntry);
        node.offset = (int)this.offset;
        DocTreeNode parent = this.getParent(tocEntry);
        node.setParent(parent);
        ++parent.childCount;
        this.writeTreeNode(node);
        tocEntry.setTreeNode(node);
    }

    @Override
    public void closeTOCEntry(TOCEntry entry) throws IOException {
        DocTreeNode node = (DocTreeNode)entry.getTreeNode();
        if (node != null && node.childCount > 0) {
            this.out.seek((long)(node.offset + 8));
            this.out.writeInt(node.childCount);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try {
                if (this.root != null) {
                    if (this.root.childCount > 0) {
                        this.out.seek((long)(this.root.offset + 8));
                        this.out.writeInt(this.root.childCount);
                    }
                    this.root = null;
                }
                this.out.close();
            }
            finally {
                this.out = null;
            }
        }
    }

    protected synchronized void writeTreeNode(DocTreeNode node) throws IOException {
        this.out.seek((long)node.offset);
        this.out.writeInt(node.next);
        this.out.writeInt(node.child);
        this.out.writeInt(node.childCount);
        this.offset += 12L;
        this.buffer.reset();
        node.writeNode(this.output);
        byte[] data = this.buffer.toByteArray();
        this.out.writeInt(data.length);
        this.out.write(data);
        this.offset += 4L;
        this.offset += (long)data.length;
        this.updateIndex(node);
    }

    protected synchronized void updateIndex(DocTreeNode node) throws IOException {
        DocTreeNode parent = node.getParent();
        if (parent == null) {
            return;
        }
        if (parent.child == -1) {
            this.out.seek((long)(parent.offset + 4));
            this.out.writeInt(node.offset);
        } else {
            this.out.seek((long)(parent.child + 0));
            this.out.writeInt(node.offset);
        }
        parent.child = node.offset;
    }
}

