/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.optimize;

import java.util.HashMap;
import org.eclipse.birt.report.engine.data.optimize.QueryState;

public class QueryCache {
    private HashMap<Object, QueryState> query2state = new HashMap();
    private HashMap cachedQueries = new HashMap();

    public boolean needExecute(Object query, Object owner, boolean cached) {
        if (owner == null) {
            return true;
        }
        QueryState state = this.query2state.get(query);
        if (state == null) {
            state = new QueryState();
            this.query2state.put(query, state);
        }
        if (state.count() == 0) {
            state.addOwner(owner);
            state.setCached(cached);
            return true;
        }
        if (state.isOwnerAdded(owner)) {
            if (state.cached() && cached) {
                state.setCached(cached);
                state.resetOwner(owner);
                return false;
            }
            state.setCached(cached);
            state.resetOwner(owner);
            return true;
        }
        if (state.cached() && !cached) {
            state.setCached(false);
            state.addOwner(owner);
            return false;
        }
        state.addOwner(owner);
        return false;
    }

    public void putCachedQuery(Object query, Object rsid) {
        this.cachedQueries.put(query, rsid);
    }

    public Object getCachedQuery(Object query) {
        return this.cachedQueries.get(query);
    }

    public void close() {
        this.query2state.clear();
        this.cachedQueries.clear();
    }

    public boolean getState(Object query) {
        QueryState state = this.query2state.get(query);
        return state.cached();
    }
}

