/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.viewer.browsers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.birt.report.viewer.browsers.BrowserDescriptor;
import org.eclipse.birt.report.viewer.browsers.CurrentBrowser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.browser.IBrowserFactory;

public class BrowserManager {
    public static final String ALWAYS_EXTERNAL_BROWSER_KEY = "always_external_browser";
    public static final String DEFAULT_BROWSER_ID_KEY = "default_browser";
    public static final String BROWSER_ID_CUSTOM = "org.eclipse.birt.report.viewer.custombrowser";
    public static final String BROWSER_ID_EMBEDDED = "org.eclipse.birt.report.viewer.embeddedbrowser";
    public static final String BROWSER_ID_SYSTEM = "org.eclipse.birt.report.viewer.systembrowser";
    private static BrowserManager instance;
    private Collection browsers = new ArrayList();
    private BrowserDescriptor[] browsersDescriptors;
    private BrowserDescriptor currentBrowserDesc;
    private BrowserDescriptor defaultBrowserDesc;
    private BrowserDescriptor internalBrowserDesc;
    private boolean alwaysUseExternal = false;

    public static synchronized BrowserManager getInstance() {
        if (instance == null) {
            instance = new BrowserManager();
            instance.init();
        }
        return instance;
    }

    private BrowserManager() {
    }

    private void init() {
        String curBrowserID;
        this.browsersDescriptors = this.createBrowserDescriptors();
        String defBrowserID = ViewerPlugin.getDefault().getPluginPreferences().getDefaultString(DEFAULT_BROWSER_ID_KEY);
        if (defBrowserID != null && !"".equals(defBrowserID)) {
            this.setDefaultBrowserID(defBrowserID);
        }
        if (this.defaultBrowserDesc == null) {
            this.setDefaultBrowserID(BROWSER_ID_EMBEDDED);
        }
        String os = Platform.getOS();
        if (this.defaultBrowserDesc == null && "win32".equalsIgnoreCase(os)) {
            this.setDefaultBrowserID(BROWSER_ID_SYSTEM);
        }
        if (this.defaultBrowserDesc == null) {
            int i = 0;
            while (i < this.browsersDescriptors.length) {
                if (BROWSER_ID_CUSTOM.equals(this.browsersDescriptors[i].getID())) {
                    this.defaultBrowserDesc = this.browsersDescriptors[i];
                }
                ++i;
            }
        }
        if (this.defaultBrowserDesc == null) {
            this.setDefaultBrowserID(BROWSER_ID_CUSTOM);
        }
        if ((curBrowserID = ViewerPlugin.getDefault().getPluginPreferences().getString(DEFAULT_BROWSER_ID_KEY)) != null && !"".equals(curBrowserID)) {
            this.setCurrentBrowserID(curBrowserID);
        }
        if (this.currentBrowserDesc == null) {
            this.setCurrentBrowserID(this.getDefaultBrowserID());
        }
        this.setAlwaysUseExternal(ViewerPlugin.getDefault().getPluginPreferences().getBoolean(ALWAYS_EXTERNAL_BROWSER_KEY));
    }

    private BrowserDescriptor[] createBrowserDescriptors() {
        if (this.browsersDescriptors != null) {
            return this.browsersDescriptors;
        }
        ArrayList<BrowserDescriptor> bDescriptors = new ArrayList<BrowserDescriptor>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.birt.report.viewer", "browser");
        int i = 0;
        while (i < configElements.length) {
            String label;
            String id;
            if (configElements[i].getName().equals("browser") && (id = configElements[i].getAttribute("id")) != null && (label = configElements[i].getAttribute("name")) != null) {
                try {
                    Object adapter = configElements[i].createExecutableExtension("factoryclass");
                    if (adapter instanceof IBrowserFactory && ((IBrowserFactory)adapter).isAvailable()) {
                        BrowserDescriptor descriptor = new BrowserDescriptor(id, label, (IBrowserFactory)adapter);
                        if (descriptor.isExternal()) {
                            bDescriptors.add(descriptor);
                        } else {
                            this.internalBrowserDesc = descriptor;
                        }
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++i;
        }
        this.browsersDescriptors = bDescriptors.toArray(new BrowserDescriptor[bDescriptors.size()]);
        return this.browsersDescriptors;
    }

    public BrowserDescriptor[] getBrowserDescriptors() {
        return this.browsersDescriptors;
    }

    public String getCurrentBrowserID() {
        if (this.currentBrowserDesc == null) {
            return null;
        }
        return this.currentBrowserDesc.getID();
    }

    public String getCurrentInternalBrowserID() {
        if (this.isEmbeddedBrowserPresent() && !this.alwaysUseExternal) {
            return this.internalBrowserDesc.getID();
        }
        return this.getCurrentBrowserID();
    }

    public String getDefaultBrowserID() {
        if (this.defaultBrowserDesc == null) {
            return null;
        }
        return this.defaultBrowserDesc.getID();
    }

    public void setCurrentBrowserID(String currentAdapterID) {
        int i = 0;
        while (i < this.browsersDescriptors.length) {
            if (this.browsersDescriptors[i].getID().equals(currentAdapterID)) {
                this.currentBrowserDesc = this.browsersDescriptors[i];
                return;
            }
            ++i;
        }
    }

    private void setDefaultBrowserID(String defaultAdapterID) {
        int i = 0;
        while (i < this.browsersDescriptors.length) {
            if (this.browsersDescriptors[i].getID().equals(defaultAdapterID)) {
                this.defaultBrowserDesc = this.browsersDescriptors[i];
                return;
            }
            ++i;
        }
    }

    public IBrowser createBrowser(boolean external) {
        if (external) {
            return new CurrentBrowser(this.createBrowserAdapter(true), this.getCurrentBrowserID(), true);
        }
        return new CurrentBrowser(this.createBrowserAdapter(this.alwaysUseExternal), this.getCurrentInternalBrowserID(), false);
    }

    public IBrowser createBrowser() {
        return this.createBrowser(true);
    }

    private IBrowser createBrowserAdapter(boolean external) {
        IBrowser browser = null;
        browser = !external && this.isEmbeddedBrowserPresent() ? this.internalBrowserDesc.getFactory().createBrowser() : this.currentBrowserDesc.getFactory().createBrowser();
        this.browsers.add(browser);
        return browser;
    }

    public void closeAll() {
        for (IBrowser browser : this.browsers) {
            browser.close();
        }
    }

    public boolean isEmbeddedBrowserPresent() {
        return this.internalBrowserDesc != null;
    }

    public void setAlwaysUseExternal(boolean alwaysExternal) {
        this.alwaysUseExternal = alwaysExternal || !this.isEmbeddedBrowserPresent();
    }
}

