/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.resourcelocator;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public abstract class BaseResourceEntity
implements ResourceEntry {
    @Override
    public Image getImage() {
        Object adapter = this.getAdapter(LibraryHandle.class);
        if (adapter != null) {
            return ProviderFactory.createProvider(adapter).getNodeIcon(adapter);
        }
        adapter = this.getAdapter(CssStyleSheetHandle.class);
        if (adapter != null) {
            return ProviderFactory.createProvider(adapter).getNodeIcon(adapter);
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    @Override
    public String getName() {
        return this.getURL().getFile();
    }

    @Override
    public void dispose() {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ResourceEntry.class) {
            return this;
        }
        return null;
    }

    public boolean hasChildren(ResourceEntry.Filter filter) {
        return this.getChildren(filter).length > 0;
    }

    @Override
    public ResourceEntry[] getChildren(ResourceEntry.Filter filter) {
        ResourceEntry[] children = this.getChildren();
        ArrayList<ResourceEntry> childrenFiltered = new ArrayList<ResourceEntry>();
        int i = 0;
        while (i < children.length) {
            if (filter.accept(children[i])) {
                childrenFiltered.add(children[i]);
            }
            ++i;
        }
        return childrenFiltered.toArray(new ResourceEntry[childrenFiltered.size()]);
    }
}

